<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMilestoneTestDeadlinesChosen is autogenerate by UniModel generator
 *
 * This is the model class for table "milestone_test_deadlines_chosen".
 *
 * The followings are the available columns in table 'milestone_test_deadlines_chosen':
 * @property string $milestone_test_deadlines_chosen_id
 * @property string $user_ref_id
 * @property integer $entrance_exam_ref_id
 * @property string $entrance_exam_date_label_ref_id
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property EntranceExamDateLabel $entranceExamDateLabelRef
 * @property EntranceExam $entranceExamRef
 * @property TblUserMaster $userRef
 */
class BaseMilestoneTestDeadlinesChosen extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MilestoneTestDeadlinesChosen the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'milestone_test_deadlines_chosen';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, entrance_exam_date_label_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('milestone_test_deadlines_chosen_id, user_ref_id, entrance_exam_ref_id, entrance_exam_date_label_ref_id, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamDateLabelRef' => array(self::BELONGS_TO, 'EntranceExamDateLabel', 'entrance_exam_date_label_ref_id'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'milestone_test_deadlines_chosen_id' => 'Milestone Test Deadlines Chosen',
			'user_ref_id' => 'User Ref',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'entrance_exam_date_label_ref_id' => 'Entrance Exam Date Label Ref',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('milestone_test_deadlines_chosen_id',$this->milestone_test_deadlines_chosen_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('entrance_exam_date_label_ref_id',$this->entrance_exam_date_label_ref_id,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}