<?php

class EventsController extends Controller{
    
    private $_curl;
    private $_upcoming_events_url = 'https://api.citrixonline.com/G2W/rest/organizers/4020093041029951749/upcomingWebinars';
    private $_past_events_url = 'https://api.citrixonline.com/G2W/rest/organizers/4020093041029951749/historicalWebinars';
    private $_webinar_url = 'https://api.citrixonline.com/G2W/rest/organizers/4020093041029951749/webinars/';
    private $_access_token = 'pj5pTRghHQvbRpZZ0YsD5sa10Pgl';
    
    public function filters() {
        return array(
            'rights',
            'accessControl',
            'postOnly + delete',
        );
    }    
    
    public function init() {
        parent::init();
        Yii::app()->theme = 'pms';
        $this->layout = "//layouts/pms_layout";
    }
    
    public function actionIndex(){
        
        $event_type = Yii::app()->request->getParam('event_type',0);
        $filters = array();
        $filters['country'] = Yii::app()->request->getParam('country',null);
        $filters['major'] = Yii::app()->request->getParam('major',null);
        $filters['counselor'] = Yii::app()->request->getParam('counselor',null);
        $filters['event_name'] = Yii::app()->request->getParam('event_name',null);
        
        if(!$event_type){
            $data = WebinarEvent::get_upcoming_events($filters, ($filters['country'] || $filters['counselor'] || $filters['major'])?false:true);
        }else{
            $data = WebinarEvent::get_past_events($filters, ($filters['country'] || $filters['counselor'] || $filters['major'])?false:true);
        }
        
        if(Yii::app()->request->isAjaxRequest){
            $this->renderPartial('_search',compact('data','event_type'),false, true);
        }else{
            $this->render('index',compact('data','event_type'));
        }
    }
    
    
    
    public function actionedit(){
        $id = Yii::app()->request->getParam('id',0);
        if(!WebinarEvent::model()->exists('event_id = :id',array(':id'=>$id))) throw new CHttpException(404,'Page Not Found');
        
        $event_type = Yii::app()->request->getParam('event_type',0);
        $event = WebinarEvent::model()->findByPk($id);
        
        $db_results = Yii::app()->db->createCommand()
                ->select('Di.di_id, TblUniversityMaster.uni_id, TblUniversityMaster.uni_name')
                ->from(Di::model()->tableSchema->name.' Di')
                ->join(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster', 'Di.uni_ref_id = TblUniversityMaster.uni_id')
                ->join(DiWebinarProduct::model()->tableSchema->name.' DiWebinarProduct', 'DiWebinarProduct.di_ref_id = Di.di_id AND DiWebinarProduct.is_active = "Y"')
                ->where('Di.is_active = 1 AND Di.is_test = "N" AND DiWebinarProduct.duration_end_date >= :date', array(':date' => date('Y-m-d')))
                ->queryAll();
        $di_accounts = CHtml::listData($db_results, 'di_id', 'uni_name');
        
        if(Yii::app()->request->isPostRequest){
            $webinar_event = Yii::app()->request->getParam('WebinarEvent');
            
            $event->attributes = $webinar_event;
            $event->speaker_name_visible = $webinar_event['speaker_name_visible'];
            $event->speaker_desig_visible = $webinar_event['speaker_desig_visible'];
            $event->speaker_org_visible = $webinar_event['speaker_org_visible'];
            $event->event_type = $webinar_event['event_type'];
            $event->is_active = $webinar_event['is_active'];
            
            $transaction = Yii::app()->db->beginTransaction();
            
            try {
                
                $event->upload_file('speaker_sign', Yii::app()->params['docRootPath'] .'/app/images/webinar/speakers');
                
                if(!$event->save()) throw new CDbException('Event Save Failed');
                
                WebinarEventCountries::model()->deleteAll('event_ref_id = '.$event->event_id);
                
                $countries = Yii::app()->request->getParam('WebinarEventCountries',array());
                $WebinarEventCountry = new WebinarEventCountries;
                $WebinarEventCountry->event_ref_id = $event->event_id;
                foreach($countries['country_ref_id'] as $c_id ){
                    unset($WebinarEventCountry->tbl_events_countries_id);
                    $WebinarEventCountry->setIsNewRecord(TRUE);
                    $WebinarEventCountry->country_ref_id = $c_id;
                    if(!$WebinarEventCountry->save()) throw new CDbException('event country save failed');
                }
                
                $departments = Yii::app()->request->getParam('WebinarEventDepartments',array());
                WebinarEventDepartments::model()->deleteAll('event_ref_id = '.$event->event_id);
                
                $WebinarEventDepartment = new WebinarEventDepartments;
                $WebinarEventDepartment->event_ref_id = $event->event_id;
                foreach($departments['department_ref_id'] as $d_id){
                    unset($WebinarEventDepartment->tbl_events_departments_id);
                    $WebinarEventDepartment->setIsNewRecord(TRUE);
                    $WebinarEventDepartment->department_ref_id = $d_id;
                    if(!$WebinarEventDepartment->save()) throw new CDbException('event department save failed');
                }
                
                $promotional_titles = Yii::app()->request->getParam('promotional_titles', array());
                $promotional_videos = Yii::app()->request->getParam('promotional_videos', array());
                $is_promoted = Yii::app()->request->getParam('is_promoted', array());
                
                WebinarEventVideos::model()->deleteAll('event_ref_id = '.$event->event_id);

                foreach(array_filter($promotional_titles, 'strlen') as $key => $p_title){
                    $event_video = new WebinarEventVideos;
                    $event_video->event_ref_id = $event->event_id;
                    $event_video->title = $p_title;
                    $event_video->video_link = $promotional_videos[$key];
                    $event_video->is_promoted = $is_promoted[$key];
                    $event_video->is_active = 'Y';
                    $event_video->added_on = date('Y-m-d H:i:s');
                    $event_video->added_by = Yii::app()->user->id;
                    $event_video->save();
                }
                
                $di_webinar = Yii::app()->request->getParam('DiWebinar', array());
                if($di_webinar['di_ref_id'] && $di_webinar['di_webinar_product_ref_id']){
                    $DiWebinar = DiWebinar::model()->find('webinar_ref_id = :event_id', array(':event_id' => $event->event_id));
                    if(!$DiWebinar) $DiWebinar = new DiWebinar;
                    $DiWebinar->webinar_ref_id = $event->event_id;
                    $DiWebinar->di_ref_id = $di_webinar['di_ref_id'];
                    $DiWebinar->di_webinar_product_ref_id = $di_webinar['di_webinar_product_ref_id'];
                    if(!$DiWebinar->save(FALSE)) throw new CDbException('di_webianr save failed');
                }
                
                $transaction->commit();
                Yii::app()->user->setFlash('alert-success', "Webinar Updated!");
                $this->redirect($this->createUrl('view',array('event_type' => $event_type,'id' => $event->event_id)));
            } catch (Exception $exc) {
                Yii::app()->user->setFlash('alert-error', $exc->getMessage());
                $transaction->rollback();
            }
                    
        }
        $this->render('edit',  compact('event','event_type', 'di_accounts'));
    }
    
    
    public function actionview(){
        $id = Yii::app()->request->getParam('id',0);
        if(!WebinarEvent::model()->exists('event_id = :id',array(':id'=>$id))) throw new CHttpException(404,'Page Not Found');
        $event_type = Yii::app()->request->getParam('event_type',0);
        $event = WebinarEvent::model()->findByPk($id);
        
        $db_product = Yii::app()->db->createCommand()
                ->select('TblUniversityMaster.uni_name, DiWebinarProduct.product_name')
                ->from(DiWebinar::model()->tableSchema->name.' DiWebinar')
                ->join(DiWebinarProduct::model()->tableSchema->name.' DiWebinarProduct', 'DiWebinarProduct.di_webinar_product_id = DiWebinar.di_webinar_product_ref_id')
                ->join(Di::model()->tableSchema->name.' Di', 'Di.di_id = DiWebinar.di_ref_id')
                ->join(TblUniversityMaster::model()->tableSchema->name.' TblUniversityMaster', 'TblUniversityMaster.uni_id = Di.uni_ref_id')
                ->where('DiWebinar.webinar_ref_id = '.$id)
                ->queryRow();
        
        $this->render('view',compact('event','event_type', 'db_product'));
    }
    
    private function _get_webinar($webinar_key){
        
        $headers = array(
            "Accept: application/json",
            "Content-type:application/json",
            "Authorization: OAuth oauth_token=$this->_access_token",
        );

        $this->_curl = new Curl();
        $this->_curl->init();
        $this->_curl->setOptions(array(CURLOPT_HTTPHEADER => $headers));
        $response = $this->_curl->get($this->_webinar_url.$webinar_key);
        
        return json_decode($response,TRUE, 512, JSON_BIGINT_AS_STRING);
    }
    
    private function _get_events($event_type = 0, $from_time = null,$to_time = null){
        
        if(!$from_time) $from_time = '2013-04-16T18:00:00Z';
        if(!$to_time) $to_time = date('Y-m-d').'T'.date('H:i:s').'Z';
        
        $headers = array(
            "Accept: application/json",
            "Content-type:application/json",
            "Authorization: OAuth oauth_token=$this->_access_token",
        );
        
        $api_url = $this->_upcoming_events_url;
        if($event_type){
            $api_url = $this->_past_events_url.'?fromTime='.$from_time.'&toTime='.$to_time;
        }
        
        $this->_curl = new Curl();
        $this->_curl->init();
        $this->_curl->setOptions(array(CURLOPT_HTTPHEADER => $headers));
        $response = $this->_curl->get($api_url);
        $request_info = $this->_curl->getInfo();
        
        if($request_info['http_code'] !== 200){
            print_r($request_info);
            print_r($response);
            Yii::app()->end(1,true);
        }
        
        return json_decode($response, ture, 512, JSON_BIGINT_AS_STRING)?json_decode($response, ture, 512, JSON_BIGINT_AS_STRING):CJSON::decode($response);
    }
    
    public function actionupdate_events(){
        echo 'Getting past events...'.PHP_EOL;
        $past_events = $this->_get_events(1);
        echo count($past_events).' past events found'.PHP_EOL;
        echo "Getting upcoming events...".PHP_EOL;
        $upcoming_events = $this->_get_events();
        echo count($upcoming_events). ' upcoming events found'.PHP_EOL;
        
        $events = array_merge($upcoming_events,$past_events);
        echo 'total '.count($events).' events found'.PHP_EOL;
        
        foreach($events as $e){
            
            $event = WebinarEvent::model()->find('webinar_key = "'.$e['webinarKey'].'"');
            if(!$event) $event = new WebinarEvent;
            
            $event->webinar_key = $e['webinarKey'];
            $event->event_title = $e['subject'];
            
            $start_time = DateTime::createFromFormat('Y-m-d\TH:i:s\Z', $e['times'][0]['startTime'], new DateTimeZone('UTC'));
            //$start_time->setTimeZone(new DateTimeZone('UTC'));
            $event->event_start_time = $start_time->format('YmdHis');
            
            $end_time = DateTime::createFromFormat('Y-m-d\TH:i:s\Z', $e['times'][0]['endTime'], new DateTimeZone('UTC'));
            //$end_time->setTimeZone(new DateTimeZone('UTC'));
            $event->event_end_time = $end_time->format('YmdHis');
            
            $event->timezone = $e['timeZone'];
            $event->event_desc = $e['description'];
            
            if($event->isNewRecord) $event->is_active = 'N';
            
            if(!$event->save(FALSE)){
                echo 'event save failed'.PHP_EOL;
                Yii::app()->end();
            }
            
        }
        return true;
        
    }
    
    
    public function actiondelete_country(){
        $id = Yii::app()->request->getParam('country',0);
        if(!WebinarEventCountries::model()->exists('tbl_events_countries_id = :id',array(':id' => $id))) throw new CHttpException(404,'Page Not Found');
        $country = WebinarEventCountries::model()->findByPk($id);
        if($country) $country->delete();
        Yii::app()->end();
    }
    
    public function actiondelete_major(){
        $id = Yii::app()->request->getParam('major',0);
        if(!WebinarEventDepartments::model()->exists('tbl_events_departments_id = :id',array(':id' => $id))) throw new CHttpException(404,'Page Not Found');
        $major = WebinarEventDepartments::model()->findByPk($id);
        if($major) $major->delete();
        Yii::app()->end();
    }
    
    public function actionget_di_products(){
        $di_id = Yii::app()->request->getParam('di_id');
        if($di_id){
            $products = Yii::app()->db->createCommand()
                    ->select('DiWebinarProduct.di_webinar_product_id, DiWebinarProduct.product_name')
                    ->from(DiWebinarProduct::model()->tableSchema->name.' DiWebinarProduct')
                    ->where('DiWebinarProduct.di_ref_id = :di_id AND DiWebinarProduct.duration_end_date >= :date AND DiWebinarProduct.is_active = "Y"', array(':di_id' => $di_id, ':date' => date('Y-m-d')))
                    ->queryAll();
            foreach($products as $product){
                echo CHtml::tag('option', array('value' => $product['di_webinar_product_id']), $product['product_name']);
            }
        }
        Yii::app()->end();
    }
    
}
