
<section id="section1" class="section">
	<div class="div-inner-gutter-space">
        <?php
        $form = $this->beginWidget('CActiveForm', [
            'id'=>'profile-form',
            'enableClientValidation'=>false,
            'enableAjaxValidation'=>true,
            'clientOptions' =>array(
                'validateOnSubmit'=>true,
                'validateOnChange' => true,
                'validateOnType' => true,
                'beforeValidate'  => 'js:function(form){
                    $("div.errorMessage").hide();
                    return true;
                }',
                'afterValidate' => 'js:function(form, data, hasError){
                    if(!$.isEmptyObject(data)){
                        for(var i in data) {
                           var id = i, message = data[i][0];
                           $("#"+i+"_em_").html(message).show();
                        }
                        return false;
                    }else{
                        return true;
                    }
                }',
            )
        ]);
        ?>
		<style>
			.error{
				border: none !important	;
			}
			.error input, .error select{
				border: 1px solid #FC8383 !important;
			}
            .div-inner-gutter-space{
                padding: 30px 0px 0px !important;
            }
			.row.gutter_vertical{
                padding-bottom: 14px;
            }
            .errorMessage.popup {
                background-position: 0 100%;
                background-repeat: no-repeat;
                position: absolute;
                bottom: 99%;
                left: 0;
                right: auto;
                top: auto;
                font-size: 14px;
                color: #fff;
                line-height: 15px;
                font-weight: 500;
                white-space: nowrap;
                padding: 0 0 6px 0 !important;
            }

            .errorMessage.popup .holder {
                display: inline-block;
                background-color: #fc8486;
                padding: 7px 11px 7px 11px !important;
                -webkit-border-radius: 2px;
                -moz-border-radius: 2px;
                -ms-border-radius: 2px;
                -o-border-radius: 2px;
                border-radius: 2px;
            }

            .errorMessage.popup .holder p {
                margin: 0 0 0 0;
            }
        </style>

        <div class="clearfix row multi_line gutter_vertical white visible">
			<div class="row visible gutter_vertical border clearfix">
				<div class="grid_3 left">Name</div>
				<div class="left grid_3 relative">
                <?php
                    echo $form->textField($model,'full_name', ['class' => 'grid_3 input', 'placeholder'=>'Enter name']);
                    echo $form->error($model,'full_name', ['class'=>'errorMessage popup']);
                ?>
				</div>
				<div class="left grid_3">
					&nbsp;
				</div>
				<div class="pull">
					&nbsp;
				</div>
			</div>
            <div class="row visible gutter_vertical border clearfix">
                <div class="grid_3 left">Email</div>
                <div class="left grid_3 relative">
                    <?php
                    echo $form->textField($model,'email', ['class' => 'grid_3 input', 'placeholder'=>'Enter email']);
                    echo $form->error($model,'email',['class'=>'errorMessage popup']);
                    ?>
                </div>
                <div class="left grid_3">
                    &nbsp;
                </div>
                <div class="pull">
                    &nbsp;
                </div>
            </div>

            <div class="row visible gutter_vertical border clearfix">
                <div class="grid_3 left">Gender</div>
                <div class="left grid_3 relative">
                    <?php
                    echo $form->dropDownList(
                        $model,'gender', ['m'=>'Male', 'f'=>'Female'],
                        array('empty' => 'Choose a gender', 'class' => 'select grid_3')
                    );
                    echo $form->error($model,'gender',['class'=>'errorMessage popup']);
                    ?>
                </div>
                <div class="left grid_3">
                    &nbsp;
                </div>
                <div class="pull">
                    &nbsp;
                </div>
            </div>

            <div class="row visible gutter_vertical border clearfix">
                <div class="grid_3 left">Class</div>
                <div class="left grid_3 relative">
                    <?php
                    echo $form->dropDownList(
                        $model,'present_class', $model->getClassLevels(),
                        array('empty' => 'Current Class', 'class' => 'select grid_3')
                    );
                    echo $form->error($model,'present_class',['class'=>'errorMessage popup']);
                    ?>
                </div>
                <div class="left grid_3">
                    &nbsp;
                </div>
                <div class="pull">
                    &nbsp;
                </div>
            </div>

            <div class="row visible gutter_vertical border clearfix">
                <div class="grid_3 left">School Name</div>
                <div class="left grid_3 relative">
                    <?php
                    echo $form->hiddenField($model,'school_id');
                    $this->widget('zii.widgets.jui.CJuiAutoComplete',array(
                        'attribute'=>'school_name',
                        'model' => $model,
                        'source'=> $this->createUrl('getSchoolNames'),
                        'options'=> array(
                            'minLength'=>'1',
                            'select'=>'js:function(event, ui){
                                $("#'.CHtml::activeId($model, 'school_id').'").val(ui.item.id);
                            }',
                            'change'=>'js:function( event, ui ) {
                                if(!ui.item){
                                    $("#'.CHtml::activeId($model, 'school_id').'").val("");
                                }
                            }',
                        ),
                        'htmlOptions'=>array(
                            'placeholder'=>'Your School Name',
                            'class'=>'input grid_3',
                        ),
                    ));

                    echo $form->error($model,'school_name',['class'=>'errorMessage popup']);
                    ?>
                </div>
                <div class="left grid_3">
                    &nbsp;
                </div>
                <div class="pull">
                    &nbsp;
                </div>
            </div>

            <div class="row gutter_vertical" style="text-align: center;">
                <button class="button-blue tny">Create</button>
			</div>
		</div>
        <?php $this->endWidget(); ?>
	</div>
</section>
