<?php
 
/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.modules.diadmin.models.base.BaseDiProductCredit');

class DiProductCredit extends BaseDiProductCredit
{

    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('di_ref_id, product_ref_id, added_on, added_by', 'required'),
           // array('product_ref_id', 'CustomRule'),
            array('di_ref_id, product_ref_id, credit_count', 'numerical', 'integerOnly'=>true),
            array('added_by, modified_by', 'length', 'max'=>10),
            array('modified_on', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('di_product_credit_id, di_ref_id, product_ref_id, credit_count, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
        );
    }

    /*
     * function creating for custom rules to call them in model file
     */

    public function CustomRule($attribute,$params)
    {
        if(isset($this->di_product_credit_id)){
            $result =    DiProductCredit::model()->exists('di_ref_id= :x AND product_ref_id =:y AND di_product_credit_id !=:z',array(':x'=>$this->di_ref_id,':y'=>$this->$attribute,':z'=>$this->di_product_credit_id));
        }else{
            $result =    DiProductCredit::model()->exists('di_ref_id= :x AND product_ref_id =:y',array(':x'=>$this->di_ref_id,':y'=>$this->$attribute));
        }
        if($result)
            $this->addError($attribute, 'Already Exit in database. Please select another Product');
    }

    /*
     * function using in this admin.php file using in CGridView
     */
    public function ProductName($data,$row){
        return $data->productRef->product_description;
    }

    /*
     * function using in this admin.php file using in CGridView
     */
    public function UserName($data,$row){
        $Name   =   $data->diRef->diUsers[0]->first_name .' ' .$data->diRef->diUsers[0]->last_name;
        return $Name;
    }


    public function searchCustom()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $di_id  =   Yii::app()->getRequest()->getQuery('di_id');
        $criteria=new CDbCriteria;

        $criteria->compare('di_product_credit_id',$this->di_product_credit_id,true);
        $criteria->compare('di_ref_id',$di_id);
        $criteria->compare('product_ref_id',$this->product_ref_id);
        $criteria->compare('credit_count',$this->credit_count);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('added_by',$this->added_by,true);
        $criteria->compare('modified_on',$this->modified_on,true);
        $criteria->compare('modified_by',$this->modified_by,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    public function getDiFreeCreditsInfo($diRefId=0){
        $sql = "SELECT
DPC.product_ref_id, LP.product_description, SUM(DPC.credit_count) AS credit_count
FROM di_product_credit  DPC
JOIN lookup_product LP ON LP.product_id = DPC.product_ref_id
WHERE
DPC.di_ref_id = :diRefId
AND LP.product_shortcode NOT IN ('AppSLA', 'AppSUC', 'AdmSLA', 'AdmSUC')
GROUP BY DPC.product_ref_id";
        $command = Yii::app()->db->createCommand($sql);
        $command->bindParam(":diRefId", $diRefId, PDO::PARAM_INT);
        $result = $command->queryAll();
        return $result;
    }
}