<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.modules.diadmin.models.base.BaseDi');

class Di extends BaseDi
{
	public $TempUniversityRef = "";
    public $uni_name;
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required','message'=>'Please enter valid university'),
			array('di_type_ref_id, currency_ref_id, added_by, added_on', 'required'),
			array('uni_ref_id','unique','message'=>'Di Already Created for this University '),
			array('uni_ref_id, di_type_ref_id, currency_ref_id, credit_limit, is_active', 'numerical', 'integerOnly'=>true),
			array('added_by, modified_by', 'length', 'max'=>10),
            array('eoi_expires_in', 'length', 'max'=>5),
            array('is_autobuy_active, is_test', 'length', 'max'=>1),
			array('modified_on, uni_name', 'safe'),
            array('uniname_invoice', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
            array('di_id, uni_ref_id, di_type_ref_id, currency_ref_id, credit_limit, uniname_invoice, eoi_expires_in,is_autobuy_active, is_active, added_by, added_on, modified_by, modified_on, is_test', 'safe', 'on'=>'search'),
		);
	}

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'di_id' => 'Di',
            'uni_ref_id' => 'University',
            'di_type_ref_id' => 'DI Type',
            'currency_ref_id' => 'Currency',
            'credit_limit' => 'Credit Limit',
            'uniname_invoice' => 'Invoice Name',
            'eoi_expires_in' => 'Eoi Expires In',
            'is_autobuy_active' => 'Is Autobuy Active',
            'is_active' => 'Is Active',
            'added_by' => 'Added By',
            'added_on' => 'Added On',
            'modified_by' => 'Modified By',
            'modified_on' => 'Modified On',
            'is_test' => 'Is Test',
        );
    }

    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria=new CDbCriteria;
        if($this->uni_name){
            $criteria->with = array('uniRef');
            $criteria->compare("uniRef.uni_name", $this->uni_name, true);
        }
        $criteria->compare('di_id',$this->di_id);
        $criteria->compare('uni_ref_id',$this->uni_ref_id);
        $criteria->compare('di_type_ref_id',$this->di_type_ref_id);
        $criteria->compare('currency_ref_id',$this->currency_ref_id);
        $criteria->compare('credit_limit',$this->credit_limit);
        $criteria->compare('uniname_invoice',$this->uniname_invoice,true);
        $criteria->compare('eoi_expires_in',$this->eoi_expires_in,true);
        $criteria->compare('is_autobuy_active',$this->is_autobuy_active,true);
        $criteria->compare('is_active',$this->is_active);
        $criteria->compare('added_by',$this->added_by,true);
        $criteria->compare('added_on',$this->added_on,true);
        $criteria->compare('modified_by',$this->modified_by,true);
        $criteria->compare('modified_on',$this->modified_on,true);
        $criteria->compare('is_test',$this->is_test,true);
        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }
	
}