<?php 
	Yii::import('application.modules.hotlead.models.*');
	Yii::import('application.modules.alertmatch.models.*');


/**
 * Helper clas for Di ( Destination Institutes )
 * UniRefIdData($term)
 * getCurrencyList()
 * getDiTypeList()
 * getDiTypeList()
 * getUserType()
 * countDiModerators($di_id)
 * getDepartmentList($di_user_id = "")
 * displayDepartments($di_user_id)
 *
 * Create Filters By using these functions
 * getDiHotLeadCountryList($di_user_ref_id)
 * getLikelyPeriods()
 * getApplyStatus()
 * getStudyLevels()
 *
 * createHotLeadSearchCriteria($searchArr)
 * createHotLeadSqlQuery($sqlCriteria)
 * getUniversityId($Di_Id = '0')
 */
class DiHelper extends DiHelperBase{


/**
  * Get array list of university name and id with limit of 15 rows
  */

	public static function UniRefIdData($term) {
		if (isset($term)) {
			$criteria				=	new CDbCriteria;
			$criteria->select 		=	"t.uni_id, t.uni_name";
			//$criteria->condition	=	"(t.uni_name LIKE '%" . $term . "%' OR t.uni_profile LIKE '%" . $term . "%') AND 			(t.is_active='Y')";
			$criteria->condition	=	"t.uni_name LIKE '%" . $term . "%' AND t.is_user_entered = '0'";
			$criteria->group = 't.uni_id';
			$term = mysql_escape_string($term);
			$criteria->order = "(CASE WHEN t.uni_name LIKE '$term%' THEN 0 ELSE 1 END ), t.uni_name";
			$criteria->limit		=	20; //15;
			$data					=	TblUniversityMaster::model()->findAll($criteria);
			
			$return_array = array();
				foreach($data as $result) {
				$return_array[] = array(
							'label'	=>	$result->uni_name,
							'value'	=>	$result->uni_name,
							'id'	=>	$result->uni_id,
							);
				}
		return CJSON::encode($return_array);
	   }
	}
	
	/**
  * Get array list of Currencies eg. array(currency_id=>currency_name)
  */
	 public static function getCurrencyList(){

		$criteria   			=	new CDbCriteria();
		$criteria->select 		=	't.currency_id,t.currency_code,t.currency_name';
		$criteria->with 		=	array();
		$data    				=	LookupCurrency::model()->findAll($criteria);
		$listArr = array();
		
		if(!empty($data)) {
			foreach($data as $data) {
				$listArr[$data->currency_id] = $data->currency_code;
			}
		} 
		else{
			$listArr = array();
		}
		return $listArr;
	 }
	 
	public static function getDiTypeList(){
		$model	=	new LookupDiType;
		$list =  CHtml::listData($model->findAll(),'di_type_id', 'type');
		return $list;
	}
	


	public static function getUserType(){
		return $list	=	array('Admin'=>'Admin','Moderator'=>'Moderator');
	}


    public static function countDiModerators($di_id){
        $count = DiUser::model()->count('di_ref_id=:x AND user_type=:y',array(':x'=>$di_id,':y'=>'Moderator'));
        return $count;
    }


    /*
     * Departments Save and List
     */

    public static function getDepartmentList($di_user_id = ""){

        if(isset($di_user_id) && $di_user_id !=""){
            // Get Department List only which Di User selected
            $model	=	new DiUserDepartment;
            $data	=	$model->findAll(array('condition'=>'di_user_ref_id=:x', 'params'=>array(':x'=>$di_user_id)));
            $list   =  CHtml::listData($data,'mainDepartmentRef.department_id', 'mainDepartmentRef.department_name');

        } else{
            // Get Department List with all main departments
            $model	=	new LookupDepartment;
            $data	=	$model->findAll(array('order'=>'department_name', 'condition'=>'main_dept_id=:x', 'params'=>array(':x'=>0)));
            $list =  CHtml::listData($data,'department_id', 'department_name');
			
			//this means user is logged with di moderator
			/*
			if(isset(Yii::app()->user->di_id) && (Yii::app()->user->di_id>0)){
				$di_id  = Yii::app()->user->di_id;
			} else{
				$di_id = Yii::app()->getRequest()->getQuery('di_id');
			}
			
			$di	= Di::model()->findByPk($di_id);
			$uniID = $di->uni_ref_id;
		    $departments = array();
			$uniDepts = TblUniCourses::getDepartmentListByUniId($uniID, $level);
			if($uniDepts){
				foreach($uniDepts as $Depts)
					$departments[$Depts['id']] = $Depts['value'];
			}
			$list = $departments;
			*/
 			
        }

        return $list;
    }

	public static function makeList($items) {
		if (count($items) == 1) {
			$item = implode(", ", $items);
		} elseif (count($items) > 1)  {
			$last_item = array_pop($items);
			$item = implode(", ", $items) . ' and ' . $last_item;
		} else {
			$item = '';
		}
		return $item;
	}
	
    public static function displayDepartments($di_user_id){
        $list = self::getDepartmentList($di_user_id);
		$string = self::makeList($list);
		return $string;
    }



    /* DiHelper Hot Lead related Usefull Functions
    */

    /*
    Create Filters on Icon Click Usefull functions
    */

    public static function getDiHotLeadCountryList($di_user_ref_id){

        $sql = "
                SELECT
                DISTINCT TUM.country_ref_id as country_id, TCM.country_name
                FROM
                di_user_hotlead AS DUH, student_hotlead AS SH, tbl_user_master AS TUM, tbl_country_master AS TCM
                WHERE
                DUH.student_hotlead_ref_id = SH.student_hotlead_id
                AND
                SH.user_ref_id = TUM.user_id
                AND
                TUM.country_ref_id = TCM.country_id
                AND
                DUH.di_user_ref_id = ".$di_user_ref_id."
       ";

        $connection  = Yii::app()->db;
        $command     = $connection->createCommand($sql);
        $rowCount    = $command->execute(); // execute the non-query SQL

        if($rowCount>0){
            $data = $command->query();
            return $data->readAll();
        } else{
           return array();
        }

    }

    public static function getLikelyPeriods(){
        $model = LookupLikelyPeriod::model()->findAll();
        $list = CHtml::listData($model,'period_id','months');
        return $list;
    }

    public static function getApplyStatus(){
        $list = array('Applied','MightApply','WillApply');
        return $list;
    }

    public static function getStudyLevels(){
		$criteria  = new CDbCriteria;
		$criteria->condition 	= "t.parent_ref_id=:x";
		$criteria->params		= array(':x'=>0);
        $model = LookupCourseLevel::model()->findAll($criteria);
		$list = CHtml::listData($model,'level_id','course_level');
        return $list;
    }


    public static function createHotLeadSearchCriteria($searchArr){

        $sqlObj = new stdClass;

        $sqlObj->select = array();

        $sqlObj->condition->mustTrue        = array();

        $sqlObj->condition->studyLevel      = array();
        $sqlObj->condition->country         = array();
        $sqlObj->condition->applyStatus     = array();
        $sqlObj->condition->department      = array();
        $sqlObj->condition->likelyPeriod    = array();

        $sqlObj->from   = array();
		
        $sqlObj->group  = array();
        $sqlObj->order  = array();

        // Start Building Sql Query Object
        $sqlObj->select = array(
            'DISTINCT SH.student_hotlead_id',
            'DUH.di_user_hotlead_id',
            'DUH.status',
            'TUM.user_id',
            'TUM.first_name',
            'TUM.last_name',
        );
        $sqlObj->from   = array(
            'di_user_hotlead AS DUH',
            'student_hotlead AS SH',
            'tbl_user_master AS TUM'
        );


        array_push($sqlObj->condition->mustTrue,"DUH.student_hotlead_ref_id = SH.student_hotlead_id");
        array_push($sqlObj->condition->mustTrue,"SH.user_ref_id = TUM.user_id");

        // Check for - if not already some action is processed on user
        array_push($sqlObj->condition->mustTrue," NOT EXISTS (SELECT 1 FROM `di_student_selection_status` dsss
			WHERE dsss.di_user_ref_id = DUH.di_user_ref_id  AND  dsss.user_ref_id=SH.user_ref_id)");

        // Always Must True But Only ignore this When user want to notviewed hot deals
        if( isset($searchArr['leftFilterType']) && ($searchArr['leftFilterType']!="notviewed")){
            array_push($sqlObj->condition->mustTrue,"(DUH.status = 'View' OR DUH.status is NULL)");
        }
        if( !isset($searchArr['leftFilterType'])){
            array_push($sqlObj->condition->mustTrue,"(DUH.status = 'View' OR DUH.status is NULL)");
        }

		/*
        echo "<pre>";
        print_r($searchArr);
        echo "</pre>";
		*/

        foreach($searchArr as $filterKey=>$filterArr)
        {
            switch($filterKey)
            {
                case 'studyLevel':
				
                    array_push($sqlObj->from,"student_preferred_study_level AS SPSL");
                    array_push($sqlObj->condition->mustTrue,"TUM.user_id = SPSL.user_ref_id");
					
                    foreach($filterArr as $filterVal){
						$model = LookupCourseLevel::model()->findAllByAttributes(array('parent_ref_id'=>$filterVal));
						$subDepartments = CHtml::listData($model,'level_id','level_id');
						
						$mainDepartment	= $filterVal;
						$subDepartments = implode(',',$subDepartments);
						$subDepartments = $subDepartments.','.$mainDepartment;
                        array_push($sqlObj->condition->studyLevel,"SPSL.course_level_ref_id IN ($subDepartments)");
                    }
                break;

                case 'country':
                    foreach($filterArr as $filterVal){
                        if($filterVal=="other"){
                            array_push($sqlObj->condition->country,"TUM.country_ref_id is NULL");
                        } else{
                            array_push($sqlObj->condition->country,"TUM.country_ref_id = $filterVal");
                        }
                    }
                break;

                case 'applyStatus':
                    foreach($filterArr as $filterVal){
                        array_push($sqlObj->condition->applyStatus,"SH.status = '$filterVal'");
                    }
                break;

                case 'department':
                    array_push($sqlObj->from,"student_preferred_department AS SPD");
                    array_push($sqlObj->condition->mustTrue,"TUM.user_id = SPD.user_ref_id");
                    foreach($filterArr as $filterVal){
                        array_push($sqlObj->condition->department,"SPD.main_dept_ref_id = $filterVal");
                    }
                break;

                case 'likelyPeriod':
                    array_push($sqlObj->from,"student_preferred_period AS SPP");
                    array_push($sqlObj->condition->mustTrue,"TUM.user_id = SPP.user_ref_id");
                    foreach($filterArr as $filterVal){
                        array_push($sqlObj->condition->likelyPeriod,"SPP.period_ref_id = $filterVal");
                    }
                break;

                case 'leftFilterType':
                    if($filterArr=="lastlogin"){
                        $loggedData   =   diHelper::loggedInUserDetails(Yii::app()->user->id);
                        //$condition    =   "DUH.added_on >= STR_TO_DATE('$loggedData->last_login', '%Y-%m-%d %h:%i:%s')";
                        // this simple last login match also working well, i tested it in alertmatch, so replaced this complex one
                        $condition    =   "DUH.added_on >= '$loggedData->last_login'";
                        array_push($sqlObj->condition->mustTrue,$condition);
                    }elseif($filterArr=="notviewed"){
                        array_push($sqlObj->condition->mustTrue,"DUH.status IS NULL");
                    }elseif($filterArr=="hmatching"){
                    //array_push($sqlObj->condition->order,"DUH.status DESC");
                    }elseif($filterArr=="first_name_asc"){
                        array_push($sqlObj->order,"TUM.first_name ASC");
                    }elseif($filterArr=="first_name_desc"){
                        array_push($sqlObj->order,"TUM.first_name DESC");
                    }
                break;

               case 'diUser':
                    if($filterArr!=""){
                        array_push($sqlObj->condition->mustTrue,"DUH.di_user_ref_id = $filterArr");
                    }
                break;

                case 'sortingType':
                    if($filterArr=="first_name_asc"){
                        array_push($sqlObj->order,"TUM.first_name ASC");
                    }elseif($filterArr=="first_name_desc"){
                        array_push($sqlObj->order,"TUM.first_name DESC");
                    }
                    break;

            }// switch


        }// foreach

        if(empty($sqlObj->order)){
        array_push($sqlObj->order,"TUM.first_name ASC");
        }

        //Blocking students who shortlisted/bought/rejected
        $notINCond = DiHelper::getBoughtIgnoredOfferedUserIDs(Yii::app()->user->sub_id);
        if(count($notINCond))
            array_push($sqlObj->condition->mustTrue,"user_ref_id NOT IN (".implode(',', $notINCond).")");
            //$sql .= " AND user_ref_id NOT IN (".implode(',', $notINCond).")";

        return $sqlObj;

    }


    public static function createHotLeadSqlQuery($sqlCriteria){

        $sql = "";

        $sql .= "SELECT ";
        $sql .= implode(', ',$sqlCriteria->select);

        $sql .= " FROM ";
        $sql .= implode(', ',$sqlCriteria->from);
        $sql .= " WHERE ";

        $conditionArr = array();
        foreach($sqlCriteria->condition as $groupKey=>$groupVal){

            if(!empty($groupVal)){
                $oprt = ($groupKey == "mustTrue") ? " AND " : " OR ";
                $temp = "";
                $temp .= " ( ";

                $temp .= implode($oprt,$groupVal);

                $temp .= " ) ";
                array_push($conditionArr,$temp);
            }
        }

        $sql .= implode(' AND ',$conditionArr);


        if(!empty($sqlCriteria->group)){
        $sql .= " GROUP BY ";
        $sql .= implode(', ',$sqlCriteria->group);
        }

        if(!empty($sqlCriteria->unionAll)){
            foreach($sqlCriteria->unionAll as $unionQuery){
                $sql .= " UNION ALL ".$unionQuery;
            }
        }

        if(!empty($sqlCriteria->order)){
        $sql .= " ORDER BY ";
        $sql .= implode(', ',$sqlCriteria->order);
        }

		//echo($sql);
        return $sql;

    }

    public static function createAlertMatchShortlistSearchCriteria($searchArr){

        $sqlObj = new stdClass;

        $sqlObj->select = array();

        $sqlObj->condition->mustTrue        	= array();
        $sqlObj->condition->studentProfileStatus = array();
        $sqlObj->condition->studentStatus         = array();
        $sqlObj->condition->countryOfOrigin     = array();

        $sqlObj->from   = array();
		
        $sqlObj->group  = array();
        $sqlObj->order  = array();

        // Start Building Sql Query Object
        $sqlObj->select = array(
            'DISTINCT DUCS.di_user_criteria_shortlist_id',
			'DUCS.status as shortlist_status',
			'DUCS.di_user_eoi_ref_id',
            'TUM.first_name',
            'TUM.last_name',
			'DUEL.eoi_status',
			'DUE.eoi_status AS eoi_status_in_eoi_table',
        );
        $sqlObj->from   = array(
			'di_user_criteria_shortlist AS DUCS', 
			'di_user_eoi_log AS DUEL', 
			'tbl_user_master AS TUM',
			'di_user_eoi AS DUE',
        );

		if(!isset($searchArr['leftFilterType'])){
			array_push($sqlObj->condition->mustTrue,"(DUCS.status IS NULL OR DUCS.status = 'View')");
		}
		
		//array_push($sqlObj->condition->mustTrue,"DUCS.status != 'Ignore'");
        array_push($sqlObj->condition->mustTrue,"DUEL.eoi_status != 'Reject'");
        array_push($sqlObj->condition->mustTrue,"DUEL.eoi_status != 'Hotlead'");
        array_push($sqlObj->condition->mustTrue,"DUCS.user_ref_id = TUM.user_id");
        array_push($sqlObj->condition->mustTrue,"DUCS.di_user_eoi_ref_id = DUE.di_user_eoi_id");
		

        foreach($searchArr as $filterKey=>$filterArr)
        {
            switch($filterKey)
            {
                case 'country':
                    foreach($filterArr as $filterVal){
                        if($filterVal=="other"){
                            array_push($sqlObj->condition->countryOfOrigin,"TUM.country_ref_id is NULL");
                        } else{
                            array_push($sqlObj->condition->countryOfOrigin,"TUM.country_ref_id = $filterVal");
                        }
                    }
                break;
                case 'studentStatus':
                    foreach($filterArr as $filterVal){
                        array_push($sqlObj->condition->studentStatus,"DUE.eoi_status = '$filterVal'");
                    }
                break;
               case 'leftFilterType':
						if($filterArr=="Bought"){
							array_push($sqlObj->condition->mustTrue,"(DUCS.status = 'Buy'  OR DUCS.status = 'Refund')");
						} else{
							array_push($sqlObj->condition->mustTrue,"(DUCS.status IS NULL OR DUCS.status = 'View')");
						}
                break;

               case 'diUser':
                    if($filterArr!=""){
                        array_push($sqlObj->condition->mustTrue,"DUCS.di_user_ref_id = $filterArr");
                    }
                break;

            }// switch


        }// foreach

        if(empty($sqlObj->group)){
        array_push($sqlObj->group,"DUCS.di_user_criteria_shortlist_id");
        }
		
        if(empty($sqlObj->order)){
        array_push($sqlObj->order,"TUM.first_name ASC");
        }

        return $sqlObj;

    }	

    public static function getUniversityId($Di_Id = '0'){
        $criteria               =   new CDbCriteria;
        $criteria->select       =   'uni_ref_id';
        $criteria->condition    =   'di_id=:x';
        $criteria->params       =   array(':x'=>$Di_Id);
        $data                   =   Di::model()->find($criteria);
        if($data===NULL){
            return 0;
        }else{
            return $data->uni_ref_id;
        }
    }

    /************************
    * Buy Profile
    ***********************/
    public static function buyProfile($diUserHotleadId){
	
            $BuyProfile     =   DiHelper::buyThisProfile($diUserHotleadId);
		if($BuyProfile){
                return array('msg_type'=>'success','msg_code'=>"Congratulations! Your interest to make an offer sent successfully");
            }else{
                return array('msg_type'=>'error','msg_code'=>"Oops! Something went wrong. Please try again later.");
            }
			
    } // EOF function


    function isDiUserHotleadAlreadyBought($student_hotlead_ref_id="0"){
        $criteria               =   new CDbCriteria;
        //$criteria->select       =   'uni_ref_id';
        $criteria->condition    =   'student_hotlead_ref_id=:x AND status=:y';
        $criteria->params       =   array(':x'=>$student_hotlead_ref_id,':y'=>'buy');
        $data                   =   DiUserHotlead::model()->find($criteria);
        if($data===NULL){
            return false;
        }else{
            return true;
        }
    }


    /*
     * DiUser Delete
     * Delete data from all relational tables
     */

    function deleteDiUserHotlead($diUserId="")
    {
        if($diUserId==""){ return false; }
        $criteria               =   new CDbCriteria;
        $criteria->condition    =   'di_user_ref_id=:x';
        $criteria->params       =   array(':x'=>$diUserId);
        $model                   =  DiUserHotlead::model()->find($criteria);
        if($model->deleteAll()){
            return true;
        } else{
            return false;
        }
    }


    /* Delete DiUser Department Data */
    function deleteDiUserDepartment($diUserId="")
    {
        if($diUserId==""){ return false; }
        $criteria               =   new CDbCriteria;
        $criteria->condition    =   'di_user_ref_id=:x';
        $criteria->params       =   array(':x'=>$diUserId);
        $model                   =   DiUserDepartment::model()->find($criteria);
        if($model->deleteAll()){
            return true;
        } else{
            return false;
        }
    }

    /* Delete DiUser EOI Data */
    function deleteDiUserEoi($diUserId="")
    {
        if($diUserId==""){ return false; }
        $criteria               =   new CDbCriteria;
        $criteria->condition    =   'di_user_ref_di=:x';
        $criteria->params       =   array(':x'=>$diUserId);
        $model                   =   DiUserEoi::model()->find($criteria);
        if($model->deleteAll()){
            return true;
        } else{
            return false;
        }
    }

    /* Delete DiUser EOI LOG Data */
    function deleteDiUserEoiLog($diUserId="")
    {
        if($diUserId==""){ return false; }
        $criteria               =   new CDbCriteria;
        $criteria->condition    =   'di_user_ref_di=:x';
        $criteria->params       =   array(':x'=>$diUserId);
        $model                   =   DiUserEoiLog::model()->find($criteria);
        if($model->deleteAll()){
            return true;
        } else{
            return false;
        }
    }



    /* Delete DiUser id */
    function deleteDiUser($diUserId="")
    {
        if($diUserId==""){ return false; }
        $criteria               =   new CDbCriteria;
        $criteria->condition    =   'di_user_id=:x';
        $criteria->params       =   array(':x'=>$diUserId);
        $model                  =   DiUser::model()->find($criteria);
        $login_master_id        =   $model->login_ref_id;
        if($model->delete()){
            return $login_master_id;
        } else{
            return false;
        }
    }

    /* Delete LoginMaster Data */
    function deleteLoginMaster($login_master_id="")
    {
        if($login_master_id==""){ return false; }
        $criteria               =   new CDbCriteria;
        $criteria->condition    =   'login_id=:x';
        $criteria->params       =   array(':x'=>$login_master_id);
        $model                  =   LoginMaster::model()->find($criteria);
        $login_master_id        =   $model->login_ref_id;
        if($model->delete()){
            return true;
        } else{
            return false;
        }
    }


    /*
     * HotLead and AlertMatch Common Controller actions functions
     */

    public static function listingDecline($module){
        $listingId    =   $_POST['listingId'];

        switch($_POST['action']){
            case 'decline' :
                if($module=="hotlead"){
                    if(DiUserHotlead::model()->updateByPk($listingId,array('status'=>'Ignore'))){
                        echo '#li_'.$listingId.',#lisub_'.$listingId;
                    }else{
                        echo 'error';
                    }
                } else{
                    if(DiUserCriteriaMatch::model()->updateByPk($listingId,array('status'=>'Ignore'))){
                        echo '#li_'.$listingId.',#lisub_'.$listingId;
                    }else{
                        echo 'error';
                    }
                }

                break;
            case 'bulkDecline':
                echo DiHelper::batchUpdateForDecline($_POST['listingId'],'Ignore',$module);
                break;
            default:
                echo "error";
                break;
        }
    }


    public static function batchUpdateForDecline($data= '',$status='',$module=''){
        if(count($data)>0){
            foreach($data as $value){
                if($module=="hotlead"){
                    DiUserHotlead::model()->updateByPk($value,array('status'=>$status));
                    $string[] =   '#li_'.$value.',#lisub_'.$value;
                } else{
                    DiUserCriteriaMatch::model()->updateByPk($value,array('status'=>$status));
                    $string[] =   '#li_'.$value.',#lisub_'.$value;
                }
            }
            $response   =   implode(',',$string);
        }else{
            $response   =   'error';
        }
        return $response;
    }



    public static function getDIUserHotLeadIdDetails($HotleadUserID = '0'){
        $HotLeadData    =   DiUserHotlead::model()->findByPk($HotleadUserID);
        return $HotLeadData;
    }

    /************************
     * Alert Match
     * Buy EOI
     ***********************/
	
	public static function isEoiALreadySentThreeTimes($listId){
	
		$di_id  = Yii::app()->user->di_id;
        $DiUserCriteriaMatch        =   DiUserCriteriaMatch::model()->findByPk($listId);
        $student_id                 =   $DiUserCriteriaMatch->user_ref_id;
		
		$main_department_ref_id = $DiUserCriteriaMatch->diUserCriteriaRef->main_department_ref_id;
		$diUsers = DiHelper::getAllDiUsersOfSameUniversity($di_id);
		
		$criteria = new CDbCriteria();
		$criteria->condition = 'user_ref_id=:user_ref_id AND main_department_ref_id=:main_department_ref_id';
		$criteria->params = array(
		'user_ref_id'				=> $student_id,
		'main_department_ref_id'	=> $main_department_ref_id,
		);
		$criteria->addInCondition('di_user_ref_id', $diUsers);		
		$eoiLogEnteries = DiUserEoiLog::model()->findAll($criteria);
		
		if(count($eoiLogEnteries)>=3){
			return true;
		} else{
			return false;
		}
		
	}	
	 
    public static function buyEoi($listId){

            $BuyEoiProfile     =   DiHelper::buyEoiThisProfile($listId);
		if($BuyEoiProfile){
                return array('msg_type'=>'success','msg_code'=>"Congratulations! You have expressed interest in this profile successfully");
            }else{
                return array('msg_type'=>'error','msg_code'=>"Oops! Something went wrong. Please try again later.");
            }
		
    } // EOF function


    public static function diUserCriteriaMatchesStat($criteria_id,$type){

        switch($type){

            case 'new':
                $criteria       =   new CDbCriteria();
                $loggedData     =   diHelper::loggedInUserDetails(Yii::app()->user->id);
                $newmatches     =   "AND t.added_on >= '$loggedData->last_login'";
                $criteria->condition = 't.status Is Null '.$newmatches;
                $criteria->addCondition('t.di_user_criteria_Ref_id ="'.$criteria_id.'"');

                $notINCond = DiHelper::getBoughtIgnoredOfferedUserIDs(Yii::app()->user->sub_id);
                if(count($notINCond))
                    $criteria->addNotInCondition('user_ref_id', $notINCond, 'AND');
                $criteria->addCondition('NOT EXISTS (SELECT 1 FROM `di_student_selection_status` dsss
			WHERE dsss.di_user_ref_id = duc.di_user_ref_id  AND dsss.user_ref_id=t.user_ref_id)');
                //$criteria->join  .= " LEFT JOIN di_user_counsellor_suggested dcs ON dcs.di_user_ref_id = duc.di_user_ref_id AND dcs.user_ref_id = t.user_ref_id AND dcs.status IS NULL";
                //$criteria->addCondition("dcs.user_ref_id IS NULL", "AND");

				$counts = DiUserCriteriaMatch::model()->count($criteria);
                return $counts;
            break;
            case 'totalmatches':
                $criteria       =   new CDbCriteria();
                $loggedData     =   diHelper::loggedInUserDetails(Yii::app()->user->id);
                $criteria->condition = 't.status Is Null';
				$criteria->addCondition('t.di_user_criteria_Ref_id ="'.$criteria_id.'"');

                $notINCond = DiHelper::getBoughtIgnoredOfferedUserIDs(Yii::app()->user->sub_id);
                if(count($notINCond))
                    $criteria->addNotInCondition('user_ref_id', $notINCond, 'AND');
                $criteria->addCondition('NOT EXISTS (SELECT 1 FROM `di_student_selection_status` dsss
			WHERE dsss.di_user_ref_id = duc.di_user_ref_id  AND dsss.user_ref_id=t.user_ref_id)');

                //$criteria->join  .= " LEFT JOIN di_user_counsellor_suggested dcs ON                     dcs.di_user_ref_id = duc.di_user_ref_id AND dcs.user_ref_id = t.user_ref_id AND dcs.status IS NULL";
                //$criteria->addCondition("dcs.user_ref_id IS NULL", "AND");

                $counts = DiUserCriteriaMatch::model()->count($criteria);
                return $counts;
            break;
            case 'rejected':
                $criteria       =   new CDbCriteria();
                $loggedData     =   diHelper::loggedInUserDetails(Yii::app()->user->id);
                $criteria->condition = 'status = :x';
                $criteria->params   = array(':x'=>'Ignore');
				$criteria->addCondition('di_user_criteria_Ref_id ="'.$criteria_id.'"');
                $counts = DiUserCriteriaMatch::model()->count($criteria);
                return $counts;
            break;

        }//switch

    }
	
	public static function calculateAdmissionChancesRank($id,$type){
	
		$admissionChances = array();
		$max = 0.00;

		switch($type){
			case "hotlead":
				$model 			= self::getDIUserHotLeadIdDetails($HotleadUserID = $id);
				$university_id 	= $model->diUserRef->diRef->uni_ref_id;
				$student_id	 	= $model->studentHotleadRef->user_ref_id;
				$di_user_id		= $model->diUserRef->di_user_id;
				
				$departments	= self::getDiAndStudentCommonDepartments($diHotLeadId = $id, $diUserID = $di_user_id);
				
				foreach($departments as $department){
					$main_dept_ref_id = $department['main_dept_ref_id'];
					#I commented this because admission chances component giving error in some student cases
					$percentage = self::getAdmissionChancesPercentage($student_id,$university_id,$main_dept_ref_id);
					$admissionChances[] = $percentage;
					//$admissionChances[] = "0";
				}
			break;
			
			case "alertmatch":
				$model 			= DiUserCriteriaMatch::model()->findByPk($id);
				$student_id 	= $model->user_ref_id;
				
				$model 			= DiUserCriteria::model()->findByPk($model->di_user_criteria_ref_id);
				$main_dept_ref_id = $model->main_department_ref_id;
				
				$model 			= DiUser::model()->findByPk($model->di_user_ref_id);
				$model 			= Di::model()->findByPk($model->di_ref_id);
				$university_id	= $model->uni_ref_id;
				
				$percentage = self::getAdmissionChancesPercentage($student_id,$university_id,$main_dept_ref_id);
				$admissionChances[] = $percentage;
			break;
			
			case "alertmatch_shortlist":
				$shortListDetail = DiUserCriteriaShortlist::model()->findByPk($id);
				$student_id 	= $shortListDetail->user_ref_id;
				$diUserEoi	=	DiUserEoi::model()->findByPk($shortListDetail->di_user_eoi_ref_id);
				$main_department_ref_id = $diUserEoi->main_department_ref_id;
				$university_id 			= $diUserEoi->diUserRef->diRef->uni_ref_id;
				$percentage = self::getAdmissionChancesPercentage($student_id,$university_id,$main_department_ref_id);
				$admissionChances[] = $percentage;
			break;
			
			case "counselor_shortlist":
				$shortListDetail = DiUserCounsellorShortlist::model()->findByPk($id);
				$student_id 	= $shortListDetail->user_ref_id;
				$main_department_ref_id = $shortListDetail->department_ref_id;
				$model 			= DiUser::model()->findByPk($shortListDetail->di_user_ref_id);
				$model 			= Di::model()->findByPk($model->di_ref_id);
				$university_id	= $model->uni_ref_id;
				$percentage = self::getAdmissionChancesPercentage($student_id,$university_id,$main_department_ref_id);
				$admissionChances[] = $percentage;
			break;
			
			case "counselor_suggested":
				$listingDetail = DiUserCounsellorSuggested::model()->findByPk($id);
				$student_id 	= $listingDetail->user_ref_id;
				$main_department_ref_id = $listingDetail->department_ref_id;
				$model 			= DiUser::model()->findByPk($listingDetail->di_user_ref_id);
				$model 			= Di::model()->findByPk($model->di_ref_id);
				$university_id	= $model->uni_ref_id;
				$percentage = self::getAdmissionChancesPercentage($student_id,$university_id,$main_department_ref_id);
				$admissionChances[] = $percentage;
			break;		
		}

		if(is_array($admissionChances) && count($admissionChances)>0){
		$max = max($admissionChances);
		}
		$score = $max;
		$totalPercentageToBeDisplayedInCircle = UniversityHelper::displayAdmissionChance($score,true);
		
		$percentTitle = $totalPercentageToBeDisplayedInCircle;
		
		$percent = trim(trim(trim($totalPercentageToBeDisplayedInCircle,'<'),'>'),'%');
		
		//$percent = 35;
		
		$score = $score/10;
		$score = number_format($score, 2, '.', '');
		 
		if($percent<25){
			echo '<span class="red"><span>';
			
		}else if($percent>=25 && $percent<=75){
			echo '<span class="orange"><span>';
			
		}
		
		
		$percent = $percent/10;
		
		
		
		$deg = 360 / 10 * $percent;
		
		$scoreArr = explode('.',$score);
		$int = $scoreArr[0];
		$dec = $scoreArr[1];
		
		$styleDeg = "";
		$styleDeg .="-moz-transform: rotate(".$deg."deg);";
		$styleDeg .="-webkit-transform: rotate(".$deg."deg);";
		$styleDeg .="-o-transform: rotate(".$deg."deg);";
		$styleDeg .="transform: rotate(".$deg."deg);";
		$totalPercentageToBeDisplayedInCircle = str_replace("-","",$totalPercentageToBeDisplayedInCircle);
		$percentTitle = str_replace("-","",$percentTitle); 
		switch($type){
			case "hotlead":
            case "alertmatch":

            if(isset(Yii::app()->controller->module->id) ){
				$html = $totalPercentageToBeDisplayedInCircle;
				} else{
		$html  = "<div class=\"notesite\" title=\"".$percentTitle."\" >";
		$html .= "<div class=\"percent\">";
		//$html .="<span class=\"int\">".$int."</span><span class=\"dec\">.".$dec."</span>";
		$html .="<span class=\"int\">".$totalPercentageToBeDisplayedInCircle."</span>";
		
		$html .= "</div>";
		$html .= "<div id=\"slice\"' ".($percent > 5 ? 'class="gt50"' : '').">";
		$html .= "<div class=\"pie\" style=\"".$styleDeg."\"></div>".($percent > 5 ? '<div class="pie fill" style="'.$styleDeg.'"></div>' : '')."</div>";
		$html .= "</div>";
				}
			break;
			case "alertmatch_old":
				$html  = "<div class=\"notesite\" title=\"".$percentTitle."\" >";
				$html .= "<div class=\"percent\">";
				//$html .="<span class=\"int\">".$int."</span><span class=\"dec\">.".$dec."</span>";
				$html .="<span class=\"int\">".$totalPercentageToBeDisplayedInCircle."</span>";
				
				$html .= "</div>";
				$html .= "<div id=\"slice\"' ".($percent > 5 ? 'class="gt50"' : '').">";
				$html .= "<div class=\"pie\" style=\"".$styleDeg."\"></div>".($percent > 5 ? '<div class="pie fill" style="'.$styleDeg.'"></div>' : '')."</div>";
				$html .= "</div>";
				break;
			case "hotlead_shortlist":
				$html = $int.".".$dec;
			break;
			case "alertmatch_shortlist":
				//$html = $int.".".$dec;
				$html = $totalPercentageToBeDisplayedInCircle;
			break;
			case "counselor_shortlist":
				//$html = $int.".".$dec;
				$html = $totalPercentageToBeDisplayedInCircle;
			break;
			case "counselor_suggested":
				//$html = $int.".".$dec;
				$html = $totalPercentageToBeDisplayedInCircle;
			break;
		}	//echo $percent;
		if($percent<=7.5){		
			$html.='</span></span>';
		}
		return $html;
		
	}
	
	public static function getAdmissionChancesPercentage($student_id,$university_id,$main_dept_ref_id){
	
		try{

            Yii::import('application.components.admissionchances.drivers.*');
			$obj = new TestDriver();
			$obj->studentID = $student_id;
			$obj->universityID = $university_id;
			$obj->departmentID = $main_dept_ref_id;

			$result = json_decode($obj->getAdmissionChances());
            return $result->score;
		} catch(Exception $e){
			return 0;
		}		
	}
	
	
	function getLoggedinDiUserName(){
		$LoogedInDiName = Yii::app()->user->getState('LoogedInDiName');
		if($LoogedInDiName == ""){
			$DiUser = DiUser::model()->findByPk(Yii::app()->user->sub_id);
			$LoogedInDiName = $DiUser->first_name.' '.$DiUser->last_name;
			Yii::app()->user->setState('LoogedInDiName',$LoogedInDiName);
		}
		return $LoogedInDiName;
	}
	

	static function getAllDiUsersOfSameUniversity($di_id){
		$data = DiUser::model()->findAllByAttributes(array(
		'di_ref_id'=>$di_id
		));
		$data = CHtml::listData($data,'di_user_id','di_user_id');
		return $data;
	}
	
	/* Type = Eoi or Buy */
	public static function setProductDebits($array){
	
		$product_name	= $array['product_name'];// Eoi | Buy
		$listing_type	= $array['listing_type'];// DiUserHotlead | DiUserCriteriaMatch | DiUserCriteriaShortlist
		$listing_id		= $array['listing_id']; // any primary key of above 3 tables
		
		$msg_code_success = ($product_name=="Eoi") ? "Eoi sent" : "Profile Bought";
		$msg_code_error = ($product_name=="Eoi") ? "send Eoi" : "Buy Profile";
	
		$LookupProduct = LookupProduct::model()->findByAttributes(array('product_shortcode'=>$product_name));
        $di_id  	= Yii::app()->user->di_id;
		$product_id = $LookupProduct->product_id;
        $added_by  	= Yii::app()->user->id;
		$student_id = 0;
		
			/* ======= Get Student Id according to listing ============*/
				switch($listing_type){
					case 'DiUserHotlead':
						$r = DiUserHotlead::model()->findByPk($listing_id);	
						$student_id = $r->studentHotleadRef->user_ref_id;
					break;
					case 'DiUserCriteriaMatch':
						$r = DiUserCriteriaMatch::model()->findByPk($listing_id);	
						$student_id = $r->user_ref_id;
					break;
					case 'DiUserCriteriaShortlist':
						$r = DiUserCriteriaShortlist::model()->findByPk($listing_id);	
						$student_id = $r->user_ref_id;
					break;
					case 'DiUserCounsellorSuggested':
						$r = DiUserCounsellorSuggested::model()->findByPk($listing_id);	
						$student_id = $r->user_ref_id;
					break;
					case 'DiUserCounsellorShortlist':
						$r = DiUserCounsellorShortlist::model()->findByPk($listing_id);	
						$student_id = $r->user_ref_id;
					break;
				}
			/* ===================== EOF get Student id ===========================*/
		
            $arrayData  =  array(
                'di_ref_id'         =>   $di_id,
                'product_ref_id'    =>   $product_id, 
                'user_ref_id'       =>   $student_id,
                'added_by'          =>   $added_by,
            );
			
		// Step 1 Check Free Balance
        $AvailableProductCredit     =   DiHelper::availableDiProductCredit($di_id,$Product_id=$product_id);
        if((int)$AvailableProductCredit>0){
            $arrayData  =  array(
                'di_ref_id'         =>   $di_id,
                'product_ref_id'    =>   $product_id, 
                'user_ref_id'       =>   $student_id,
                'added_by'          =>   $added_by,
            );
			
            $ProductDebit   =   DiHelper::addDiProductDebit($arrayData);
            if($ProductDebit){
                return array('msg_type'=>'success','msg_code'=>"$msg_code_success successfully");
            }else{
                return array('msg_type'=>'error','msg_code'=>"Problem occurring in $msg_code_error action. Please Try it later");
            }
        }else{
			// Step 2 Check Free Balance
            $isActiveProduct    =   DiHelper::DiProductPriceIsActive($di_id,$product_id);
            if($isActiveProduct)
			{
                $DiCashCredit   =   DiHelper::availableDiCashCredit($di_id);
                $DiproductId    =   DiHelper::DiProductId($di_id,$product_id);
                $DiproductPrice =   DiHelper::DiProductPrice($di_id,$product_id);
				
				$di_credit_limit =  DiHelper::getDiCreditLimit($di_id);
				$DiCashBalanceWillBe = ($DiCashCredit - $DiproductPrice);
				
				// Add extra credit limit to balance
				// in Di account we set extra credit limit it can be used when 
				// we have less cash credit compare than product price
				// if balance still in minus then restrict du user to purchase
				if($DiCashBalanceWillBe<=0){ // if cash account balance is 0 or in minus
				$DiCashBalanceWillBe = $DiCashBalanceWillBe + $di_credit_limit;
				}
				
                if((int)$DiCashBalanceWillBe>=0){
                    $arrayData  =  array(
                        'di_ref_id'         =>   $di_id,
                        'di_product_ref_id' =>   $DiproductId,
                        'user_ref_id'       =>   $student_id,
                        'subtotal'          =>   $DiproductPrice,
                    );
					
                    $ProductDebit   =   DiHelper::addDiCashDebit($arrayData);
					if($ProductDebit){
						return array('msg_type'=>'success','msg_code'=>"$msg_code_success successfully");
					}else{
						return array('msg_type'=>'error','msg_code'=>"Problem occurring in $msg_code_error action. Please Try it later");
					}
                }else{

                    return array('msg_type'=>'error','msg_code'=>"You don&prime;t have enough credits to complete this transaction. Please upgrade your account.");

                }
            }else{
				return array('msg_type'=>'error','msg_code'=>"Sorry, this feature is not yet available for you.");
            }
        }
	
	}


    public static function isVendorBoughtStudentProfile($expertID,$student_id){
        Yii::import('application.modules.expert.models.*');
        $model = VendorStudentSelection::model()->find("vendor_expert_ref_id = '".$expertID."' AND user_ref_id = '".$student_id."' AND status='Bought'");
        return $model ? true : false;
    }

	public static function isDiBoughtStudentProfile($di_id,$student_id){

        $model = DiStudentSelection::model()->find("di_ref_id = '".$di_id."' AND user_ref_id = '".$student_id."' AND status='Bought'");
        return $model ? true : false;

		$diUsers = DiHelper::getAllDiUsersOfSameUniversity($di_id);
		
		if(count($diUsers)==0){
		return false;
		}
		
		$diUsers = implode(',',$diUsers);
		$sql = "SELECT DISTINCT di_user_hotlead_id FROM
		di_user_hotlead AS DUH,
		di_user AS DU,
		student_hotlead AS SH
		WHERE 
		DUH.status='Buy' AND
		SH.user_ref_id=".$student_id." AND
		DUH.student_hotlead_ref_id=SH.student_hotlead_id AND
		DUH.di_user_ref_id IN(".$diUsers.")";
		
		$connection=Yii::app()->db;
		$command=$connection->createCommand($sql);
		$rowCount=$command->execute(); // execute the non-query SQL		
		if($rowCount>0){
			return true;
		} else{
			// If User Profile not Bought in Hotlead
			// Check this in Alertmatch
			$sql ="SELECT DISTINCT di_user_criteria_shortlist_id FROM
			di_user_criteria_shortlist AS DUCS,
			di_user AS DU
			WHERE 
			DUCS.status='Buy' AND
			DUCS.user_ref_id=".$student_id." AND
			DUCS.di_user_ref_id IN(".$diUsers.")";
			$connection=Yii::app()->db;
			$command=$connection->createCommand($sql);
			$rowCount=$command->execute(); // execute the non-query SQL		
			if($rowCount>0){
				return true;
			} else{
				// If User Profile not Bought in Hotlead
				// Check this in Alertmatch
				$sql ="SELECT DISTINCT di_user_counsellor_shortlist_id FROM
				di_user_counsellor_shortlist AS DUCS,
				di_user AS DU
				WHERE 
				DUCS.status='Buy' AND
				DUCS.user_ref_id=".$student_id." AND
				DUCS.di_user_ref_id IN(".$diUsers.")";
				$connection=Yii::app()->db;
				$command=$connection->createCommand($sql);
				$rowCount=$command->execute(); // execute the non-query SQL		
				if($rowCount>0){
					return true;
				} else{
					return false;
				}
				//return false;
			}
		}
		
	}
	
	
	/* Di Dashboard related function */
	public static function getShortlistedHotleads($di_user_id,$limit=3){
	
        /*$model                  =   new DiUserHotlead();
        $criteria               =   new CDbCriteria();
		//$criteria->with			= 	array('diUserCriteriaShortlists');
		$criteria->condition    =   't.di_user_ref_id=:x';
		$criteria->params       =   array(':x'=>$di_user_id);
		$criteria->addCondition("t.status = 'Buy'");
		$criteria->limit		=	$limit;
		$criteria->order		= 	"added_on DESC";
        $data                   =   $model->findAll($criteria);*/

        $sql = "SELECT
DISTINCT TUM.user_id, TUM.first_name, TUM.last_name, DUH.added_on
FROM   di_user_hotlead AS DUH,
       student_hotlead AS SH,
       tbl_user_master AS TUM
WHERE  ( DUH.student_hotlead_ref_id = SH.student_hotlead_id
         AND SH.user_ref_id = TUM.user_id
         AND ( DUH.status = 'Buy'
                OR DUH.status = 'Refund' )
         AND DUH.di_user_ref_id = :diUserId )
       AND ( SH.status IN ('applied', 'mightapply', 'willapply') )

UNION ALL

SELECT
DISTINCT TUM.user_id, TUM.first_name, TUM.last_name, DUCS.added_on
FROM   `di_user_counsellor_shortlist` DUCS,
       tbl_user_master AS TUM
WHERE  DUCS.`user_ref_id` = TUM.user_id
       AND DUCS.status IN ( 'Buy', 'Refund' )
       AND DUCS.di_user_ref_id = :diUserId

UNION ALL

SELECT
DISTINCT TUM.user_id, TUM.first_name, TUM.last_name, DUCS.added_on
FROM   `di_user_criteria_shortlist` DUCS,
       tbl_user_master AS TUM
WHERE  DUCS.`user_ref_id` = TUM.user_id
       AND DUCS.status IN ( 'Buy', 'Refund' )
       AND DUCS.di_user_ref_id = :diUserId
ORDER  BY added_on DESC LIMIT :limit;
";
        $cmd = Yii::app()->db->createCommand($sql);
        $cmd->bindValue(":diUserId", $di_user_id, PDO::PARAM_INT);
        $cmd->bindValue(":limit", $limit, PDO::PARAM_INT);
        $data = $cmd->queryAll();
        return $data;
	}
	
	public static function countAlertmatches($di_user_id){
	
        $model                  =   new DiUserCriteriaMatch();
        $criteria               =   new CDbCriteria();
		$criteria->with			= 	array('diUserCriteriaRef');
		$criteria->condition    =   'diUserCriteriaRef.di_user_ref_id=:x AND diUserCriteriaRef.is_active=:y';
		$criteria->params       =   array(':x'=>$di_user_id,':y'=>1);
		$criteria->addCondition("t.status IS NULL");

        $notINCond = self::getBoughtIgnoredOfferedUserIDs($di_user_id);
        if(count($notINCond))
            $criteria->addNotInCondition('user_ref_id', $notINCond, 'AND');

        $data                       =   $model->count($criteria);
        return $data;
	}
	
	public static function countEoiOfferMade($di_user_id){
	
        $model                  =   new DiUserEoi();
        $criteria               =   new CDbCriteria();
		$criteria->condition    =   "t.di_user_ref_id=:x";
		$criteria->params       =   array(':x'=>$di_user_id);
		$criteria->addCondition("(t.eoi_status = 'Accept' OR t.eoi_status = 'Pending' OR t.eoi_status = 'Reject')");
        $data                       =   $model->count($criteria);
        return $data;
	}
	
	public static function countEoiOfferAccepted($di_user_id){
	
        $model                  =   new DiUserEoi();
        $criteria               =   new CDbCriteria();
		$criteria->condition    =   't.di_user_ref_id=:x';
		$criteria->params       =   array(':x'=>$di_user_id);
		$criteria->addCondition("t.eoi_status = 'Accept'");
        $data                       =   $model->count($criteria);
        return $data;
	}
	
	public static function genPassword($length = 10)
	{
		$chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
		$passwordlength = $length;
		for ($x = 1; $x <= $passwordlength; $x++) {
		  $charlist .= $chars;
		}
		$temp_pw = substr( str_shuffle( $charlist ), 0, $passwordlength );
		return $temp_pw;
	}
	
	public static function getStudentName($student_id,$di_id=false){

        if(($UserMaster = UserMaster::model()->findByPk($student_id)) == null)
            return;

        $first_name = $UserMaster->first_name;
        $last_name  = $UserMaster->last_name;

        // is the logged in user is  DI ?
        $userRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);
        if(in_array($userRole, array('DI', 'DiModerator'))){
            $di_id = Yii::app()->user->di_id;
            if(!self::isDiBoughtStudentProfile($di_id,$student_id))
                $last_name = '...';
        }

        return ucfirst($first_name .' '. $last_name);

		/*$studentName = "";
		if(!$di_id){
			$di_id = Yii::app()->user->di_id;
		}
		if($di_id==""){
			$studentName = "Please specify Di Id to get student name";
		}

		if(self::isDiBoughtStudentProfile($di_id,$student_id)){
			$studentName = ucfirst($first_name)." ".ucfirst($last_name);
		} else{
			$lastName = "";
			if(trim($last_name)!=""){
			$lastName = substr($last_name,0,1).".";
			}
			$studentName = ucfirst($first_name)." ".ucfirst($lastName);
		}
		
		return $studentName;*/
	}

    public static function getStudentFirstName($student_id,$di_id=false){

        if(($UserMaster = UserMaster::model()->findByPk($student_id)) == null)
            return;

        $first_name = $UserMaster->first_name;
        $last_name  = $UserMaster->last_name;

        // is the logged in user is  DI ?
        $userRole = CommonUtils::getRbacUserRole(Yii::app()->user->id);
        if(in_array($userRole, array('DI', 'DiModerator'))){
            $di_id = Yii::app()->user->di_id;
            if(!self::isDiBoughtStudentProfile($di_id,$student_id))
                $last_name = '...';
        }

        return ucfirst($first_name .'...');

    }
	public function isEoiProductActive(){	
		$LookupProduct = LookupProduct::model()->findByAttributes(array('product_shortcode'=>'EOI'));
		$di_id  	= Yii::app()->user->di_id;
		$product_id = $LookupProduct->product_id;
		$isActiveProduct    =   self::DiProductPriceIsActive($di_id,$product_id);
		
		if($isActiveProduct){
		return '1';
		} else{
		return '0';
		}
	}
	
	public function getUniversityName(){
		$diDetail       = DiHelper::GetDiDetails(Yii::app()->user->di_id);
		$universityName = $diDetail->uniRef->uni_name;
		return $universityName;
	}
	
	public function userFullDetalFooterStrip($user_ref_id){
	
		$userInfo = TblUserMaster::model()->findByPk($user_ref_id);
	
		$availbleInfo = array();
		if(isset($userInfo->dob) && ($userInfo->dob!="")){
		$availbleInfo[] = "Birth day";
		}
		
		if(isset($userInfo->studentEducations) && is_array($userInfo->studentEducations) && count($userInfo->studentEducations)>0){
		$availbleInfo[] = "Educational Details";
		}
		
		if(isset($userInfo->tblUserInterests) && is_array($userInfo->tblUserInterests) && count($userInfo->tblUserInterests)>0){
		$availbleInfo[] = "Interests";
		}
		
		if(isset($userInfo->studentContactNumbers) && is_array($userInfo->studentContactNumbers) && count($userInfo->studentContactNumbers)>0){
		$availbleInfo[] = "Contacts";
		}
		
		/*
		$availbleInfo = array();
		$availbleInfo[] = "Birth day";
		$availbleInfo[] = "Educational Details";
		$availbleInfo[] = "Interests";
		$availbleInfo[] = "Contacts";
		*/
	
		$html  = "";
		if(count($availbleInfo)>0){
			$html .= "<span>Information available - ".implode(' &nbsp;/&nbsp; ',$availbleInfo)."</span>";
		}
		
		$isBought = DiHelper::isDiBoughtStudentProfile(Yii::app()->user->di_id,$user_ref_id);
		$shwText  = ($isBought) ? "VIEW FULL PROFILE" : "VIEW PROFILE";
		
		$html .= "<span class=\"float_right more\"><a target=\"_blank\" href=\"".Yii::app()->createUrl('student/profile',array('uid'=>base64_encode($user_ref_id)))."\">".$shwText."</a></span>";
		return $html;
	}
	
	function keygen(){
		$chars = "bcdfghjklmnpqrstvwxyz";
		$chars .= "BCDFGHJKLMNPQRSTVWXYZ";
		$chars .= "0123456789";
		while(1){
			$key = '';
			srand((double)microtime()*1000000);
			for($i = 0; $i < 10; $i++){
				$key .= substr($chars,(rand()%(strlen($chars))), 1);
			}
			break;
		}
		return $key;
	}

    static public function getBoughtIgnoredOfferedUserIDs($diUserId){

        Yii::import('application.modules.student.models.*');
        $bought = $ignored = $offered = $shortlisted = array();

        $boughtProfiles = StudentProfilesDownload::downloadDiBoughtProfiles($diUserId, 'Buy', array('TUM.user_id'));
        $ignoredProfiles = StudentProfilesDownload::downloadDiBoughtProfiles($diUserId, 'Ignore', array('TUM.user_id'));
        $offeredProfiles = DiUserEoi::model()->findAllByAttributes(array('di_user_ref_id' => $diUserId));

        $criteria = new CDbCriteria();
        $criteria->join = "INNER JOIN di_user_criteria duc ON duc.di_user_criteria_id = t.di_user_criteria_ref_id";
        $criteria->addCondition("duc.di_user_ref_id='".$diUserId."' AND t.status = 'Ignore'", "AND");
        $ignoredProfilesFromCriteriaMatch = DiUserCriteriaMatch::model()->findAll($criteria);

        $shortlistedProfilesFromCounsellorSuggested = DiUserCounsellorShortlist::model()->findAll(array('condition' => "di_user_ref_id='".$diUserId."'"));

        if(count($boughtProfiles)){
            foreach($boughtProfiles as $boughtProfile){
                $bought[] = $boughtProfile['user_id'];
            }
        }
        if(count($ignoredProfiles)){
            foreach($ignoredProfiles as $ignoredProfile){
                $ignored[] = $ignoredProfile['user_id'];
            }
        }
        if($offeredProfiles){
            foreach($offeredProfiles as $offeredProfile){
                $offered[] = $offeredProfile->user_ref_id;
            }
        }

        if($ignoredProfilesFromCriteriaMatch){
            foreach($ignoredProfilesFromCriteriaMatch as $ignoredProfile){
                $ignored[] = $ignoredProfile->user_ref_id;
            }
        }

        if($shortlistedProfilesFromCounsellorSuggested){
            foreach($shortlistedProfilesFromCounsellorSuggested as $shortlistedProfiles){
                $shortlisted[] = $shortlistedProfiles->user_ref_id;
            }
        }

        $merged = array_merge($bought, $ignored, $offered, $shortlisted);
        return array_unique($merged);
    }

    static public function isBannerCampaignExpired($bannerID = 0, $deActivate = false){

        $diBannersSql = "SELECT
        CASE WHEN dbc.campaign_type = 'Clicks' AND dbc.clicks_count < dbc.clicks_limit THEN 'Active'
         WHEN dbc.campaign_type = 'Impressions' AND dbc.impressions_count < dbc.impressions_limit THEN 'Active'
         WHEN dbc.campaign_type = 'Duration' AND CURDATE() BETWEEN dbc.duration_start_date AND
         dbc.duration_end_date THEN 'Active'
         ELSE 'InActive'
        END AS isActiveBanner
        FROM di_banner_campaign dbc WHERE dbc.di_banner_campaign_id='".$bannerID."'";
        $sResult = Yii::app()->db->createCommand($diBannersSql)->setFetchMode(PDO::FETCH_OBJ)->queryRow();
        if($sResult){

            if($deActivate && $sResult->isActiveBanner != 'Active'){
                $Sql = "UPDATE di_banner_campaign SET is_active='N' WHERE di_banner_campaign_id='".$bannerID."'";
                Yii::app()->db->createCommand($Sql)->execute();
            }
            return $sResult->isActiveBanner == 'Active' ? false : true;
        }
        return true;
    }
} 
?>
