<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityCostSummary is autogenerate by UniModel generator
 *
 * This is the model class for table "university_cost_summary".
 *
 * The followings are the available columns in table 'university_cost_summary':
 * @property string $university_cost_summary_id
 * @property integer $uni_ref_id
 * @property integer $department_ref_id
 * @property integer $currency_ref_id
 * @property integer $course_level_ref_id
 * @property string $fees_per_year
 * @property string $updated_on
 *
 * The followings are the available model relations:
 * @property LookupCourseLevel $courseLevelRef
 * @property LookupCurrency $currencyRef
 * @property LookupDepartment $departmentRef
 * @property TblUniversityMaster $uniRef
 */
class BaseUniversityCostSummary extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityCostSummary the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_cost_summary';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, department_ref_id, currency_ref_id, course_level_ref_id, fees_per_year, updated_on', 'required'),
			array('uni_ref_id, department_ref_id, currency_ref_id, course_level_ref_id', 'numerical', 'integerOnly'=>true),
			array('fees_per_year', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_cost_summary_id, uni_ref_id, department_ref_id, currency_ref_id, course_level_ref_id, fees_per_year, updated_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseLevelRef' => array(self::BELONGS_TO, 'LookupCourseLevel', 'course_level_ref_id'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_cost_summary_id' => 'University Cost Summary',
			'uni_ref_id' => 'Uni Ref',
			'department_ref_id' => 'Department Ref',
			'currency_ref_id' => 'Currency Ref',
			'course_level_ref_id' => 'Course Level Ref',
			'fees_per_year' => 'Fees Per Year',
			'updated_on' => 'Updated On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_cost_summary_id',$this->university_cost_summary_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('course_level_ref_id',$this->course_level_ref_id);
		$criteria->compare('fees_per_year',$this->fees_per_year,true);
		$criteria->compare('updated_on',$this->updated_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}