<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupCurrencyConversion is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_currency_conversion".
 *
 * The followings are the available columns in table 'lookup_currency_conversion':
 * @property integer $lookup_currency_conversion_id
 * @property integer $from_currency_ref_id
 * @property integer $to_currency_ref_id
 * @property string $rate
 * @property string $updated_on
 *
 * The followings are the available model relations:
 * @property LookupCurrency $fromCurrencyRef
 * @property LookupCurrency $toCurrencyRef
 */
class BaseLookupCurrencyConversion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupCurrencyConversion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_currency_conversion';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('from_currency_ref_id, to_currency_ref_id, rate, updated_on', 'required'),
			array('from_currency_ref_id, to_currency_ref_id', 'numerical', 'integerOnly'=>true),
			array('rate', 'length', 'max'=>8),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('lookup_currency_conversion_id, from_currency_ref_id, to_currency_ref_id, rate, updated_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'fromCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'from_currency_ref_id'),
			'toCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'to_currency_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'lookup_currency_conversion_id' => 'Lookup Currency Conversion',
			'from_currency_ref_id' => 'From Currency Ref',
			'to_currency_ref_id' => 'To Currency Ref',
			'rate' => 'Rate',
			'updated_on' => 'Updated On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('lookup_currency_conversion_id',$this->lookup_currency_conversion_id);
		$criteria->compare('from_currency_ref_id',$this->from_currency_ref_id);
		$criteria->compare('to_currency_ref_id',$this->to_currency_ref_id);
		$criteria->compare('rate',$this->rate,true);
		$criteria->compare('updated_on',$this->updated_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}