<?php
class ConvertController extends Controller
{
    public $sourceUrl = 'http://www.google.com/finance/converter';

    public function actionIndex($currency = 0, $conversionFrom = '', $conversionTo = '')
    {
        $response = $this->runCurl($currency, $conversionFrom, $conversionTo);
        preg_match('%<div id=currency_converter_result>([\d.]+) ' . $conversionFrom . ' = <span class=[^>]*>([\d.]+) ' . $conversionTo . '</span>%s', $response, $matches);
        //self::printr($matches);
        return $matches;
    }

    public function actionRunCron()
    {
        $currencyList = LookupCurrency::model()->findAll();
        foreach ($currencyList as $list) {
            foreach ($currencyList as $list2) {
                if ($list->attributes['currency_code'] != $list2->attributes['currency_code']) {
                    $currencyValues = $this->convert(1, $list->attributes['currency_code'], $list2->attributes['currency_code']);
                    if($currencyValues[2] > 0){
                        $currencyAttributes = array('from_currency_ref_id' => $list->attributes['currency_id'],
                            'to_currency_ref_id' => $list2->attributes['currency_id'],
                            'rate' => $currencyValues[2],
                            'updated_on' => date('Y-m-d H:i:s'));
                        $modelExists = LookupCurrencyConversion::model()->find('from_currency_ref_id = ' . $list->attributes['currency_id'] .
                            ' AND to_currency_ref_id = ' . $list2->attributes['currency_id']);
                        $currencyConvertion = ($modelExists) ? $modelExists : new LookupCurrencyConversion();
                        $currencyConvertion->setAttributes($currencyAttributes);
                        $currencyConvertion->save(false);
                    }

                }
            }
        }
    }

    public function convert($currency = 0, $conversionFrom = '', $conversionTo = '')
    {
        $response = self::runCurl($currency, $conversionFrom, $conversionTo);
        preg_match('%<div id=currency_converter_result>([\d.]+) ' . $conversionFrom . ' = <span class=[^>]*>([\d.]+) ' . $conversionTo . '</span>%s', $response, $matches);
        return $matches;
    }

    public function runCurl($currency = 0, $conversionFrom = '', $conversionTo = '')
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $this->sourceUrl . "?a=" . $currency . "&from=" . $conversionFrom . "&to=" . $conversionTo);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    public function trimWhiteSpacesNewLines($html)
    {
        $html = preg_replace('/\r\n|\n|\r/', '', $html);
        $html = preg_replace('/>\s*</', '><', $html);
        return $html;
    }

    public function printr($array = array())
    {
        echo '<pre>';
        print_r($array);
        echo '</pre>';
    }
}