<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWorkshopSiGroupStudentFeedback is autogenerate by UniModel generator
 *
 * This is the model class for table "workshop_si_group_student_feedback".
 *
 * The followings are the available columns in table 'workshop_si_group_student_feedback':
 * @property string $workshop_si_group_student_feedback_id
 * @property string $workshop_si_group_student_ref_id
 * @property integer $feedback_type_ref_id
 * @property string $user_ref_id
 * @property string $attendee
 * @property string $comments
 * @property integer $is_testimonial
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 * @property integer $modified_by
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupFeedbackType $feedbackTypeRef
 * @property WorkshopSiGroupStudent $workshopSiGroupStudentRef
 * @property WorkshopSiGroupStudentFeedbackAnswer[] $workshopSiGroupStudentFeedbackAnswers
 */
class BaseWorkshopSiGroupStudentFeedback extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkshopSiGroupStudentFeedback the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workshop_si_group_student_feedback';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('workshop_si_group_student_ref_id, feedback_type_ref_id, user_ref_id, added_on', 'required'),
			array('feedback_type_ref_id, is_testimonial, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('workshop_si_group_student_ref_id, user_ref_id', 'length', 'max'=>10),
			array('attendee', 'length', 'max'=>8),
			array('comments, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workshop_si_group_student_feedback_id, workshop_si_group_student_ref_id, feedback_type_ref_id, user_ref_id, attendee, comments, is_testimonial, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'feedbackTypeRef' => array(self::BELONGS_TO, 'LookupFeedbackType', 'feedback_type_ref_id'),
			'workshopSiGroupStudentRef' => array(self::BELONGS_TO, 'WorkshopSiGroupStudent', 'workshop_si_group_student_ref_id'),
			'workshopSiGroupStudentFeedbackAnswers' => array(self::HAS_MANY, 'WorkshopSiGroupStudentFeedbackAnswer', 'workshop_si_group_student_feedback_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workshop_si_group_student_feedback_id' => 'Workshop Si Group Student Feedback',
			'workshop_si_group_student_ref_id' => 'Workshop Si Group Student Ref',
			'feedback_type_ref_id' => 'Feedback Type Ref',
			'user_ref_id' => 'User Ref',
			'attendee' => 'Attendee',
			'comments' => 'Comments',
			'is_testimonial' => 'Is Testimonial',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workshop_si_group_student_feedback_id',$this->workshop_si_group_student_feedback_id,true);
		$criteria->compare('workshop_si_group_student_ref_id',$this->workshop_si_group_student_ref_id,true);
		$criteria->compare('feedback_type_ref_id',$this->feedback_type_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('attendee',$this->attendee,true);
		$criteria->compare('comments',$this->comments,true);
		$criteria->compare('is_testimonial',$this->is_testimonial);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}