<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorRequestCentreVisit is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_request_centre_visit".
 *
 * The followings are the available columns in table 'vendor_request_centre_visit':
 * @property string $vendor_request_centre_visit_id
 * @property string $user_ref_id
 * @property string $first_name
 * @property string $last_name
 * @property string $email
 * @property string $mobile_number
 * @property integer $passout_year
 * @property string $vendor_centre_ref_id
 * @property integer $entrance_exam_ref_id
 * @property string $student_contact_ref_id
 * @property string $time_slot
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property VendorBannerRequestCentreVisit[] $vendorBannerRequestCentreVisits
 * @property EntranceExam $entranceExamRef
 * @property StudentContactNumber $studentContactRef
 * @property TblUserMaster $userRef
 * @property VendorCentre $vendorCentreRef
 */
class BaseVendorRequestCentreVisit extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorRequestCentreVisit the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_request_centre_visit';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('passout_year, entrance_exam_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, vendor_centre_ref_id, student_contact_ref_id', 'length', 'max'=>10),
			array('first_name, last_name, email', 'length', 'max'=>100),
			array('mobile_number', 'length', 'max'=>20),
			array('time_slot, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_request_centre_visit_id, user_ref_id, first_name, last_name, email, mobile_number, passout_year, vendor_centre_ref_id, entrance_exam_ref_id, student_contact_ref_id, time_slot, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorBannerRequestCentreVisits' => array(self::HAS_MANY, 'VendorBannerRequestCentreVisit', 'vendor_request_centre_visit_ref_id'),
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'studentContactRef' => array(self::BELONGS_TO, 'StudentContactNumber', 'student_contact_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_request_centre_visit_id' => 'Vendor Request Centre Visit',
			'user_ref_id' => 'User Ref',
			'first_name' => 'First Name',
			'last_name' => 'Last Name',
			'email' => 'Email',
			'mobile_number' => 'Mobile Number',
			'passout_year' => 'Passout Year',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'student_contact_ref_id' => 'Student Contact Ref',
			'time_slot' => 'Time Slot',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_request_centre_visit_id',$this->vendor_request_centre_visit_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('mobile_number',$this->mobile_number,true);
		$criteria->compare('passout_year',$this->passout_year);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('student_contact_ref_id',$this->student_contact_ref_id,true);
		$criteria->compare('time_slot',$this->time_slot,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}