<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserProfileScore is autogenerate by UniModel generator
 *
 * This is the model class for table "user_profile_score".
 *
 * The followings are the available columns in table 'user_profile_score':
 * @property string $user_profile_score_id
 * @property string $user_ref_id
 * @property string $profile_score
 * @property string $short_term_activity_score
 * @property string $long_term_activity_score
 * @property string $short_term_score
 * @property string $long_term_score
 * @property string $overall_score
 * @property string $added_on
 * @property integer $advisor_ref_id
 * @property string $assigned_date
 * @property integer $user_current_status
 * @property integer $assigned_by
 *
 * The followings are the available model relations:
 * @property ProfileScoreInteraction[] $profileScoreInteractions
 * @property TblAdmin $assignedBy
 * @property TblAdmin $advisorRef
 * @property LookupProfileScoreStatus $userCurrentStatus
 * @property TblUserMaster $userRef
 */
class BaseUserProfileScore extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserProfileScore the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_profile_score';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('advisor_ref_id, user_current_status, assigned_by', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('profile_score, short_term_activity_score, long_term_activity_score, short_term_score, long_term_score, overall_score', 'length', 'max'=>4),
			array('added_on, assigned_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_profile_score_id, user_ref_id, profile_score, short_term_activity_score, long_term_activity_score, short_term_score, long_term_score, overall_score, added_on, advisor_ref_id, assigned_date, user_current_status, assigned_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'profileScoreInteractions' => array(self::HAS_MANY, 'ProfileScoreInteraction', 'user_profile_score_ref_id'),
			'assignedBy' => array(self::BELONGS_TO, 'TblAdmin', 'assigned_by'),
			'advisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_ref_id'),
			'userCurrentStatus' => array(self::BELONGS_TO, 'LookupProfileScoreStatus', 'user_current_status'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_profile_score_id' => 'User Profile Score',
			'user_ref_id' => 'User Ref',
			'profile_score' => 'Profile Score',
			'short_term_activity_score' => 'Short Term Activity Score',
			'long_term_activity_score' => 'Long Term Activity Score',
			'short_term_score' => 'Short Term Score',
			'long_term_score' => 'Long Term Score',
			'overall_score' => 'Overall Score',
			'added_on' => 'Added On',
			'advisor_ref_id' => 'Advisor Ref',
			'assigned_date' => 'Assigned Date',
			'user_current_status' => 'User Current Status',
			'assigned_by' => 'Assigned By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_profile_score_id',$this->user_profile_score_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('profile_score',$this->profile_score,true);
		$criteria->compare('short_term_activity_score',$this->short_term_activity_score,true);
		$criteria->compare('long_term_activity_score',$this->long_term_activity_score,true);
		$criteria->compare('short_term_score',$this->short_term_score,true);
		$criteria->compare('long_term_score',$this->long_term_score,true);
		$criteria->compare('overall_score',$this->overall_score,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('assigned_date',$this->assigned_date,true);
		$criteria->compare('user_current_status',$this->user_current_status);
		$criteria->compare('assigned_by',$this->assigned_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}