<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailExtensionLog is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_extension_log".
 *
 * The followings are the available columns in table 'umail_extension_log':
 * @property string $umail_extension_id
 * @property integer $message_ref_id
 * @property integer $extension_by
 * @property string $original_date
 * @property string $extended_date
 * @property string $comments
 */
class BaseUmailExtensionLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailExtensionLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_extension_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('message_ref_id, extension_by', 'required'),
			array('message_ref_id, extension_by', 'numerical', 'integerOnly'=>true),
			array('original_date, extended_date, comments', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_extension_id, message_ref_id, extension_by, original_date, extended_date, comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_extension_id' => 'Umail Extension',
			'message_ref_id' => 'Message Ref',
			'extension_by' => 'Extension By',
			'original_date' => 'Original Date',
			'extended_date' => 'Extended Date',
			'comments' => 'Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_extension_id',$this->umail_extension_id,true);
		$criteria->compare('message_ref_id',$this->message_ref_id);
		$criteria->compare('extension_by',$this->extension_by);
		$criteria->compare('original_date',$this->original_date,true);
		$criteria->compare('extended_date',$this->extended_date,true);
		$criteria->compare('comments',$this->comments,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}