<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailExceptionAttachment is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_exception_attachment".
 *
 * The followings are the available columns in table 'umail_exception_attachment':
 * @property string $umail_exception_attachment_id
 * @property string $umail_exception_ref_id
 * @property string $attachment_name
 * @property string $original_file_name
 * @property string $added_on
 */
class BaseUmailExceptionAttachment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailExceptionAttachment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_exception_attachment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('umail_exception_ref_id', 'required'),
			array('umail_exception_ref_id', 'length', 'max'=>10),
			array('attachment_name, original_file_name', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_exception_attachment_id, umail_exception_ref_id, attachment_name, original_file_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_exception_attachment_id' => 'Umail Exception Attachment',
			'umail_exception_ref_id' => 'Umail Exception Ref',
			'attachment_name' => 'Attachment Name',
			'original_file_name' => 'Original File Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_exception_attachment_id',$this->umail_exception_attachment_id,true);
		$criteria->compare('umail_exception_ref_id',$this->umail_exception_ref_id,true);
		$criteria->compare('attachment_name',$this->attachment_name,true);
		$criteria->compare('original_file_name',$this->original_file_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}