<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblInteractionDetails is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_interaction_details".
 *
 * The followings are the available columns in table 'tbl_interaction_details':
 * @property integer $id
 * @property string $user_ref_id
 * @property integer $interaction_ref_id
 * @property string $added_on
 * @property string $logged_by
 * @property string $conversation_text
 *
 * The followings are the available model relations:
 * @property MasterInteraction $interactionRef
 * @property TblUserMaster $userRef
 */
class BaseTblInteractionDetails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblInteractionDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_interaction_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, interaction_ref_id, added_on, logged_by', 'required'),
			array('interaction_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('logged_by', 'length', 'max'=>45),
			array('conversation_text', 'length', 'max'=>1024),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, user_ref_id, interaction_ref_id, added_on, logged_by, conversation_text', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'interactionRef' => array(self::BELONGS_TO, 'MasterInteraction', 'interaction_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_ref_id' => 'User Ref',
			'interaction_ref_id' => 'Interaction Ref',
			'added_on' => 'Added On',
			'logged_by' => 'Logged By',
			'conversation_text' => 'Conversation Text',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('interaction_ref_id',$this->interaction_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('logged_by',$this->logged_by,true);
		$criteria->compare('conversation_text',$this->conversation_text,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}