<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTask is autogenerate by UniModel generator
 *
 * This is the model class for table "task".
 *
 * The followings are the available columns in table 'task':
 * @property string $task_id
 * @property integer $task_audience_ref_id
 * @property integer $creator
 * @property integer $assigned_to
 * @property integer $reassigned_to
 * @property integer $task_status_ref_id
 * @property string $start_date
 * @property string $end_date
 * @property string $title
 * @property string $description
 * @property string $added_on
 * @property string $modified_on
 * @property integer $modified_by
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property StudentWorkplan[] $studentWorkplans
 * @property TblAdmin $modifiedBy
 * @property TblAdmin $assignedTo
 * @property TblAdmin $creator0
 * @property TblAdmin $reassignedTo
 * @property LookupTaskAudience $taskAudienceRef
 * @property LookupTaskStatus $taskStatusRef
 * @property TaskComments[] $taskComments
 * @property TaskLog[] $taskLogs
 * @property TaskSchool[] $taskSchools
 * @property TaskStudent[] $taskStudents
 */
class BaseTask extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Task the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'task';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('task_audience_ref_id, creator, assigned_to, task_status_ref_id', 'required'),
			array('task_audience_ref_id, creator, assigned_to, reassigned_to, task_status_ref_id, modified_by, is_active', 'numerical', 'integerOnly'=>true),
			array('title', 'length', 'max'=>255),
			array('start_date, end_date, description, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('task_id, task_audience_ref_id, creator, assigned_to, reassigned_to, task_status_ref_id, start_date, end_date, title, description, added_on, modified_on, modified_by, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'studentWorkplans' => array(self::HAS_MANY, 'StudentWorkplan', 'task_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'assignedTo' => array(self::BELONGS_TO, 'TblAdmin', 'assigned_to'),
			'creator0' => array(self::BELONGS_TO, 'TblAdmin', 'creator'),
			'reassignedTo' => array(self::BELONGS_TO, 'TblAdmin', 'reassigned_to'),
			'taskAudienceRef' => array(self::BELONGS_TO, 'LookupTaskAudience', 'task_audience_ref_id'),
			'taskStatusRef' => array(self::BELONGS_TO, 'LookupTaskStatus', 'task_status_ref_id'),
			'taskComments' => array(self::HAS_MANY, 'TaskComments', 'task_ref_id'),
			'taskLogs' => array(self::HAS_MANY, 'TaskLog', 'task_ref_id'),
			'taskSchools' => array(self::HAS_MANY, 'TaskSchool', 'task_ref_id'),
			'taskStudents' => array(self::HAS_MANY, 'TaskStudent', 'task_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'task_id' => 'Task',
			'task_audience_ref_id' => 'Task Audience Ref',
			'creator' => 'Creator',
			'assigned_to' => 'Assigned To',
			'reassigned_to' => 'Reassigned To',
			'task_status_ref_id' => 'Task Status Ref',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'title' => 'Title',
			'description' => 'Description',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('task_id',$this->task_id,true);
		$criteria->compare('task_audience_ref_id',$this->task_audience_ref_id);
		$criteria->compare('creator',$this->creator);
		$criteria->compare('assigned_to',$this->assigned_to);
		$criteria->compare('reassigned_to',$this->reassigned_to);
		$criteria->compare('task_status_ref_id',$this->task_status_ref_id);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}