<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentProfileValidationLog is autogenerate by UniModel generator
 *
 * This is the model class for table "student_profile_validation_log".
 *
 * The followings are the available columns in table 'student_profile_validation_log':
 * @property string $student_profile_validation_log_id
 * @property string $user_ref_id
 * @property string $confirm_type
 * @property integer $is_confirm
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LoginMaster $addedBy
 */
class BaseStudentProfileValidationLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentProfileValidationLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_profile_validation_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_by, added_on', 'required'),
			array('is_confirm', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, confirm_type, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('student_profile_validation_log_id, user_ref_id, confirm_type, is_confirm, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'student_profile_validation_log_id' => 'Student Profile Validation Log',
			'user_ref_id' => 'User Ref',
			'confirm_type' => 'Confirm Type',
			'is_confirm' => 'Is Confirm',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('student_profile_validation_log_id',$this->student_profile_validation_log_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('confirm_type',$this->confirm_type,true);
		$criteria->compare('is_confirm',$this->is_confirm);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}