<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseStudentPreferredPeriod is autogenerate by UniModel generator
 *
 * This is the model class for table "student_preferred_period".
 *
 * The followings are the available columns in table 'student_preferred_period':
 * @property string $preferred_period_id
 * @property string $user_ref_id
 * @property integer $period_ref_id
 * @property integer $from_month
 * @property integer $to_month
 * @property integer $year
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupLikelyPeriod $periodRef
 * @property TblUserMaster $userRef
 */
class BaseStudentPreferredPeriod extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredPeriod the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_period';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('period_ref_id, from_month, to_month, year', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_period_id, user_ref_id, period_ref_id, from_month, to_month, year, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'periodRef' => array(self::BELONGS_TO, 'LookupLikelyPeriod', 'period_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_period_id' => 'Preferred Period',
			'user_ref_id' => 'User Ref',
			'period_ref_id' => 'Period Ref',
			'from_month' => 'From Month',
			'to_month' => 'To Month',
			'year' => 'Year',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_period_id',$this->preferred_period_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('period_ref_id',$this->period_ref_id);
		$criteria->compare('from_month',$this->from_month);
		$criteria->compare('to_month',$this->to_month);
		$criteria->compare('year',$this->year);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

}