<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSessionBooking is autogenerate by UniModel generator
 *
 * This is the model class for table "session_booking".
 *
 * The followings are the available columns in table 'session_booking':
 * @property string $booking_id
 * @property string $student_ref_id
 * @property string $order_master_ref_id
 * @property string $student_name
 * @property string $email_id
 * @property string $contact_number
 * @property string $present_class
 * @property string $duration
 * @property integer $country_ref_id
 * @property integer $department_ref_id
 * @property string $session_type
 * @property string $session_type_details
 * @property string $added_on
 * @property string $modified_on
 * @property string $modified_by
 * @property string $session_unique_id
 *
 * The followings are the available model relations:
 * @property SessionBookingTimeslot[] $sessionBookingTimeslots
 */
class BaseSessionBooking extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SessionBooking the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'session_booking';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('email_id, country_ref_id, department_ref_id, added_on, session_unique_id', 'required'),
			array('country_ref_id, department_ref_id', 'numerical', 'integerOnly'=>true),
			array('student_ref_id, order_master_ref_id, modified_by', 'length', 'max'=>10),
			array('student_name, session_type_details', 'length', 'max'=>100),
			array('email_id', 'length', 'max'=>255),
			array('contact_number', 'length', 'max'=>50),
			array('present_class', 'length', 'max'=>2),
			array('duration', 'length', 'max'=>7),
			array('session_type', 'length', 'max'=>12),
			array('session_unique_id', 'length', 'max'=>15),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('booking_id, student_ref_id, order_master_ref_id, student_name, email_id, contact_number, present_class, duration, country_ref_id, department_ref_id, session_type, session_type_details, added_on, modified_on, modified_by, session_unique_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'sessionBookingTimeslots' => array(self::HAS_MANY, 'SessionBookingTimeslot', 'booking_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'booking_id' => 'Booking',
			'student_ref_id' => 'Student Ref',
			'order_master_ref_id' => 'Order Master Ref',
			'student_name' => 'Student Name',
			'email_id' => 'Email',
			'contact_number' => 'Contact Number',
			'present_class' => 'Present Class',
			'duration' => 'Duration',
			'country_ref_id' => 'Country Ref',
			'department_ref_id' => 'Department Ref',
			'session_type' => 'Session Type',
			'session_type_details' => 'Session Type Details',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'session_unique_id' => 'Session Unique',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('booking_id',$this->booking_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('order_master_ref_id',$this->order_master_ref_id,true);
		$criteria->compare('student_name',$this->student_name,true);
		$criteria->compare('email_id',$this->email_id,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('present_class',$this->present_class,true);
		$criteria->compare('duration',$this->duration,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('session_type',$this->session_type,true);
		$criteria->compare('session_type_details',$this->session_type_details,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('session_unique_id',$this->session_unique_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}