<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseSeoScholarship is autogenerate by UniModel generator
 *
 * This is the model class for table "seo_scholarship".
 *
 * The followings are the available columns in table 'seo_scholarship':
 * @property string $seo_scholarship_id
 * @property string $scholarship_ref_id
 * @property string $heading
 * @property string $title
 * @property string $meta_keyword
 * @property string $meta_desc
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Scholarship $scholarshipRef
 */
class BaseSeoScholarship extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SeoScholarship the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'seo_scholarship';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id', 'length', 'max'=>10),
			array('heading, title', 'length', 'max'=>255),
			array('meta_keyword, meta_desc, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('seo_scholarship_id, scholarship_ref_id, heading, title, meta_keyword, meta_desc, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'seo_scholarship_id' => 'Seo Scholarship',
			'scholarship_ref_id' => 'Scholarship Ref',
			'heading' => 'Heading',
			'title' => 'Title',
			'meta_keyword' => 'Meta Keyword',
			'meta_desc' => 'Meta Desc',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('seo_scholarship_id',$this->seo_scholarship_id,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('heading',$this->heading,true);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('meta_keyword',$this->meta_keyword,true);
		$criteria->compare('meta_desc',$this->meta_desc,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}