<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseScholarshipFinancialNeed is autogenerate by UniModel generator
 *
 * This is the model class for table "scholarship_financial_need".
 *
 * The followings are the available columns in table 'scholarship_financial_need':
 * @property integer $scholarship_financial_need_id
 * @property string $scholarship_ref_id
 * @property string $comparison_operator
 * @property integer $reservation_ref_id
 * @property integer $currency_ref_id
 * @property double $amount
 * @property string $added_on
 * @property integer $added_by
 *
 * The followings are the available model relations:
 * @property Scholarship $scholarshipRef
 * @property LookupReservation $reservationRef
 * @property LookupCurrency $currencyRef
 * @property LoginMaster $addedBy
 */
class BaseScholarshipFinancialNeed extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ScholarshipFinancialNeed the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'scholarship_financial_need';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('scholarship_ref_id, added_by', 'required'),
			array('reservation_ref_id, currency_ref_id, added_by', 'numerical', 'integerOnly'=>true),
			array('amount', 'numerical'),
			array('scholarship_ref_id', 'length', 'max'=>10),
			array('comparison_operator', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('scholarship_financial_need_id, scholarship_ref_id, comparison_operator, reservation_ref_id, currency_ref_id, amount, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'reservationRef' => array(self::BELONGS_TO, 'LookupReservation', 'reservation_ref_id'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'scholarship_financial_need_id' => 'Scholarship Financial Need',
			'scholarship_ref_id' => 'Scholarship Ref',
			'comparison_operator' => 'Comparison Operator',
			'reservation_ref_id' => 'Reservation Ref',
			'currency_ref_id' => 'Currency Ref',
			'amount' => 'Amount',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('scholarship_financial_need_id',$this->scholarship_financial_need_id);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('comparison_operator',$this->comparison_operator,true);
		$criteria->compare('reservation_ref_id',$this->reservation_ref_id);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('amount',$this->amount);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}