<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseOfflineF2fCounsellor is autogenerate by UniModel generator
 *
 * This is the model class for table "offline_f2f_counsellor".
 *
 * The followings are the available columns in table 'offline_f2f_counsellor':
 * @property string $f2f_id
 * @property integer $inst_ref_id
 * @property integer $f2f_counsellor
 * @property string $start_date
 * @property string $end_date
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TblAdmin $f2fCounsellor
 * @property TblSiDi $instRef
 */
class BaseOfflineF2fCounsellor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OfflineF2fCounsellor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'offline_f2f_counsellor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inst_ref_id, f2f_counsellor, start_date, end_date, is_active, added_on, added_by', 'required'),
			array('inst_ref_id, f2f_counsellor', 'numerical', 'integerOnly'=>true),
			array('is_active', 'length', 'max'=>1),
			array('added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('f2f_id, inst_ref_id, f2f_counsellor, start_date, end_date, is_active, added_on, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'f2fCounsellor' => array(self::BELONGS_TO, 'TblAdmin', 'f2f_counsellor'),
			'instRef' => array(self::BELONGS_TO, 'TblSiDi', 'inst_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'f2f_id' => 'F2f',
			'inst_ref_id' => 'Inst Ref',
			'f2f_counsellor' => 'F2f Counsellor',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('f2f_id',$this->f2f_id,true);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('f2f_counsellor',$this->f2f_counsellor);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}