<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseMessageRating is autogenerate by UniModel generator
 *
 * This is the model class for table "message_rating".
 *
 * The followings are the available columns in table 'message_rating':
 * @property integer $rating_id
 * @property integer $message_id
 * @property string $rating
 * @property string $rating_by
 * @property string $added_on
 * @property string $comments
 *
 * The followings are the available model relations:
 * @property UmailMessage $message
 */
class BaseMessageRating extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MessageRating the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'message_rating';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('message_id', 'required'),
			array('message_id', 'numerical', 'integerOnly'=>true),
			array('rating', 'length', 'max'=>3),
			array('rating_by', 'length', 'max'=>45),
			array('comments', 'length', 'max'=>100),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('rating_id, message_id, rating, rating_by, added_on, comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'message' => array(self::BELONGS_TO, 'UmailMessage', 'message_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'rating_id' => 'Rating',
			'message_id' => 'Message',
			'rating' => 'Rating',
			'rating_by' => 'Rating By',
			'added_on' => 'Added On',
			'comments' => 'Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('rating_id',$this->rating_id);
		$criteria->compare('message_id',$this->message_id);
		$criteria->compare('rating',$this->rating,true);
		$criteria->compare('rating_by',$this->rating_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('comments',$this->comments,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}