<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupSocialMedia is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_social_media".
 *
 * The followings are the available columns in table 'lookup_social_media':
 * @property integer $social_media_id
 * @property string $media_name
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property UniversitySocialMedia[] $universitySocialMedias
 */
class BaseLookupSocialMedia extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupSocialMedia the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_social_media';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('media_name, added_on', 'required'),
			array('media_name', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('social_media_id, media_name, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'universitySocialMedias' => array(self::HAS_MANY, 'UniversitySocialMedia', 'social_media_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'social_media_id' => 'Social Media',
			'media_name' => 'Media Name',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('social_media_id',$this->social_media_id);
		$criteria->compare('media_name',$this->media_name,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}