<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupPaymentType is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_payment_type".
 *
 * The followings are the available columns in table 'lookup_payment_type':
 * @property integer $payment_type_id
 * @property string $payment_name
 * @property string $payment_shortcode
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property OrderPayment[] $orderPayments
 */
class BaseLookupPaymentType extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupPaymentType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_payment_type';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('payment_name', 'required'),
			array('is_active', 'numerical', 'integerOnly'=>true),
			array('payment_name, payment_shortcode', 'length', 'max'=>45),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('payment_type_id, payment_name, payment_shortcode, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'orderPayments' => array(self::HAS_MANY, 'OrderPayment', 'payment_type_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'payment_type_id' => 'Payment Type',
			'payment_name' => 'Payment Name',
			'payment_shortcode' => 'Payment Shortcode',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('payment_type_id',$this->payment_type_id);
		$criteria->compare('payment_name',$this->payment_name,true);
		$criteria->compare('payment_shortcode',$this->payment_shortcode,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}