<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupHoliday is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_holiday".
 *
 * The followings are the available columns in table 'lookup_holiday':
 * @property integer $holiday_id
 * @property string $dates
 * @property string $day_type
 * @property string $day_name
 */
class BaseLookupHoliday extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupHoliday the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_holiday';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('dates, day_type, day_name', 'required'),
			array('day_type', 'length', 'max'=>7),
			array('day_name', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('holiday_id, dates, day_type, day_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'holiday_id' => 'Holiday',
			'dates' => 'Dates',
			'day_type' => 'Day Type',
			'day_name' => 'Day Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('holiday_id',$this->holiday_id);
		$criteria->compare('dates',$this->dates,true);
		$criteria->compare('day_type',$this->day_type,true);
		$criteria->compare('day_name',$this->day_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}