<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseLookupDegreeGranted is autogenerate by UniModel generator
 *
 * This is the model class for table "lookup_degree_granted".
 *
 * The followings are the available columns in table 'lookup_degree_granted':
 * @property integer $degree_granted_id
 * @property integer $popular_degree_ref_id
 * @property string $degree_name
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupPopularDegree $popularDegreeRef
 * @property MdmNewCourseLog[] $mdmNewCourseLogs
 * @property TblUniCourses[] $tblUniCourses
 */
class BaseLookupDegreeGranted extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupDegreeGranted the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_degree_granted';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('popular_degree_ref_id, degree_name, added_on', 'required'),
			array('popular_degree_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('degree_name', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('degree_granted_id, popular_degree_ref_id, degree_name, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'popularDegreeRef' => array(self::BELONGS_TO, 'LookupPopularDegree', 'popular_degree_ref_id'),
			'mdmNewCourseLogs' => array(self::HAS_MANY, 'MdmNewCourseLog', 'degree_granted_ref_id'),
			'tblUniCourses' => array(self::HAS_MANY, 'TblUniCourses', 'degree_granted_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'degree_granted_id' => 'Degree Granted',
			'popular_degree_ref_id' => 'Popular Degree Ref',
			'degree_name' => 'Degree Name',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('degree_granted_id',$this->degree_granted_id);
		$criteria->compare('popular_degree_ref_id',$this->popular_degree_ref_id);
		$criteria->compare('degree_name',$this->degree_name,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}