<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseInvoice is autogenerate by UniModel generator
 *
 * This is the model class for table "invoice".
 *
 * The followings are the available columns in table 'invoice':
 * @property string $invoice_id
 * @property string $invoice_number
 * @property string $to_name
 * @property string $to_address
 * @property double $invoice_amount
 * @property double $discount
 * @property double $tax
 * @property string $invoice_date
 * @property string $invoice_due_date
 * @property string $notes
 * @property string $added_on
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property InvoiceItem[] $invoiceItems
 * @property InvoiceLog[] $invoiceLogs
 * @property InvoicePayment[] $invoicePayments
 */
class BaseInvoice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Invoice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'invoice';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invoice_number, to_name, to_address, invoice_date, added_on', 'required'),
			array('invoice_amount, discount, tax', 'numerical'),
			array('invoice_number', 'length', 'max'=>20),
			array('to_name', 'length', 'max'=>75),
			array('invoice_due_date, notes, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('invoice_id, invoice_number, to_name, to_address, invoice_amount, discount, tax, invoice_date, invoice_due_date, notes, added_on, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'invoiceItems' => array(self::HAS_MANY, 'InvoiceItem', 'invoice_ref_id'),
			'invoiceLogs' => array(self::HAS_MANY, 'InvoiceLog', 'invoice_ref_id'),
			'invoicePayments' => array(self::HAS_MANY, 'InvoicePayment', 'invoice_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'invoice_id' => 'Invoice',
			'invoice_number' => 'Invoice Number',
			'to_name' => 'To Name',
			'to_address' => 'To Address',
			'invoice_amount' => 'Invoice Amount',
			'discount' => 'Discount',
			'tax' => 'Tax',
			'invoice_date' => 'Invoice Date',
			'invoice_due_date' => 'Invoice Due Date',
			'notes' => 'Notes',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('invoice_id',$this->invoice_id,true);
		$criteria->compare('invoice_number',$this->invoice_number,true);
		$criteria->compare('to_name',$this->to_name,true);
		$criteria->compare('to_address',$this->to_address,true);
		$criteria->compare('invoice_amount',$this->invoice_amount);
		$criteria->compare('discount',$this->discount);
		$criteria->compare('tax',$this->tax);
		$criteria->compare('invoice_date',$this->invoice_date,true);
		$criteria->compare('invoice_due_date',$this->invoice_due_date,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}