<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEventStudent is autogenerate by UniModel generator
 *
 * This is the model class for table "event_student".
 *
 * The followings are the available columns in table 'event_student':
 * @property string $event_student_id
 * @property string $user_ref_id
 * @property integer $event_ref_id
 * @property string $event_si_ref_id
 * @property integer $is_active
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LookupEvent $eventRef
 * @property EventSi $eventSiRef
 * @property TblUserMaster $userRef
 */
class BaseEventStudent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EventStudent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'event_student';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('event_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, event_si_ref_id', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('event_student_id, user_ref_id, event_ref_id, event_si_ref_id, is_active, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'LookupEvent', 'event_ref_id'),
			'eventSiRef' => array(self::BELONGS_TO, 'EventSi', 'event_si_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'event_student_id' => 'Event Student',
			'user_ref_id' => 'User Ref',
			'event_ref_id' => 'Event Ref',
			'event_si_ref_id' => 'Event Si Ref',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('event_student_id',$this->event_student_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('event_si_ref_id',$this->event_si_ref_id,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}