<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamModule is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_module".
 *
 * The followings are the available columns in table 'entrance_exam_module':
 * @property integer $entrance_exam_module_id
 * @property string $module_name
 *
 * The followings are the available model relations:
 * @property DiUserCriteriaEntranceExam[] $diUserCriteriaEntranceExams
 * @property EntranceExamModuleEntranceExam[] $entranceExamModuleEntranceExams
 */
class BaseEntranceExamModule extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamModule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_module';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('module_name', 'required'),
			array('module_name', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_module_id, module_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diUserCriteriaEntranceExams' => array(self::HAS_MANY, 'DiUserCriteriaEntranceExam', 'entrance_exam_module_ref_id'),
			'entranceExamModuleEntranceExams' => array(self::HAS_MANY, 'EntranceExamModuleEntranceExam', 'entrance_exam_module_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_module_id' => 'Entrance Exam Module',
			'module_name' => 'Module Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_module_id',$this->entrance_exam_module_id);
		$criteria->compare('module_name',$this->module_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}