<?php

/** 
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseEntranceExamDate is autogenerate by UniModel generator
 *
 * This is the model class for table "entrance_exam_date".
 *
 * The followings are the available columns in table 'entrance_exam_date':
 * @property string $entrance_exam_date_id
 * @property integer $entrance_exam_ref_id
 * @property integer $start_day
 * @property integer $start_month
 * @property integer $start_year
 * @property integer $sales_last_day
 * @property integer $sales_last_month
 * @property integer $sales_last_year
 * @property integer $submission_last_day
 * @property integer $submission_last_month
 * @property integer $submission_last_year
 * @property integer $exam_day
 * @property integer $exam_month
 * @property integer $exam_year
 * @property integer $result_day
 * @property integer $result_month
 * @property integer $result_year
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property EntranceExam $entranceExamRef
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 */
class BaseEntranceExamDate extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EntranceExamDate the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'entrance_exam_date';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('entrance_exam_ref_id, added_by, modified_by', 'required'),
			array('entrance_exam_ref_id, start_day, start_month, start_year, sales_last_day, sales_last_month, sales_last_year, submission_last_day, submission_last_month, submission_last_year, exam_day, exam_month, exam_year, result_day, result_month, result_year, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('entrance_exam_date_id, entrance_exam_ref_id, start_day, start_month, start_year, sales_last_day, sales_last_month, sales_last_year, submission_last_day, submission_last_month, submission_last_year, exam_day, exam_month, exam_year, result_day, result_month, result_year, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'entranceExamRef' => array(self::BELONGS_TO, 'EntranceExam', 'entrance_exam_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'entrance_exam_date_id' => 'Entrance Exam Date',
			'entrance_exam_ref_id' => 'Entrance Exam Ref',
			'start_day' => 'Start Day',
			'start_month' => 'Start Month',
			'start_year' => 'Start Year',
			'sales_last_day' => 'Sales Last Day',
			'sales_last_month' => 'Sales Last Month',
			'sales_last_year' => 'Sales Last Year',
			'submission_last_day' => 'Submission Last Day',
			'submission_last_month' => 'Submission Last Month',
			'submission_last_year' => 'Submission Last Year',
			'exam_day' => 'Exam Day',
			'exam_month' => 'Exam Month',
			'exam_year' => 'Exam Year',
			'result_day' => 'Result Day',
			'result_month' => 'Result Month',
			'result_year' => 'Result Year',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('entrance_exam_date_id',$this->entrance_exam_date_id,true);
		$criteria->compare('entrance_exam_ref_id',$this->entrance_exam_ref_id);
		$criteria->compare('start_day',$this->start_day);
		$criteria->compare('start_month',$this->start_month);
		$criteria->compare('start_year',$this->start_year);
		$criteria->compare('sales_last_day',$this->sales_last_day);
		$criteria->compare('sales_last_month',$this->sales_last_month);
		$criteria->compare('sales_last_year',$this->sales_last_year);
		$criteria->compare('submission_last_day',$this->submission_last_day);
		$criteria->compare('submission_last_month',$this->submission_last_month);
		$criteria->compare('submission_last_year',$this->submission_last_year);
		$criteria->compare('exam_day',$this->exam_day);
		$criteria->compare('exam_month',$this->exam_month);
		$criteria->compare('exam_year',$this->exam_year);
		$criteria->compare('result_day',$this->result_day);
		$criteria->compare('result_month',$this->result_month);
		$criteria->compare('result_year',$this->result_year);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}