<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserEoiLogAttachment is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_eoi_log_attachment".
 *
 * The followings are the available columns in table 'di_user_eoi_log_attachment':
 * @property string $di_user_eoi_log_attachment_id
 * @property string $di_user_eoi_log_ref_id
 * @property string $email_attachment_ref_id
 * @property string $file_name
 * @property string $file_path
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property DiUserEoiLog $diUserEoiLogRef
 * @property EmailAttachment $emailAttachmentRef
 */
class BaseDiUserEoiLogAttachment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserEoiLogAttachment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_eoi_log_attachment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_user_eoi_log_ref_id, added_by, added_on', 'required'),
			array('di_user_eoi_log_ref_id, email_attachment_ref_id, added_by', 'length', 'max'=>10),
			array('file_name, file_path', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_eoi_log_attachment_id, di_user_eoi_log_ref_id, email_attachment_ref_id, file_name, file_path, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'diUserEoiLogRef' => array(self::BELONGS_TO, 'DiUserEoiLog', 'di_user_eoi_log_ref_id'),
			'emailAttachmentRef' => array(self::BELONGS_TO, 'EmailAttachment', 'email_attachment_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_eoi_log_attachment_id' => 'Di User Eoi Log Attachment',
			'di_user_eoi_log_ref_id' => 'Di User Eoi Log Ref',
			'email_attachment_ref_id' => 'Email Attachment Ref',
			'file_name' => 'File Name',
			'file_path' => 'File Path',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_eoi_log_attachment_id',$this->di_user_eoi_log_attachment_id,true);
		$criteria->compare('di_user_eoi_log_ref_id',$this->di_user_eoi_log_ref_id,true);
		$criteria->compare('email_attachment_ref_id',$this->email_attachment_ref_id,true);
		$criteria->compare('file_name',$this->file_name,true);
		$criteria->compare('file_path',$this->file_path,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}