<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiUserEoiLog is autogenerate by UniModel generator
 *
 * This is the model class for table "di_user_eoi_log".
 *
 * The followings are the available columns in table 'di_user_eoi_log':
 * @property string $di_user_eoi_log_id
 * @property string $di_user_eoi_ref_id
 * @property integer $main_department_ref_id
 * @property string $admission_chance
 * @property string $scholarship_ref_id
 * @property string $scholarship_name
 * @property string $scholarship_description
 * @property string $scholarship_amount
 * @property string $scholarship_chance
 * @property string $offer_message
 * @property string $eoi_status
 * @property string $marketing_message
 * @property string $fee_waiver_desc
 * @property string $fee_waiver_url
 * @property string $fee_waiver_code
 * @property string $fee_waiver_amount
 * @property string $ucounsellor_name
 * @property string $ucounsellor_email
 * @property string $ucounsellor_phone
 * @property string $added_on
 * @property string $added_by
 * @property string $responded_on
 * @property string $is_superstar
 *
 * The followings are the available model relations:
 * @property DiReviewEducation[] $diReviewEducations
 * @property DiReviewExam[] $diReviewExams
 * @property DiReviewExtraCurriculam[] $diReviewExtraCurriculams
 * @property DiUserEoi $diUserEoiRef
 * @property LoginMaster $addedBy
 * @property LookupDepartment $mainDepartmentRef
 * @property Scholarship $scholarshipRef
 * @property DiUserEoiLogAttachment[] $diUserEoiLogAttachments
 * @property DiUserEoiMessage[] $diUserEoiMessages
 * @property DiUserEoiScholarshipLog[] $diUserEoiScholarshipLogs
 * @property DiUserEoiSms[] $diUserEoiSms
 * @property EoiApplication[] $eoiApplications
 * @property EoiRequestCollege[] $eoiRequestColleges
 */
class BaseDiUserEoiLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiUserEoiLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_user_eoi_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on, added_by', 'required'),
			array('main_department_ref_id', 'numerical', 'integerOnly'=>true),
			array('di_user_eoi_ref_id, scholarship_ref_id, eoi_status, added_by', 'length', 'max'=>10),
			array('admission_chance, scholarship_chance', 'length', 'max'=>14),
			array('scholarship_name, scholarship_amount, ucounsellor_name', 'length', 'max'=>100),
			array('fee_waiver_url', 'length', 'max'=>255),
			array('fee_waiver_code, fee_waiver_amount, ucounsellor_email, ucounsellor_phone', 'length', 'max'=>50),
			array('is_superstar', 'length', 'max'=>1),
			array('scholarship_description, offer_message, marketing_message, fee_waiver_desc, responded_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_user_eoi_log_id, di_user_eoi_ref_id, main_department_ref_id, admission_chance, scholarship_ref_id, scholarship_name, scholarship_description, scholarship_amount, scholarship_chance, offer_message, eoi_status, marketing_message, fee_waiver_desc, fee_waiver_url, fee_waiver_code, fee_waiver_amount, ucounsellor_name, ucounsellor_email, ucounsellor_phone, added_on, added_by, responded_on, is_superstar', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diReviewEducations' => array(self::HAS_MANY, 'DiReviewEducation', 'di_user_eoi_log_ref_id'),
			'diReviewExams' => array(self::HAS_MANY, 'DiReviewExam', 'di_user_eoi_log_ref_id'),
			'diReviewExtraCurriculams' => array(self::HAS_MANY, 'DiReviewExtraCurriculam', 'di_user_eoi_log_ref_id'),
			'diUserEoiRef' => array(self::BELONGS_TO, 'DiUserEoi', 'di_user_eoi_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'mainDepartmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'main_department_ref_id'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'diUserEoiLogAttachments' => array(self::HAS_MANY, 'DiUserEoiLogAttachment', 'di_user_eoi_log_ref_id'),
			'diUserEoiMessages' => array(self::HAS_MANY, 'DiUserEoiMessage', 'di_user_eoi_log_ref_id'),
			'diUserEoiScholarshipLogs' => array(self::HAS_MANY, 'DiUserEoiScholarshipLog', 'di_user_eoi_log_ref_id'),
			'diUserEoiSms' => array(self::HAS_MANY, 'DiUserEoiSms', 'di_user_eoi_log_ref_id'),
			'eoiApplications' => array(self::HAS_MANY, 'EoiApplication', 'di_user_eoi_log_ref_id'),
			'eoiRequestColleges' => array(self::HAS_MANY, 'EoiRequestCollege', 'di_user_eoi_log_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_user_eoi_log_id' => 'Di User Eoi Log',
			'di_user_eoi_ref_id' => 'Di User Eoi Ref',
			'main_department_ref_id' => 'Main Department Ref',
			'admission_chance' => 'Admission Chance',
			'scholarship_ref_id' => 'Scholarship Ref',
			'scholarship_name' => 'Scholarship Name',
			'scholarship_description' => 'Scholarship Description',
			'scholarship_amount' => 'Scholarship Amount',
			'scholarship_chance' => 'Scholarship Chance',
			'offer_message' => 'Offer Message',
			'eoi_status' => 'Eoi Status',
			'marketing_message' => 'Marketing Message',
			'fee_waiver_desc' => 'Fee Waiver Desc',
			'fee_waiver_url' => 'Fee Waiver Url',
			'fee_waiver_code' => 'Fee Waiver Code',
			'fee_waiver_amount' => 'Fee Waiver Amount',
			'ucounsellor_name' => 'Ucounsellor Name',
			'ucounsellor_email' => 'Ucounsellor Email',
			'ucounsellor_phone' => 'Ucounsellor Phone',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'responded_on' => 'Responded On',
			'is_superstar' => 'Is Superstar',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_user_eoi_log_id',$this->di_user_eoi_log_id,true);
		$criteria->compare('di_user_eoi_ref_id',$this->di_user_eoi_ref_id,true);
		$criteria->compare('main_department_ref_id',$this->main_department_ref_id);
		$criteria->compare('admission_chance',$this->admission_chance,true);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('scholarship_name',$this->scholarship_name,true);
		$criteria->compare('scholarship_description',$this->scholarship_description,true);
		$criteria->compare('scholarship_amount',$this->scholarship_amount,true);
		$criteria->compare('scholarship_chance',$this->scholarship_chance,true);
		$criteria->compare('offer_message',$this->offer_message,true);
		$criteria->compare('eoi_status',$this->eoi_status,true);
		$criteria->compare('marketing_message',$this->marketing_message,true);
		$criteria->compare('fee_waiver_desc',$this->fee_waiver_desc,true);
		$criteria->compare('fee_waiver_url',$this->fee_waiver_url,true);
		$criteria->compare('fee_waiver_code',$this->fee_waiver_code,true);
		$criteria->compare('fee_waiver_amount',$this->fee_waiver_amount,true);
		$criteria->compare('ucounsellor_name',$this->ucounsellor_name,true);
		$criteria->compare('ucounsellor_email',$this->ucounsellor_email,true);
		$criteria->compare('ucounsellor_phone',$this->ucounsellor_phone,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('responded_on',$this->responded_on,true);
		$criteria->compare('is_superstar',$this->is_superstar,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}