<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCriteriaPreferredSchool is autogenerate by UniModel generator
 *
 * This is the model class for table "criteria_preferred_school".
 *
 * The followings are the available columns in table 'criteria_preferred_school':
 * @property integer $criteria_preferred_school_id
 * @property integer $si_ref_id
 * @property string $type
 * @property string $type_id
 * @property integer $invitation_number
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TblSiDi $siRef
 */
class BaseCriteriaPreferredSchool extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CriteriaPreferredSchool the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'criteria_preferred_school';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('si_ref_id, type_id, added_by, added_on', 'required'),
			array('si_ref_id, invitation_number', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>9),
			array('type_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('criteria_preferred_school_id, si_ref_id, type, type_id, invitation_number, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'criteria_preferred_school_id' => 'Criteria Preferred School',
			'si_ref_id' => 'Si Ref',
			'type' => 'Type',
			'type_id' => 'Type',
			'invitation_number' => 'Invitation Number',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('criteria_preferred_school_id',$this->criteria_preferred_school_id);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('type_id',$this->type_id,true);
		$criteria->compare('invitation_number',$this->invitation_number);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}