<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseCriteriaEducation is autogenerate by UniModel generator
 *
 * This is the model class for table "criteria_education".
 *
 * The followings are the available columns in table 'criteria_education':
 * @property integer $criteria_education_id
 * @property integer $board_ref_id
 * @property integer $passout_year
 * @property string $type
 * @property string $type_id
 * @property integer $invitation_number
 * @property integer $is_all
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LookupBoard $boardRef
 */
class BaseCriteriaEducation extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CriteriaEducation the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'criteria_education';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('passout_year, type_id, added_by, added_on', 'required'),
			array('board_ref_id, passout_year, invitation_number, is_all', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>9),
			array('type_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('criteria_education_id, board_ref_id, passout_year, type, type_id, invitation_number, is_all, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'criteria_education_id' => 'Criteria Education',
			'board_ref_id' => 'Board Ref',
			'passout_year' => 'Passout Year',
			'type' => 'Type',
			'type_id' => 'Type',
			'invitation_number' => 'Invitation Number',
			'is_all' => 'Is All',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('criteria_education_id',$this->criteria_education_id);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('passout_year',$this->passout_year);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('type_id',$this->type_id,true);
		$criteria->compare('invitation_number',$this->invitation_number);
		$criteria->compare('is_all',$this->is_all);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}