<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseArticleComments is autogenerate by UniModel generator
 *
 * This is the model class for table "article_comments".
 *
 * The followings are the available columns in table 'article_comments':
 * @property string $article_comment_id
 * @property integer $article_ref_id
 * @property string $user_ref_id
 * @property string $comment
 * @property string $name
 * @property string $email
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property Article $articleRef
 * @property TblUserMaster $userRef
 */
class BaseArticleComments extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArticleComments the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'article_comments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('comment', 'required'),
			array('article_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, added_by', 'length', 'max'=>10),
			array('name', 'length', 'max'=>50),
			array('email', 'length', 'max'=>60),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('article_comment_id, article_ref_id, user_ref_id, comment, name, email, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'articleRef' => array(self::BELONGS_TO, 'Article', 'article_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'article_comment_id' => 'Article Comment',
			'article_ref_id' => 'Article Ref',
			'user_ref_id' => 'User Ref',
			'comment' => 'Comment',
			'name' => 'Name',
			'email' => 'Email',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('article_comment_id',$this->article_comment_id,true);
		$criteria->compare('article_ref_id',$this->article_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('comment',$this->comment,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}