<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseActivityLevelValues is autogenerate by UniModel generator
 *
 * This is the model class for table "activity_level_values".
 *
 * The followings are the available columns in table 'activity_level_values':
 * @property string $actvity_level_value_id
 * @property string $activity_score_ref_id
 * @property integer $min_val
 * @property integer $max_val
 * @property integer $score
 * @property string $level_type
 * @property integer $activity_duration
 *
 * The followings are the available model relations:
 * @property TblActivityScore $activityScoreRef
 */
class BaseActivityLevelValues extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ActivityLevelValues the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'activity_level_values';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('min_val, max_val, score, activity_duration', 'numerical', 'integerOnly'=>true),
			array('activity_score_ref_id', 'length', 'max'=>10),
			array('level_type', 'length', 'max'=>9),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('actvity_level_value_id, activity_score_ref_id, min_val, max_val, score, level_type, activity_duration', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'activityScoreRef' => array(self::BELONGS_TO, 'TblActivityScore', 'activity_score_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'actvity_level_value_id' => 'Actvity Level Value',
			'activity_score_ref_id' => 'Activity Score Ref',
			'min_val' => 'Min Val',
			'max_val' => 'Max Val',
			'score' => 'Score',
			'level_type' => 'Level Type',
			'activity_duration' => 'Activity Duration',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('actvity_level_value_id',$this->actvity_level_value_id,true);
		$criteria->compare('activity_score_ref_id',$this->activity_score_ref_id,true);
		$criteria->compare('min_val',$this->min_val);
		$criteria->compare('max_val',$this->max_val);
		$criteria->compare('score',$this->score);
		$criteria->compare('level_type',$this->level_type,true);
		$criteria->compare('activity_duration',$this->activity_duration);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}