<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseUniCourseTest');

class UniCourseTest extends BaseUniCourseTest {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
            'entranceRef' => array(self::BELONGS_TO, 'LookupEntrance', 'entrance_ref_id'),
            'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
            'university' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
        );
    }

    public static function getCourseTestName($courseId) {
//        SELECT entrance_short_name FROM uni_course_test AS uct
//        INNER JOIN entrance_exam AS ee ON ee.entrance_id = uct.entrance_ref_id
//        WHERE uni_course_ref_id = '135717'
        $criteria = new CDbCriteria();
        $criteria->select = '*';
        $criteria->join = "JOIN entrance_exam e ON e.entrance_id = t.entrance_ref_id";
        $criteria->condition = "uni_course_ref_id=:id";
        $criteria->params = array(':id' => $courseId);
        $criteria->addCondition("e.is_active = 1", "AND");

        $data = self::model()->with('entranceRef')->findAll($criteria);
        
        return $data;
    }

}