<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseTblSiStudents');

class TblSiStudents extends BaseTblSiStudents
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  public static function getSiDetails($userId = false)
  {
    $siDetails = self::model()->find('user_ref_id=:uid', array(':uid' => $userId));
	 
	 if(!empty($siDetails))
	 {
		 return $siDetails;
	 }
	 else
	 {
		 return false;
	 }
  }
  public static function getSuggestionListForStudent($term,$instRefId)  
  {
	  
     $sql = "select tum.user_id, tum.first_name,tum.last_name,tum.present_board_ref_id,tum.present_class,tum.passout_year,tum.passout_month,
	  					lm.username,tsd.amount,tum.class_status
						from
							tbl_si_di tsd
							JOIN tbl_si_students s ON s.inst_ref_id = tsd.inst_id
							JOIN tbl_user_master tum ON s.user_ref_id = tum.user_id	
							JOIN login_master lm ON lm.login_id = tum.login_ref_id					
	  				   where s.inst_ref_id='".$instRefId."' AND tum.first_name LIKE '%".$term."%' limit 0,10";
					   /*s.inst_ref_id='".$instRefId."' AND*/
    
        $cmd = Yii::app()->db->createCommand($sql);
      
        $res = $cmd->queryAll();

        $op = array();
		//TODO: #994 changed status'Complete to Completed' Fields
		if(!empty($res))
		{
		foreach($res as $result)
		{			
		  
		   if(!empty($result['class_status']) && ($result['class_status'] == 'Pursuing'))
		   $classStatus = 'p';
		   else if(!empty($result['class_status']) && ($result['class_status'] == 'Completed'))
		   $classStatus = 'c';
		   
		   $op[] = array(
							'id' => $result['user_id'],
							'value' => $result['first_name']." ".$result['last_name'],     
							'presentBoardRefId' => $result['present_board_ref_id'],  
							'presentClass' => $result['present_class'], 
							'classStatus' => $classStatus,
							'email' => $result['username'],  
							'passout_month' => $result['passout_month'],  
							'passout_year' => $result['passout_year'],   
							'amount' => $result['amount'],                       
				);
		 }
		}        
		
		return $op;
		
     
   }
	 static function getSiStudents($inst_id = NULL){
 
	  $term = Yii::app()->request->getQuery('term');
		$instId = TblSiDi::getInstId();
		$siStudents = self::model()->findAll(array('condition'=>'inst_ref_id = "'.$instId.'" and ( first_name like "%'.$term.'%" or middle_name like "%'.$term.'%" or last_name like "%'.$term.'%" or email_id like "%'.$term.'%")', 'with'=>'userRef', 'limit'=>'10','order'=>'CASE WHEN email_id LIKE "'.$term.'%" THEN 0 ELSE 1 END, CASE WHEN first_name LIKE "'.$term.'%" THEN 0 ELSE 1 END, CASE WHEN middle_name LIKE "'.$term.'%" THEN 0 ELSE 1 END, CASE WHEN last_name LIKE "'.$term.'%" THEN 0 ELSE 1 END, email_id, first_name,middle_name,last_name'));
		$result = array();
		foreach($siStudents as $st){
		$temp = array("value"=>$st->fullname, "id"=>$st->userRef->user_id, "email"=>$st->userRef->email_id);
		$result[] = $temp;
		}
		 return CJSON::encode($result);
		Yii::app()->end();
 
	 
	 }
	 
	 public function getFullname(){
	 $fullname = '';
	 $fullname = $this->userRef->first_name;
	 if($fullname !='') {
	 $fullname .=' ';
	 }
	 $fullname .= $this->userRef->middle_name;
	 if($fullname !='') {
	 $fullname .=' ';
	 }
	 $fullname .= $this->userRef->last_name;
	 return $fullname;
	 }
	 
	  static function getSchoolStudents($term,$instRefId)
	  { 	  
		$sql = "select tum.user_id, tum.first_name,tum.last_name,tum.present_board_ref_id,tum.present_class,tum.passout_year,tum.passout_month,
	  					lm.username,tsd.amount,tum.class_status
						from
							tbl_si_di tsd
							JOIN tbl_si_students s ON s.inst_ref_id = tsd.inst_id
							JOIN tbl_user_master tum ON s.user_ref_id = tum.user_id	
							JOIN login_master lm ON lm.login_id = tum.login_ref_id					
	  				   where s.inst_ref_id='".$instRefId."' AND lm.username LIKE '%".$term."%' limit 0,10";
					   /*s.inst_ref_id='".$instRefId."' AND*/
    
        $cmd = Yii::app()->db->createCommand($sql);
      
        $res = $cmd->queryAll();

        $op = array();
		
		if(!empty($res))
		{
		foreach($res as $result)
		{			
		   //TODO: #994 changed status'Complete to Completed' Fields
		   if(!empty($result['class_status']) && ($result['class_status'] == 'Pursuing'))
		   $classStatus = 'p';
		   else if(!empty($result['class_status']) && ($result['class_status'] == 'Completed'))
		   $classStatus = 'c';
		   
		   $op[] = array(
							'id' => $result['user_id'],
							'value' => $result['username'],     
							                       
				);
		 }
		}        
		
		return $op;
	  }
	  
	  //It will returns the list of students who are assigned to the logged in external adviosr
	Static function getExtadvisorStudents($term,$instRefId)
	{ 	  
		try{
			/*$sql = "select tum.user_id, tum.first_name,tum.last_name,tum.present_board_ref_id,tum.present_class,tum.passout_year,tum.passout_month,
							lm.username,tsd.amount,tum.class_status
							from
								tbl_si_di tsd
								JOIN tbl_si_students s ON s.inst_ref_id = tsd.inst_id
								JOIN tbl_user_master tum ON s.user_ref_id = tum.user_id	
								JOIN login_master lm ON lm.login_id = tum.login_ref_id					
						   where s.inst_ref_id='".$instRefId."' AND lm.username LIKE '%".$term."%' limit 0,10";
						   s.inst_ref_id='".$instRefId."' AND*/			
			$sql="SELECT DISTINCT t.user_id, t.first_name, t.last_name, t.present_board_ref_id,t.present_class,
				t.passout_year,t.passout_month,lm.username,t.class_status
				FROM `tbl_user_master` `t` 
				INNER JOIN prospect AS p ON p.user_ref_id=t.user_id 
				INNER JOIN login_master AS lm ON lm.login_id=t.login_ref_id
				WHERE p.advisor_ref_id='".$instRefId."' AND prospect_status IN ('InProgress','ConfirmedToPay') AND lm.username LIKE '%".$term."%' LIMIT 0,10
				UNION ALL
				SELECT DISTINCT t.user_id, t.first_name, t.last_name, t.present_board_ref_id,t.present_class,
				t.passout_year,t.passout_month,lm.username,t.class_status
				FROM `tbl_user_master` `t` 
				INNER JOIN login_master AS lm ON lm.login_id=t.login_ref_id
				INNER JOIN gem_lead AS gl ON gl.email_id=lm.username
				INNER JOIN gem_lead_prospect AS gp ON gp.gem_lead_ref_id=gl.gem_lead_id
				WHERE gp.advisor_ref_id='".$instRefId."' AND gl.gem_status  IN ('InProgress','ConfirmedToPay') AND lm.username LIKE '%".$term."%' LIMIT 0,10 ";	
		
			$cmd = Yii::app()->db->createCommand($sql);
		  
			$res = $cmd->queryAll();

			$op = array();
			
			if(!empty($res))
			{
				foreach($res as $result)
				{			
				   //TODO: #994 changed status'Complete to Completed' Fields
				   if(!empty($result['class_status']) && ($result['class_status'] == 'Pursuing'))
				   $classStatus = 'p';
				   else if(!empty($result['class_status']) && ($result['class_status'] == 'Completed'))
				   $classStatus = 'c';				   
				   $op[] = array(
						'id' => $result['user_id'],
						'value' => $result['username'],  
					);
				}
			}   			
			return $op;
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	} 
	
	Static function umailEmailValidity($term)
	{ 	  
		try{
			$sql="SELECT DISTINCT t.user_id, t.first_name, t.last_name, t.present_board_ref_id,t.present_class,
				t.passout_year,t.passout_month,lm.username,t.class_status
				FROM `tbl_user_master` `t` 
				INNER JOIN prospect AS p ON p.user_ref_id=t.user_id 
				INNER JOIN login_master AS lm ON lm.login_id=t.login_ref_id
				WHERE p.advisor_ref_id='".Yii::app()->user->sub_id."' AND prospect_status IN ('InProgress','ConfirmedToPay') AND lm.username = '".$term."'
				UNION ALL
				SELECT DISTINCT t.user_id, t.first_name, t.last_name, t.present_board_ref_id,t.present_class,
				t.passout_year,t.passout_month,lm.username,t.class_status
				FROM `tbl_user_master` `t` 
				INNER JOIN login_master AS lm ON lm.login_id=t.login_ref_id
				INNER JOIN gem_lead AS gl ON gl.email_id=lm.username
				INNER JOIN gem_lead_prospect AS gp ON gp.gem_lead_ref_id=gl.gem_lead_id
				WHERE gp.advisor_ref_id='".Yii::app()->user->sub_id."' AND gl.gem_status  IN ('InProgress','ConfirmedToPay') AND lm.username ='".$term."' ";	
		
			$cmd = Yii::app()->db->createCommand($sql);		  
			$res = $cmd->queryAll();
			return $res;				
		}
		catch(Exception $ex)
		{
			echo $ex;
		}
	} 	
	  
	  
          
    public function getStudentSiMilestoneDetail($userId, $boardId, $passoutYear) {
        $data = Yii::app()->db->createCommand()
            ->select('stm.*')
            ->from('tbl_si_students AS t')
            ->join('si_track_milestone AS stm', 't.inst_ref_id = stm.si_ref_id')
            ->where(" t.user_ref_id = ". $userId ." AND stm.board_ref_id = ".$boardId." AND stm.passout_year = ".$passoutYear)
            ->queryRow();
         return $data;
    }
}