<?php

/**
 * This is the model class for table "student_preferred_country".
 *
 * The followings are the available columns in table 'student_preferred_country':
 * @property string $preferred_country_id
 * @property string $user_ref_id
 * @property integer $country_ref_id
 * @property integer $preference_order
 * @property string $added_on
 * @property integer $not_sure
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 */
class StudentPreferredCountry extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StudentPreferredCountry the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'student_preferred_country';
	}

        public function behaviors(){
            return array(
                'StudentActivityFeedBehavior' => 'application.behaviors.StudentActivityFeedBehavior',
            );
        }        
        
        public function StudentActivityFeedLoggableAttributes(){
            return array(
                'country_ref_id' => 'preferred_countries',
            );
        }
        
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('country_ref_id, preference_order, not_sure', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
            array('no_scholarship', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('preferred_country_id, user_ref_id, country_ref_id, preference_order, added_on, not_sure,no_scholarship', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'tblusermaster' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id', 'joinType'=>'INNER JOIN'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'preferred_country_id' => 'Preferred Country',
			'user_ref_id' => 'User Ref',
			'country_ref_id' => 'Country Ref',
			'preference_order' => 'Preference Order',
			'added_on' => 'Added On',
			'not_sure' => 'Not Sure',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('preferred_country_id',$this->preferred_country_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('preference_order',$this->preference_order);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('not_sure',$this->not_sure);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function getStudentsByCountry($siId=2)
	{
		 $sql = "
				SELECT country_ref_id, country_name, count( * ) as count, tc.country_code as country_code
				FROM student_preferred_country spc
				JOIN tbl_si_students si ON si.user_ref_id = spc.user_ref_id
				JOIN tbl_country_master tc ON tc.country_id = spc.country_ref_id
				WHERE inst_ref_id =".$siId."
				GROUP BY spc.country_ref_id";
        $rs = Yii::app()->db->createCommand($sql)->query();
        foreach($rs as $row)
        {
        	$data[$row['country_code']] = $row['count'];
        }
        return $data;
		
	}
	
	/*
	 * Function to get student preferred contry details
	 * return array of country_id, country_name
	 */
	public function getStudentPreferredCountryDetails($user_id=0)
	{
		$modelStudentPreferredCountry = self::model()->with(array("countryRef", array('JOIN TYPE'=>'LEFT OUTER JOIN')))->findAll(array("condition"=>"user_ref_id = ".$user_id, "order"=>"preference_order"));
		return $modelStudentPreferredCountry;
	}
	
	/*
	 * Function to get student preferred country names
	 * returns country_name as csv. 
	 * returns "Not sure", if not_sure flag is true
	 */
	public function getStudentPreferredCountryNames($user_id=0)
	{
		$tempStudentPrefCountryArr = array();
		$studentPreferredCountryDetails = '';
		$prefCountryDetails = self::getStudentPreferredCountryDetails($user_id);
		foreach($prefCountryDetails as $spc){
			if($spc->attributes['not_sure'] == 1){
				$studentPreferredCountryDetails = 'Not sure';
			}else{
				$tempStudentPrefCountryArr[] = $spc->countryRef->attributes['country_name'];
			}
		}
		if(count($tempStudentPrefCountryArr) > 0){
			$studentPreferredCountryDetails = implode(', ', $tempStudentPrefCountryArr);
		}
		return $studentPreferredCountryDetails;
	}
        
    public function deleteCountryPreferenceByUserId($userId) {
        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id = '" . $userId . "'";
        self::model()->deleteAll($criteria);
    }
    
    public function insertCountryPreferenceByUserId($userId, $countryId, $preferenceOrder){
        $obj = new StudentPreferredCountry();
        $obj->{user_ref_id} = $userId;
        $obj->{country_ref_id} = $countryId;
        $obj->{preference_order} = $preferenceOrder;
        $obj->save(false);
    }
    
    /*
	 * Function to get student preferred country details
	 * return array model
	 */
	public function getStudentPreferredCountries($user_id=0)
	{
		$modelStudentPreferredCountry = self::model()->with(array("countryRef", array('JOIN TYPE'=>'LEFT OUTER JOIN')))->findAll(array("condition"=>"user_ref_id = ".$user_id, "order"=>"preference_order"));
		return $modelStudentPreferredCountry;
	}
        
	public function getStudentPreferredCountriesPdf($user_id=0)
	{
            $criteria = new CDbCriteria();
            $criteria->select = 'country_ref_id';
            $criteria->with = 'countryRef';
            $criteria->addCondition("user_ref_id = '".$user_id."'", "AND");
            //$criteria->addCondition("country_ref_id != '' ", "AND");
            $criteria->order = 'preference_order';
            $data = self::model()->findAll($criteria);
            return $data;
	}  
        
    public function getStdCountryPrefByPrefOrder($userId, $prefOrder) {
        $modelStudentPreferredCountry = self::model()->find(array("condition"=>"user_ref_id = ".$userId." AND preference_order = ". $prefOrder));
        return $modelStudentPreferredCountry;

    }

    public function getStudentPreferredCountryIds($user_id=0)
    {
        $tempStudentPrefCountryArr = array();
        $studentPreferredCountryDetails = '';
        $prefCountryDetails = self::getStudentPreferredCountryDetails($user_id);
        foreach($prefCountryDetails as $spc){
            if($spc->attributes['not_sure'] == 1){
                $studentPreferredCountryDetails = 'Not sure';
            }else{
                $tempStudentPrefCountryArr[] = $spc->countryRef->attributes['country_id'];
            }
        }
        if(count($tempStudentPrefCountryArr) > 0){
            $studentPreferredCountryDetails = implode(', ', $tempStudentPrefCountryArr);
        }
        return $studentPreferredCountryDetails;
    }


    public function getStudentPreferredCountryNamesOnly($user_id=0)
    {
        $tempStudentPrefCountryArr = array();
        $studentPreferredCountryDetails = '';
        $prefCountryDetails = self::getStudentPreferredCountryDetails($user_id);
        foreach($prefCountryDetails as $spc){
            if($spc->attributes['not_sure'] == 1){
                $studentPreferredCountryDetails = 'Not sure';
            }else{
                $tempStudentPrefCountryArr[$spc->countryRef->attributes['country_id']] = $spc->countryRef->attributes['country_name'];
            }
        }

        return $tempStudentPrefCountryArr;
    }
}