<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseScholarshipDepartment');

class ScholarshipDepartment extends BaseScholarshipDepartment
{
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }
  
  protected function beforeSave(){
      if(parent::beforeSave()){
        if($this->isNewRecord){
           $this->added_on = date('Y-m-d H:i:s');
        }else{
          $this->modified_on = date('Y-m-d H:i:s');
        }        
        return true;
        
      }
    return false;
  }
  
  public static function hasDepartment($scholarshipId, $courseId, $deptId = 0, $subDeptId = 0){
    $criteria = new CDbCriteria;
    $criteria->compare('course_level_ref_id', $courseId);
    $criteria->compare('scholarship_ref_id', $scholarshipId);
    if($deptId) $criteria->compare('main_dept_ref_id', $deptId);
    if($subDeptId) $criteria->compare('sub_dept_ref_id', $subDeptId);
    $count = self::model()->count($criteria);
    return $count > 0 ? true : false;
  }
  
  public static function hasDepartmentCount($scholarshipId, $courseId, $deptId = 0, $subDeptId = 0){
    $criteria = new CDbCriteria;
    $criteria->compare('course_level_ref_id', $courseId);
    $criteria->compare('scholarship_ref_id', $scholarshipId);
    if($deptId) $criteria->compare('main_dept_ref_id', $deptId);
    if($subDeptId) $criteria->compare('sub_dept_ref_id', $subDeptId);
    $count = self::model()->count($criteria);
    return $count;
  }
  
  public function search($scholarshipId, $courseId, $deptId = 0, $subDeptId = 0){
    $criteria = new CDbCriteria;
    $criteria->compare('course_level_ref_id', $courseId);
    $criteria->compare('scholarship_ref_id', $scholarshipId);
    if($deptId) $criteria->compare('main_dept_ref_id', $deptId);
    if($subDeptId) $criteria->compare('sub_dept_ref_id', $subDeptId);    
    $res = self::model()->find($criteria);           
    return $res['scholarship_department_id'];
  }
    
  public static function getAllSubDepartment($scholarshipId, $deptId ){
    $criteria = new CDbCriteria;
    //$criteria->compare('course_level_ref_id', $courseId);
    $criteria->compare('scholarship_ref_id', $scholarshipId);
    if($deptId) $criteria->compare('main_dept_ref_id', $deptId);
    $criteria->group = 'sub_dept_ref_id';
    $res = self::model()->findAll($criteria);  
    return $res;
  } 
  
  public static function getAllSubDeptDetail($scholarshipId){

    $criteria = new CDbCriteria;
    $criteria->select = 'sum(course_level_ref_id) as course_level_ref_id,main_dept_ref_id,sub_dept_ref_id';
    $criteria->compare('scholarship_ref_id', $scholarshipId);
    $criteria->group = 'sub_dept_ref_id';
    $criteria->order = 'mainDeptRef.department_name';
    $res = self::model()->with(array('subDeptRef'=>array('select'=>'department_name'),'mainDeptRef'=>array('select'=>'department_name')))->findAll($criteria); 
    foreach($res as $key=>$value){
       // print_r($value->mainDeptRef->department_name);print_r($value->subDeptRef->department_name);print_r($value->course_level_ref_id);die;
        $data[$value->main_dept_ref_id]['name'] = $value->mainDeptRef->department_name;
        $data[$value->main_dept_ref_id]['subdepartment'][$value->sub_dept_ref_id]['name'] = $value->subDeptRef->department_name;
        $data[$value->main_dept_ref_id]['subdepartment'][$value->sub_dept_ref_id]['course'] = $value->course_level_ref_id;
    }
    return $data;
  }




  public static function getcoursebySubDepartment($scholarshipId, $subDeptId ){
    $criteria = new CDbCriteria;   
    $criteria->compare('scholarship_ref_id', $scholarshipId);
    $criteria->compare('sub_dept_ref_id', $subDeptId);
    //$criteria->group = 'sub_dept_ref_id';
    $res = self::model()->findAll($criteria);  
    return $res;
  }  
}