<?php

/**
 * This is the model class for table "offline_delete_record_log".
 *
 * The followings are the available columns in table 'offline_delete_record_log':
 * @property string $offline_dr_id
 * @property string $user_ref_id
 * @property string $shortlist_university
 * @property string $shortlist_vendor
 * @property string $test_deadline
 * @property string $interested_products
 * @property string $entrance_exam
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class OfflineDeleteRecordLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return OfflineDeleteRecordLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'offline_delete_record_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('shortlist_university, shortlist_vendor, test_deadline, interested_products, entrance_exam, outplacement_university, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('offline_dr_id, user_ref_id, shortlist_university, shortlist_vendor, test_deadline, interested_products, entrance_exam, outplacement_university, notes, counselling_request, subject_help, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'offline_dr_id' => 'Offline Dr',
			'user_ref_id' => 'User Ref',
			'shortlist_university' => 'Shortlist University',
			'shortlist_vendor' => 'Shortlist Vendor',
			'test_deadline' => 'Test Deadline',
			'interested_products' => 'Interested Products',
			'entrance_exam' => 'Entrance Exam',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('offline_dr_id',$this->offline_dr_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('shortlist_university',$this->shortlist_university,true);
		$criteria->compare('shortlist_vendor',$this->shortlist_vendor,true);
		$criteria->compare('test_deadline',$this->test_deadline,true);
		$criteria->compare('interested_products',$this->interested_products,true);
		$criteria->compare('entrance_exam',$this->entrance_exam,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

    public static function deleteRecordUpdateTime($userId, $tbName) {

        $model = self::model()->findByAttributes(array('user_ref_id'=>$userId));
        if(!$model){
            $model = new OfflineDeleteRecordLog();
            $model->user_ref_id = $userId;
        }
        if($tbName == 'StudentShortlistUniversity'){
            $model->shortlist_university = date('Y-m-d H:i:s');
        }
        else if($tbName == 'StudentShortlistVendor'){
            $model->shortlist_vendor = date('Y-m-d H:i:s');
        }
        else if($tbName == 'MilestoneTestDeadlinesChosen'){
            $model->test_deadline = date('Y-m-d H:i:s');
        }
        else if($tbName == 'StudentInterestedProducts'){
            $model->interested_products = date('Y-m-d H:i:s');
        }
        else if($tbName == 'UserEntranceExam'){
            $model->entrance_exam = date('Y-m-d H:i:s');
        }
        else if($tbName == 'StudentOutplacementUniversity'){
            $model->outplacement_university = date('Y-m-d H:i:s');
        }
        else if($tbName == 'UserDataPoint'){
            $model->notes = date('Y-m-d H:i:s');
        }
        else if($tbName == 'StudentCounsellingRequest'){
            $model->counselling_request = date('Y-m-d H:i:s');
        }
        else if($tbName == 'StudentSubjectHelp'){
            $model->subject_help = date('Y-m-d H:i:s');
        }
        $model->added_on = date('Y-m-d H:i:s');
        $model->save(false);
    }
}