<?php

/*
 * @author Asif Ali M
 * @package application.models
 * 
 * The class defination is autogenerate by UniModel generator
 */

Yii::import('application.models.base.BaseLookupRankSource');

class LookupRankSource extends BaseLookupRankSource {

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function getSourceList($country_ref_id) {
        
        $criteria = new CDbCriteria;
        $criteria->select = 'rank_source_id,source_name';
        if ($country_ref_id == 100) {
            $criteria->condition = 'country_ref_id=:countryId';
        } else {
            $criteria->condition = 'country_ref_id=:countryId OR source_type="Global"';
        }
        $criteria->params = array(':countryId' => $country_ref_id);
        $criteria->order = "source_name";
        $data = self::model()->findAll($criteria);
        if ($data) {
            foreach ($data as $value) {
                $sourceList[$value->attributes['rank_source_id']] = $value->attributes['source_name'];
            }
        }
        return $sourceList;
    }

}