<?php

/**
 * This is the model class for table "lookup_board".
 *
 * The followings are the available columns in table 'lookup_board':
 * @property integer $board_id
 * @property string $board_name
 * @property string $board_desc
 * @property string $board_category
 *
 * The followings are the available model relations:
 * @property LookupBoardEquivalent[] $lookupBoardEquivalents
 * @property TblSiBoard[] $tblSiBoards
 * @property TblUserMaster[] $tblUserMasters
 */
class LookupBoard extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LookupBoard the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'lookup_board';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('board_name', 'length', 'max'=>10),
			array('board_desc', 'length', 'max'=>75),
            array('board_category', 'length', 'max'=>13),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('board_id, board_name, board_desc, board_category', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupBoardEquivalents' => array(self::HAS_MANY, 'LookupBoardEquivalent', 'board_ref_id'),
			'tblSiBoards' => array(self::HAS_MANY, 'TblSiBoard', 'board_ref_id'),
			'tblUserMasters' => array(self::HAS_MANY, 'TblUserMaster', 'present_board_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'board_id' => 'Board',
			'board_name' => 'Board Name',
			'board_desc' => 'Board Desc',
            'board_category' => 'Board Category',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('board_id',$this->board_id);
		$criteria->compare('board_name',$this->board_name,true);
		$criteria->compare('board_desc',$this->board_desc,true);
        $criteria->compare('board_category',$this->board_category,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
   public static function GetSchoolBoard($boardName = false,$instRefId=false)
   {	
	 $result = self::model()->find('board_desc=:boardName', array(':boardName' => $boardName));
	
	 if(!empty($result))
	 {
		$siBoardResult = TblSiBoard::model()->find('board_ref_id=:boardId AND si_ref_id=:siRefId', array(':boardId' => $result->attributes['board_id'],':siRefId' => $instRefId)); 
	 }
	 
	 return $siBoardResult;
	
	
  }
  
  
   public static function GetSchoolIds($boardName = false)
   {	
	 $result = self::model()->find('board_desc=:boardName', array(':boardName' => $boardName));
	
	 return $result;
  }
  
  public static function GetSchoolName($boardId = false)
   {	
	 $result = self::model()->find('board_id=:boardId', array(':boardId' => $boardId));
	
	 return $result;
  }
  public static function GetBoards()
  {
      $cdbCriteria = new CDbCriteria();
      $cdbCriteria->select = array("board_id" , "board_name");
      $cdbCriteria->order = "board_name";
      $allBoards = self::model()->findAll($cdbCriteria);
      $boards = array();
      foreach ($allBoards as $allboard) {
          $boards[$allboard->attributes['board_id']] = $allboard->attributes['board_name'];
      }
      return $boards;

  }

  public static function getBoardDescById($Id){
      $sql='  SELECT board_desc FROM `lookup_board` lb
              JOIN `lookup_board_equivalent` lbe
              ON board_id = board_ref_id
              WHERE board_id = '.$Id.' GROUP BY board_desc';
      $command =Yii::app()->db->createCommand($sql);
      $results = $command->queryAll();
      $boardDes = array();
      foreach($results as $result){
          $boardDes['board_desc']  = $result['board_desc'];
      }
     // print_r($boardDes);exit;
      return $boardDes;
  }
}