<?php

Yii::import('application.models.base.BaseLoginMaster');

class LoginMaster extends BaseLoginMaster {

    /**
     * @return array validation rules for model attributes.
     */
    public $skipPassword = false;
    public $fromforgotPassword;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return
                array(
                    array('username', 'required', 'message' => '<div class="holder"><p>Enter your email address</p></div>'),
                    array('pass_word', 'required', 'message' => '<div class="holder"><p>Enter your password</p></div>', 'except'=>'forgotpassword'),
                    array('username', 'email', 'message' => '<div class="holder"><p>Enter a valid address</p></div>'),
                    array('username', 'length', 'max' => 100),
                    array('username', 'unique', 'className' => 'LoginMaster', 'message' => '<div class="holder"><p>Email Id already exists. Please enter another Email Id</p></div>', 'on' => 'register'),

                    array('username',
                        'exist',
                        'className' => 'LoginMaster',
                        'message' => '<div class="holder"><p>Email Address does not exists.</p></div>',
                        'on' => 'forgotpassword'
                    ),
                    array('pass_word', 'length', 'max' => 255, 'message' => '<div class="holder"><p>Please enter password</p></div>', 'except'=>'forgotpassword'),

                    array('login_id, username, pass_word, user_type_ref_id, is_active, is_facebook, last_login, change_password_key, is_email_confirmed, is_class_status_confirmed, is_preference_confirmed, is_student_profile_confirmed, student_profile_mail_sent, student_profile_mail_sent_on, added_on, added_by, modified_on, modified_by, profile_validate_status, validated_by, is_request_message, note_added_by, note_added_on, umail_request_to, request_validated_on, new_umail, is_umail_update, is_valid, requested_by, validated_on,last_login, student_profile_mail_sent_on, modified_on, is_request_message, note_added_on, request_validated_on, validated_on ,is_systempwd', 'safe'),
                    // The following rule is used by search().
                    // Please remove those attributes that should not be searched.
                    array('login_id, username, pass_word, firstname,lastname,user_type_ref_id, is_active, is_facebook, last_login, added_on, added_by, modified_on, modified_by,batch,skipPassword, is_email_confirmed, is_class_status_confirmed, is_preference_confirmed,is_systempwd, is_sync', 'safe', 'on' => 'search'),
                    array('pass_word', 'length', 'min' => 6, 'on' => 'DiModuleChangePassword'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return CMap::mergeArray(parent::attributeLabels(), array(
                    'username' => 'Email Address',
                    'pass_word' => 'Your Password',
                    'firstname' => 'First Name',
                    'lastname' => 'Last Name',
                    'inst_ref_id' => 'Inst Ref ID',
                    'batch' => 'Batch',
        ));
    }

    public function loginWithRedirect($sUserName = '', $sPassword = '', $sRedirectUrl = '') {

        $this->username = $sUserName;
        $this->pass_word = $sPassword;

        if (!$this->login()) {
            Yii::app()->user->logout();
            Yii::app()->session->open();
            setFlashMessage('error_notify', 'logincontroller.unknown_error');
            Yii::app()->Controller->redirect(array('/login'));
        }


        if (Yii::app()->user->getState('slugname') && $sRedirectUrl) {

            $subDomain = Yii::app()->user->slugname;
            if (!preg_match('/' . $subDomain . '/', $sRedirectUrl)) {
                if (preg_match('/www\./', $sRedirectUrl))
                    $sRedirectUrl = str_replace('www.', $subDomain . '.', $sRedirectUrl);
                else
                    $sRedirectUrl = str_replace('//', '//' . $subDomain . '.', $sRedirectUrl);
            }
        }

        Yii::app()->request->redirect(
                $sRedirectUrl ? $sRedirectUrl : Yii::app()->user->redirectUrl
        );
    }

    public function loginRedirect($sUserName = '', $sPassword = '', $sRedirectUrl = '') {

        $this->username = $sUserName;
        $this->pass_word = $sPassword;

        if (!$this->login())
            return false;

        if (Yii::app()->user->getState('slugname') && $sRedirectUrl) {

            $subDomain = Yii::app()->user->slugname;
            if (preg_match('/www\./', $sRedirectUrl))
                $sRedirectUrl = str_replace('www.', $subDomain . '.', $sRedirectUrl);
            else
                $sRedirectUrl = str_replace('//', '//' . $subDomain . '.', $sRedirectUrl);
        }

        Yii::app()->request->redirect(
                $sRedirectUrl ? $sRedirectUrl : Yii::app()->user->returnUrl
        );
    }

    /**
     * Logs in the user using the given username and password in the model.
     * @return boolean whether login is successful
     */
    public function login() {
        //print_r($this->skipPassword);		exit;

        $_identity = new UserIdentity($this->username, $this->pass_word);

        if (!$_identity->authenticate($this->skipPassword)) {
            switch ($_identity->errorCode) {

                case UserIdentity::ERROR_USERNAME_INVALID:
                    $this->addError('username', '<div class="holder"><p>Email doesn\'t exist</p></div> ');
                    break;

                case UserIdentity::ERROR_PASSWORD_INVALID:
                    $this->addError('pass_word', '<div class="holder"><p>Password is incorrect</p></div>');
                    break;

                case UserIdentity::ERROR_ACCOUNT_INACTIVE:
                    $this->addError('login_id', "<div class='holder'><p>Your account is no longer active.  Contact <a href='" . Yii::app()->params['cbasepath'] . "/contact-us.php'>Univariety</a> if you feel this is an error</p></div>");
                    break;

                case UserIdentity::ERROR_UNKNOWN_IDENTITY:
                    $this->addError('pass_word', '<div class="holder"><p>Access denied, please contact support</p></div>');
                    break;
            }

            return false;
        }

        Yii::app()->user->login($_identity);
        LoginMaster::model()->updateByPk($_identity->id, array(
            'last_login' => new CDbExpression('NOW()')
        ));

        return true;
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('login_id', $this->login_id, true);
        $criteria->compare('username', $this->username, true);
        $criteria->compare('pass_word', $this->pass_word, true);
        $criteria->compare('user_type_ref_id', $this->user_type_ref_id);
        $criteria->compare('is_active', $this->is_active);
        $criteria->compare('batch', $this->batch);
        $criteria->compare('is_facebook', $this->is_facebook);
        $criteria->compare('last_login', $this->last_login, true);
        $criteria->compare('added_on', $this->added_on, true);
        $criteria->compare('added_by', $this->added_by);
        $criteria->compare('modified_on', $this->modified_on, true);
        $criteria->compare('modified_by', $this->modified_by);
        $criteria->addCondition('is_active=1');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function behaviors() {
        return array(
            'ERememberFiltersBehavior' => array(
                'class' => 'application.components.ERememberFiltersBehavior',
                'defaults' => array(),
                'defaultStickOnClear' => false
            ),
        );
    }

    public function getUserMaster() {
        return $this->tblUserMasters[0];
    }

    /*
     * This method is used to check whether an email is already existing in our DB or not.
     * The second param will be used when updating an existing user's email is. If uid present then we ignore that record
     * 
     */

    public function isDuplicateEmail($email, $uid = null) {
        if ($uid) {
            $rs = self::model()->find('username = :1 AND login_id != :2', array(':1' => $email, ':2' => $uid));
        } else {
            $rs = self::model()->find('username = :1', array(':1' => $email));
        }

        if ($rs->login_id) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * Function to get login master details for a given login id
     */

    public function getLoginMasterDetails($login_id = 0) {
        $modelLoginMaster = self::model()->find(array("condition" => "login_id = " . $login_id));
        return $modelLoginMaster;
    }

    public static function createRandomPassword() {
        $chars = "abcdefghijkmnopqrstuvwxyz023456789";
        srand((double) microtime() * 1000000);
        $i = 0;
        $pass = '';
        while ($i <= 7) {
            $num = rand() % 33;
            $tmp = substr($chars, $num, 1);
            $pass = $pass . $tmp;
            $i++;
        }
        return $pass;
    }

    /*
     * Function to validate email and also check csv file for proper values
     */

    public function studentValidate($attribute, $params) {
        //$pattern = "/^([_a-zA-Z0-9-]+)(\.[_a-zA-Z0-9-]+)*@([a-zA-Z0-9-]+)(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,4})$/";
        $isValid = $this->chkValidEmail($attribute['userName']);

        $studentList = self::model()->count('username=:emailId', array(':emailId' => $attribute['userName']));

        if ($studentList > 0) {
            $this->addError('username', 'Email id with "' . $attribute['userName'] . '" already exists');
            return false;
        } else if ($isValid > 0) {
            $this->addError('username', 'Please enter valid email id "' . $attribute['userName'] . '" ');
            return false;
        } else {
            return true;
        }
    }

    public static function chkValidEmailCompose($email){
        if (strlen($email) > 0) {
            $validator = new CEmailValidator;
            if(!$validator->validateValue($email)) return TRUE;
            $check_model = TblSiStudents::model()->umailEmailValidity($email);
            if ($check_model) {
                return false;
            } else
                return true;
        }
        return false;
    }

    public static function chkValidEmail($email) {
        $validator = new CEmailValidator;
        return !$validator->validateValue($email);
    }

    public static function insertStudentDetails($param) {
        $loginMaster = new LoginMaster();
        $loginMaster->username = $param['userName'];
        $fldPassword = $loginMaster->createRandomPassword();
        $loginMaster->pass_word = md5($fldPassword);
        $loginMaster->change_password_key = md5($fldPassword);
        $loginMaster->user_type_ref_id = '1';
        $loginMaster->is_active = '1';
        $loginMaster->added_on = date('Y-m-d H:i:s');
        $test = $loginMaster->save();
        var_dump($test);

        //if($test == false)
        //var_dump($loginMaster->geterrors());
        //exit;
        $loginRefId = $loginMaster->login_id;

        if ($loginRefId > 0) {
            $ObjUser = new TblUserMaster;
            if ($param['gender'] == 'Female')
                $gender = 'F';
            else if ($param['gender'] == 'Male')
                $gender = 'M';

            $schoolRefId = TblSiDi::GetSchoolLookupId($param['instId']);

            /** Get Board equivalent ** */
            $lookupBoard = LookupBoard::GetSchoolBoard($param['board']);

            $ObjUser->login_ref_id = $loginRefId;
            $ObjUser->first_name = $param['firstName'];
            $ObjUser->last_name = $param['lastName'];
            $ObjUser->membership_ref_id = 2;
            //TODO: #994 removed 'user_type' field		
            //$ObjUser->user_type  			  = "";
            $ObjUser->email_id = $param['userName'];
            $ObjUser->is_newsletter_subscribe = 'N';
            $ObjUser->country_ref_id = '100';
            $hask_key_password = md5($fldPassword);
            $ObjUser->school_ref_id = $schoolRefId->attributes['school_ref_id'];
            $ObjUser->present_class = $param['studyLevel'];
            $ObjUser->class_status = $param['status'];

            $ObjUser->present_board_ref_id = $lookupBoard->attributes['board_id'];
            $ObjUser->passout_month = date("m", mktime(0, 0, 0, $param['completionMonth']));
            $ObjUser->passout_year = $param['completionYear'];
            $ObjUser->profile_status_ref_id = 3;
            //$ObjUser->redirect_url_ref_id     = 1;
            $redirect_url_id = LookupUrl::getRedirectUrlId($ObjUser->membership_ref_id);
            $ObjUser->redirect_url_ref_id = $redirect_url_id;
            $ObjUser->new_password = 'Y';


            $ObjUser->gender = $gender;

            $test = $ObjUser->save();
            $userId = $ObjUser->user_id;

            /** Get Board equivalent ** */
            $lookupBoardEquivalent = LookupBoardEquivalent::GetSchoolBoardEquivalentId($param['studyLevel'], $lookupBoard->attributes['board_id']);

            //$board_ref_id = $db->getSingleColumn("lookup_board_equivalent", "board_equivalent_id", "where class_level = '".$ObjUser->fldpresentclass."' AND board_ref_id ='".$ObjUser->fldBoard."' ");			
            $boardRefId = $lookupBoardEquivalent->attributes['board_equivalent_id'];

            /** inserting into educatioon table* */
            $studentModel = new StudentEducation;

            $studentModel->user_ref_id = $userId;
            $studentModel->class_level = $param['studyLevel'];
            $studentModel->status = $param['status'];
            $studentModel->school_name = $schoolRefId->attributes['inst_name'];
            $studentModel->board_ref_id = $boardRefId;
            $studentModel->year = $param['completionYear'];
            $studentModel->status = $param['status'];
            $studentModel->added_on = date('Y-m-d H:i:s');
            $studentModel->save();

            /** updating critical fields* */
            TblUserProfCriticalCompletion::createCriticalField($userId);
            $loginMaster->profileCriticalCompletion('edu_study_level', '1', $userId);
            $loginMaster->profileCriticalCompletion('name', 1, $userId);
            TblUserMaster::calcCriticalPercent($userId);


            $siStudentModel = new TblSiStudents();

            $siStudentModel->user_ref_id = $userId;
            $siStudentModel->inst_ref_id = $param['instId'];
            $siStudentModel->is_invitation_accepted = 'N';
            $siStudentModel->added_on = date('Y-m-d H:i:s');
            $siStudentModel->save();
            // send mail
            $hask_key_password = md5($fldPassword);

            $secureURL = Yii::app()->request->baseUrl;

            $USER_DIR = 'user';
            $fldUserName = $param['firstName'];
            $fldUserEmail = $param['userName'];
            //$fldPassword	= $passWord;
            $fldUserId = base64_encode($userId);
            $year = date("Y");
            $siteName = 'Univariety';
            // Mail code starts here

            ob_start();
            include_once( dirname(__FILE__) . "/../../../mail_template/confirmation2.tpl");
            $msg = ob_get_contents();
            //echo $msg;
            ob_end_clean();
            //exit;


            $params = array();
            $params['EmailMessage']['subject'] = "Welcome to Univariety!";
            $params['EmailMessage']['body'] = $msg;
            $params['EmailMessage']['type'] = 'Signup';
            $params['EmailMessage']['siteUrl'] = '';
            $params['EmailMessage']['cc'] = '';
            $params['EmailMessage']['toName'] = $param['firstName'];
            $params['EmailMessage']['toEmail'] = $param['userName'];
            $params['EmailMessage']['apiKey'] = Yii::app()->params['emailCron']['curlKey'];

            $_POST = $params;
            Yii::app()->user->setState('$_POST', $url);

            $status = Yii::app()->runController("sms/email/addMessage");
        }
    }

    public function profileCriticalCompletion($cname, $flag, $user_ref_id) {
        $ucp = TblUserProfCriticalCompletion::model()->findByAttributes(array('user_ref_id' => $user_ref_id));


        if (!isset($ucp)) {
            throw new CHttpException(400, 'Illegal request. Make sure you access the site properly');
            //$ucp = new TblUserProfCriticalCompletion;
        }
        $arr = $ucp->attributes;
        $arr[$cname] = $flag;

        $ucp->attributes = $arr;

        if ($ucp->validate() && $ucp->save()) {
            
        } else {
            throw new CHttpException(400, 'Illegal request. Make sure you access the site properly');
        }
    }

    public function getUserDetails($email = false) {

        $sql = "select TUM.user_id,TUM.first_name,LM.login_id,LM.is_email_confirmed
		                      from login_master LM 
							       left join tbl_user_master TUM  ON LM.login_id = TUM.login_ref_id
							  where LM.username = '" . $email . "'";

        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        if (!empty($res[0]))
            return $res[0];
        else
            return false;
    }

    /*
     * Function to validate email 
     */

    public function messageValidate($param) {

        //$pattern = "/^([_a-zA-Z0-9-]+)(\.[_a-zA-Z0-9-]+)*@([a-zA-Z0-9-]+)(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,4})$/";
        $errorMsg = "";

        if (strlen($param['emails']) == 0) {
            $errorMsg .= 'Please enter an email address<br>';
        }
        if (strlen($param['emails']) > 0) {
            $isValid = $this->chkValidEmail($param['emails']);

            if (isset($_SESSION['extadv']) && $_SESSION['extadv'] == 1) {
                //cho "hello";
                $isValid = $this->chkValidEmailCompose($param['emails']);
            }
            if ($isValid > 0) {
                $errorMsg .= 'Please enter a valid email address <br>';
            }
        }

        if (strlen($param['subject']) == 0) {
            $errorMsg .= 'Please enter a subject<br>';
        }
        if (strlen($param['message']) == 0) {
            $errorMsg .= 'Please enter a message to send<br>';
        }
        if (strlen($param['cc']) > 0) {
            $errorMsg .= $this->chkEmailLists($param['cc'], "email");
        }
        if (strlen($param['parent']) > 0) {
            $errorMsg .= $this->chkEmailLists($param['parent'], "email");
        }
        if (!empty($param['replyCheck']) && ($param['replyCheck'] == 1)) {
            $type = 'Replied';
            $res = UmailHeader::getUMailDetails($param['headerId'], $type);

            if (!empty($res))
                $errorMsg .= 'Already message replied by counselor';
        }

        return $errorMsg;
    }

    function chkEmailLists($val, $valText) {

        $status = "";
        $strEmailIds = "";
        $strEmailIds = $val;
        $arrEmails = explode(",", $strEmailIds);

        if (sizeof($arrEmails) > 1) {
            for ($e = 0; $e < sizeof($arrEmails); $e++) {
                //if(!eregi("^[a-z0-9]+([_\\.-][a-z0-9]+)*"."@([a-z0-9]+([\.-][a-z0-9]+))*$",trim($arrEmails[$e])))
                if (!preg_match("/^[a-z0-9A-Z]+([_\\.-][a-z0-9A-Z]+)*" . "@([a-z0-9A-Z]+([\.-][a-z0-9A-Z]+))*$/", trim($arrEmails[$e]))) {
                    $emailerrMsg = "* Please enter a valid email address<br>";
                }//if
            }//FOR				
        }//EMAILS
        else {

            if (strlen($strEmailIds) <= 0) {
                $emailerrMsg = "Please enter an email address<br>";
            } else {
                //if( !eregi("^[a-z0-9]+([_\\.-][a-z0-9]+)*"."@([a-z0-9]+([\.-][a-z0-9]+))*$",$fldEmail) )
                if (!preg_match("/^[a-z0-9A-Z]+([_\\.-][a-z0-9A-Z]+)*" . "@([a-z0-9A-Z]+([\.-][a-z0-9A-Z]+))*$/", $strEmailIds)) {
                    $emailerrMsg = "Please enter a valid email address<br>";
                }
            }
        }

        return($emailerrMsg);
    }

    protected function afterSave(){
        parent::afterSave();
        if($this->isNewRecord && Yii::app()->session['review_credit_invitation']){
            $UserMaster = TblUserMaster::model()->find('invite_key = :invite_key', array(':invite_key' => Yii::app()->session['review_credit_invitation']));
            if($UserMaster){
                $ReviewCredit = new ReviewCredit;
                $ReviewCredit->setAttributes(array(
                    'user_ref_id' => $UserMaster->user_id,
                    'credit_from' => 'invite',
                    'added_on' => date('Y-m-d H:i:s'),
                    'used_on' => NULL,
                ), FALSE);
                $ReviewCredit->save(FALSE);
            }
            unset(Yii::app()->session['review_credit_invitation']);
        }
        
        return true;
    }

    protected function beforeSave() {
        if (parent::beforeSave()) {
            if ($this->isNewRecord) {
                //$this->pass_word = md5($this->pass_word);
                //$this->added_on = date('Y-m-d H:i:s');
                return true;
            }
            if ($this->scenario == 'reset-password') {
                //$this->pass_word = md5($this->pass_word);
            }
            if ($this->scenario == 'email-validation') {
                //$this->username = md5($this->pass_word);
                array('username', 'unique', 'className' => 'LoginMaster', 'message' => 'EmailId is already existed. Please enter another email');
            }
            return true;
        }
        return false;
    }

    public function getIdForEmail($email) {
        if ($email) {
            $criteria = new CDbCriteria();
            $criteria->condition = 'username = "' . $email . '"';
            $result = self::model()->find($criteria);
            return $result->login_id;
        }
    }

    public static function updateProfileValidationField($loginRefId = 0, $profileFlag = NULL, $flagStatus = 0, $studentId = 0) {
        $tblLoginMaster = self::model()->findByPk($loginRefId);
        switch ($profileFlag) {
            case 'is_email_confirmed': {
                    $tblLoginMaster->is_email_confirmed = $flagStatus;
                    $studentProfileValidationLogEnum = 'Email';
                    break;
                }
            case 'is_class_status_confirmed': {
                    $tblLoginMaster->is_class_status_confirmed = $flagStatus;
                    $studentProfileValidationLogEnum = 'ClassLevel';
                    break;
                }
            case 'is_preference_confirmed': {
                    $tblLoginMaster->is_preference_confirmed = $flagStatus;
                    $studentProfileValidationLogEnum = 'Preference';
                    break;
                }
            case 'is_umail_update': {
                    $tblLoginMaster->is_umail_update = $flagStatus;
                    $tblLoginMaster->new_umail = '0';
                    $studentProfileValidationLogEnum = 'UmailUpdate';
                    break;
                }
        }
        if ($tblLoginMaster->is_email_confirmed && $tblLoginMaster->is_class_status_confirmed && $tblLoginMaster->is_preference_confirmed) {
            $tblLoginMaster->is_student_profile_confirmed = 1;
            $tblLoginMaster->is_valid = 1;
            $tblLoginMaster->validated_on = date('Y-m-d H:i:s');
            $tblLoginMaster->validated_by = Yii::app()->user->sub_id;
            if (Yii::app()->session->itemAt('studentProfileConfirmationId')) {
                $studentValidationTrackerId = Yii::app()->session->get('studentProfileConfirmationId');
                $model = new StudentValidationTracker();
                $model->updateByPk($studentValidationTrackerId, array('profile_confirm_date' => date('Y-m-d H:i:s')));
                Yii::app()->session->remove('studentProfileConfirmationId');
            }
        } else {
            $tblLoginMaster->is_student_profile_confirmed = 0;
            $tblLoginMaster->is_valid = 0;
        }

        $tblLoginMaster->student_profile_mail_sent = 0;

        $tblLoginMaster->modified_on = date('Y-m-d H:i:s');
        $tblLoginMaster->save(false);
        StudentProfileValidationLog::saveLogData($studentId, $studentProfileValidationLogEnum, $flagStatus, $loginRefId);
    }

    public static function getProfileModifiedStudents($timePeriod = '30minutes') {
        $cdbCriteria = new CDbCriteria();
        switch ($timePeriod) {
            /* case '30Minutes':{
              $dateTime = date('d-m-Y H:i', strtotime('-30 minutes'));
              $cdbCriteria->addCondition("t.modified_on LIKE '$dateTime%'", "AND");
              break;
              } */
            /* case 'morethan3months':{
              $dateTime = date('Y-m-d H:i:s', strtotime('-3 months'));
              $cdbCriteria->addCondition("t.modified_on < '$dateTime'", "or");
              $cdbCriteria->addCondition("t.last_login < '$dateTime'", "or");
              break;
              }
              case 'between3months':{
              $dateTime1 = date('Y-m-d H:i:s', strtotime('-3 months'));
              $dateTime2 = date('Y-m-d H:i:s', strtotime('-30 minutes'));
              $cdbCriteria->addCondition("t.modified_on > '$dateTime1'", "AND");
              $cdbCriteria->addCondition("t.modified_on < '$dateTime2'", "AND");
              break;
              }
             */
            case 'morethan1month': {
                    $dateTime = date('Y-m-d H:i:s', strtotime('-1 month'));
                    $cdbCriteria->addCondition("t.modified_on < '$dateTime'", "or");
                    $cdbCriteria->addCondition("t.last_login < '$dateTime'", "or");
                    break;
                }
            case 'lessthan1month': {
                    $dateTime1 = date('Y-m-d H:i:s', strtotime('-1 month'));
                    $dateTime2 = date('Y-m-d H:i:s', strtotime('-30 minutes'));
                    //$cdbCriteria->addCondition("t.modified_on > '$dateTime1'", "AND");
                    //$cdbCriteria->addCondition("t.modified_on < '$dateTime2'", "AND");
                    $cdbCriteria->condition = "(t.modified_on > '$dateTime1' AND t.modified_on < '$dateTime2') OR (t.last_login > '$dateTime1' AND t.last_login < '$dateTime2')";
                    break;
                }
            default: {//30Minutes
                    $dateTime = date('Y-m-d H:i', strtotime('-30 minutes'));
                    $cdbCriteria->addCondition("t.modified_on LIKE '$dateTime%'", "AND");
                    $cdbCriteria->addCondition("t.is_class_status_confirmed = 1", "AND");
                    $cdbCriteria->addCondition("t.is_preference_confirmed = 1", "AND");
                    break;
                }
        }
        $cdbCriteria->with = "tblUserMasters";
        $cdbCriteria->addCondition('t.is_active = 1', "AND");
        $cdbCriteria->addCondition('t.user_type_ref_id = 1', "AND");
        $cdbCriteria->addCondition("t.is_email_confirmed = 1", "AND");
        $cdbCriteria->addCondition('t.student_profile_mail_sent = 0', "AND");
        $cdbCriteria->addCondition("tblUserMasters.class_status != 'Completed'", "AND");
        $cdbCriteria->addCondition("tblUserMasters.present_class IN ('11', '12')", "AND");
        $cdbCriteria->addCondition("tblUserMasters.passout_year > " . date('Y'), "AND");
        print_r($cdbCriteria);

        $result = self::model()->findAll($cdbCriteria);
        return $result;
    }

    public static function getD2students($registrationDate = 0, $registrationDate1 = 0, $passOutDate = 0) {
        /* $sql = "SELECT um.user_id, lm.username, lm.login_id, um.first_name, um.last_name, um.present_class,tsd.subdomain_slug_name,(lm.is_preference_confirmed+lm.is_class_status_confirmed) AS total_sum
          FROM login_master lm
          INNER JOIN tbl_user_master um ON um.login_ref_id = lm.login_id
          JOIN tbl_si_students ts ON ts.user_ref_id=um.user_id
          JOIN tbl_si_di tsd ON tsd.inst_id = ts.inst_ref_id
          WHERE 1=1
          AND lm.is_active = 1
          AND lm.user_type_ref_id = 1
          AND lm.added_on >= '$registrationDate' and lm.added_on <= '$registrationDate1'
          AND (lm.is_class_status_confirmed = 0 OR lm.is_preference_confirmed = 0)
          AND lm.is_student_profile_confirmed = 0
          AND um.class_status != 'Completed'
          AND um.present_class IN ('11', '12')
          AND CONCAT(um.passout_year, '-', IF(um.passout_month < 10, CONCAT(0, um.passout_month), um.passout_month), '-01 00:00:00') > '$passOutDate'
          AND um.user_id NOT IN (SELECT user_ref_id FROM student_validation_tracker WHERE email_type = 'DAY2')
          HAVING total_sum<>2"; */
        $sql = "SELECT um.user_id, lm.username, lm.login_id, um.first_name, um.last_name, um.present_class,tsd.subdomain_slug_name
                FROM login_master lm
                INNER JOIN tbl_user_master um ON um.login_ref_id = lm.login_id
                LEFT JOIN tbl_si_students ts ON ts.user_ref_id=um.user_id
                LEFT JOIN tbl_si_di tsd ON tsd.inst_id = ts.inst_ref_id
                WHERE lm.user_type_ref_id = 1
		        AND lm.added_on >= '$registrationDate' AND lm.added_on <= '$registrationDate1'
                AND (um.present_class IN ('11', '12') OR um.present_class IS NULL) AND (lm.is_email_confirmed = 0 OR lm.is_class_status_confirmed = 0 OR lm.is_preference_confirmed = 0)
                AND um.user_id NOT IN (SELECT user_ref_id FROM student_validation_tracker WHERE email_type = 'DAY2')";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getNotConfirmedProfiles($lastEmailType = 'DAY2', $lastMailSentDate1 = '', $lastMailSentDate2 = '') {
        /* $sql = "SELECT um.user_id, lm.username, lm.login_id, um.first_name, um.last_name, um.present_class,tsd.subdomain_slug_name
          FROM login_master lm
          INNER JOIN tbl_user_master um ON um.login_ref_id = lm.login_id
          INNER JOIN student_validation_tracker svt ON svt.user_ref_id = um.user_id
          JOIN tbl_si_students ts ON ts.user_ref_id=um.user_id
          JOIN tbl_si_di tsd ON tsd.inst_id = ts.inst_ref_id
          WHERE 1=1
          AND svt.email_type = '$lastEmailType'
          AND lm.is_student_profile_confirmed = 0
          AND svt.is_expired = 0
          AND svt.profile_confirm_date IS NULL
          AND svt.sent_on >= '$lastMailSentDate1' AND svt.sent_on <= '$lastMailSentDate2'"; */

        $sql = "SELECT um.user_id, lm.username, lm.login_id, um.first_name, um.last_name, um.present_class,tsd.subdomain_slug_name, lm.added_on
                FROM login_master lm
                INNER JOIN tbl_user_master um ON um.login_ref_id = lm.login_id
                INNER JOIN student_validation_tracker svt ON svt.user_ref_id = um.user_id
                LEFT JOIN tbl_si_students ts ON ts.user_ref_id=um.user_id
                LEFT JOIN tbl_si_di tsd ON tsd.inst_id = ts.inst_ref_id
                WHERE svt.email_type = '$lastEmailType'
                AND (lm.is_email_confirmed = 0 OR lm.is_class_status_confirmed = 0 OR lm.is_preference_confirmed = 0)
                AND svt.sent_on >= '$lastMailSentDate1' AND svt.sent_on <= '$lastMailSentDate2'";
        $cmd = Yii::app()->db->createCommand($sql);
        $res = $cmd->queryAll();
        return $res;
    }

    public static function getEmailNotConfirmedStudents($registrationDate = 0, $registrationDate1 = 0) {
        $sql = '  SELECT lm.login_id,tum.user_id,lm.is_valid,lm.is_email_confirmed,lm.login_id, um.first_name, um.last_name,lm.added_on,lm.username FROM `login_master` lm
                JOIN tbl_user_master tum
                ON tum.login_ref_id=lm.login_id
                JOIN tbl_user_master um
                ON um.login_ref_id = lm.login_id
                WHERE lm.is_email_confirmed =0  AND lm.is_valid=1 AND tum.added_on BETWEEN "' . $registrationDate . '" AND "' . $registrationDate1 . '"
                ORDER BY tum.user_id ';


        $command = Yii::app()->db->createcommand($sql);
        $result = $command->queryAll();
        return $result;
    }

    public static function getD2Or5NotConfirmedStudents($lastEmailType = 'DAY2', $lastMailSentDate1 = '', $lastMailSentDate2 = '') {

        $sql = '  SELECT lm.login_id,tum.user_id,lm.is_valid,lm.is_email_confirmed,lm.login_id, um.first_name, um.last_name,lm.added_on,lm.username FROM `login_master` lm
                JOIN tbl_user_master tum
                ON tum.login_ref_id=lm.login_id
                JOIN tbl_user_master um
                ON um.login_ref_id = lm.login_id
                INNER JOIN student_validation_tracker svt
                ON svt.user_ref_id = um.user_id
                WHERE lm.is_email_confirmed =0  AND lm.is_valid=1 AND svt.email_type ="' . $lastEmailType . '" AND svt.sent_on BETWEEN "' . $lastMailSentDate1 . '" AND "' . $lastMailSentDate2 . '"
                ORDER BY tum.user_id ';

        $command = Yii::app()->db->createcommand($sql);
        $result = $command->queryAll();
        return $result;
    }

    public static function getUserEmailIdByUserid($uId) {
        $sql = 'SELECT l.username FROM login_master l
                JOIN tbl_user_master t
                ON l.login_id=t.login_ref_id
                WHERE t.user_id=' . $uId . '';
        $command = Yii::app()->db->createcommand($sql);
        $result = $command->queryAll();
        return $result;
    }

    public static function getUserIdAndEmail($uid, $mail) {
        $sql = "SELECT * FROM login_master l
              JOIN tbl_user_master tum
              ON l.login_id = tum.login_ref_id
              WHERE tum.user_id='" . $uid . "' AND l.username='" . $mail . "' ";


        $command = Yii::app()->db->createcommand($sql);
        $result = $command->queryAll();
        return $result;
    }

    public function loginWithRedirectPopup($sUserName = '', $sPassword = '', $sRedirectUrl = '') {

        $this->username = $sUserName;
        $this->pass_word = $sPassword;

        if (!$this->login()) {
            Yii::app()->user->logout();
            Yii::app()->session->open();
            setFlashMessage('error_notify', 'logincontroller.unknown_error');
            Yii::app()->Controller->redirect(array('/login'));
        }


        if (Yii::app()->user->getState('slugname') && $sRedirectUrl) {

            $subDomain = Yii::app()->user->slugname;
            if (!preg_match('/' . $subDomain . '/', $sRedirectUrl)) {
                if (preg_match('/www\./', $sRedirectUrl))
                    $sRedirectUrl = str_replace('www.', $subDomain . '.', $sRedirectUrl);
                else
                    $sRedirectUrl = str_replace('//', '//' . $subDomain . '.', $sRedirectUrl);
            }
        }
        if($sRedirectUrl) {
            exit("<script type='text/javascript'> window.parent.location = '".$sRedirectUrl."';  </script>");
        }
        else {
            exit("<script type='text/javascript'> window.parent.location = '".Yii::app()->user->redirectUrl."';  </script>");
        }
    }
}
