<?php 

class ImageResize{
    

    public static function resize($image_path, $width, $height, $aspect = TRUE){
        $cache_dir = dirname(Yii::app()->request->scriptFile).DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'resized';
        if(!is_dir($cache_dir)) mkdir($cache_dir, 0777, TRUE);
        $types = array(1 => "gif", "jpeg", "png", "swf", "psd", "wbmp"); // used to determine image type
        
        if(!file_exists($image_path) || !is_file($image_path)) return;
        
        if(!($size = getimagesize($image_path))) return; // image doesn't exist
        
        if($aspect){ // adjust to aspect.
            if (($size[1]/$height) > ($size[0]/$width))  // $size[0]:width, [1]:height, [2]:type
                $width = ceil(($size[0]/$size[1]) * $height);
            else
                $height = ceil($width / ($size[0]/$size[1]));
        }
        
        $cache_file_name = $width.'x'.$height.'_'.basename($image_path);
        $cache_file = $cache_dir.DIRECTORY_SEPARATOR.$cache_file_name;

        if(file_exists($cache_file)){
            $csize = getimagesize($cache_file);
            $cached = ($csize[0] == $width && $csize[1] == $height); // image is cached
            if (@filemtime($cache_file) < @filemtime($image_path)) $cached = false;
        }else{
            $cached = false;
        }

        if(!$cached){
            $resize = ($size[0] > $width || $size[1] > $height) || ($size[0] < $width || $size[1] < $height);
            $resize = true;
        }else{
            $resize = false;
        }

        if($resize){
            $image = call_user_func('imagecreatefrom'.$types[$size[2]], $image_path);
            if (function_exists("imagecreatetruecolor") && ($temp = imagecreatetruecolor ($width, $height))) {
                imagecopyresampled ($temp, $image, 0, 0, 0, 0, $width, $height, $size[0], $size[1]);
            } else {
                $temp = imagecreate ($width, $height);
                imagecopyresized ($temp, $image, 0, 0, 0, 0, $width, $height, $size[0], $size[1]);
            }
            call_user_func("image".$types[$size[2]], $temp, $cache_file);
            imagedestroy ($image);
            imagedestroy ($temp);
        } else {
            //copy($image_path, $cache_file);
        }
        
        return Yii::app()->baseUrl.'/images/resized/'.$cache_file_name;
        
    }
    
}
