<?php
require_once( dirname(__FILE__) . '/../../../application_config.php');
// This is the configuration for yiic console application.
// Any writable CConsoleApplication properties can be configured here.
return array(
    'basePath' => dirname(__FILE__) . DIRECTORY_SEPARATOR . '..',
    'name' => 'My Console Application',

    'import' => array(
        'application.models.*',
        'application.components.*',
        'application.modules.user.models.*',
        'application.modules.rights.*',
        'application.modules.rights.components.*',
        'application.extensions.yii-mail.*',
        'application.extensions.crontab.*',
        'application.modules.currency.*',
        'application.modules.currency.models.*',
        'application.modules.sms.models.*',
        'application.modules.pms.models.*',
        'application.modules.counselorsuggest.models.*',
        'application.modules.alertmatch.models.*',
        'application.modules.diadmin.components.*',
        'application.modules.diadmin.models.*',
        'application.modules.diaccount.components.*',
        'application.extensions.SeoManager.*',

        'application.models.di.*',
        'application.modules.di.models.*',
        'application.modules.di.models.base.*',
        'application.modules.di.components.*',
        'application.modules.managewebinar.models.*'
    ),
    // application components
    'components' => array(
        'swiftMailer' => array(
            'class' => 'ext.swiftMailer.SwiftMailer',
        ),
        'mail' => array(
            'class' => 'ext.yii-mail.YiiMail',
            'viewPath' => 'application.views.mail',
            'logging' => true,
            'dryRun' => false
        ),
        'cache' => require_once 'cache.php',
        'urlManager' => array(
            'baseUrl' => ACTUALHOST.'/app',
            'urlFormat' => 'path',
            'showScriptName' => FALSE,
            //'rules' => array(),
            'class' => 'SeoManager',
            'rules' => require_once 'urlRules.php',
        ),
        // uncomment the following to use a MySQL database
        'db' => array(
            'connectionString' => 'mysql:host=' . DBHOST . ';dbname=' . DBNAME,
            'emulatePrepare' => true,
            'username' => DBUSERNAME,
            'password' => DBPASSWORD,
            'charset' => 'utf8',
            'tablePrefix' => '',
        ),
        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class' => 'CFileLogRoute',
                    'levels' => 'info, error, warning',
                    'maxFileSize' => '10240',
                    'logFile' => 'resume.log',
                ),
            ),
        ),
    ),
    'modules' => array(
        'diadmin' => array('defaultController' => 'di'),
        'university',
        'test',
        'sms',
        'di',
        'scholarshipprofile',
    ),
    'params' => array(
        'smtp' => require_once 'smtp.php',
        'params' => require_once 'params.php',
        'curlKey' => 'Uni!variety',
    )
);