<?php
define('DOMESTIC', 'D');
define('NONDOMESTIC', 'ND');

class ValidateCountry extends CComponent {

    public $userId = null;

    public function validateCountryOptions() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id  = '".$this->userId."' AND not_sure = 1";
        $res = StudentPreferredCountry::model()->find($criteria);
        if ($res) {
            return 1;
        }

        //Check whether we have user details or not
        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        $prefCountires = $user->getPreferredCountries();
        $country_ids = array();
        foreach ($prefCountires as $key=>$value) {
            if ($key != NULL) {
                $country_ids[] = $key;
            }
        }

        return (count($country_ids) > 0) ? 1 : 0;
    }

    public function validateCountry() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        $criteria = new CDbCriteria;
        $criteria->condition = "user_ref_id  = '".$this->userId."' AND not_sure = 1";
        $res = StudentPreferredCountry::model()->find($criteria);
        if ($res) {
            return 1;
        }

        //Check whether we have user details or not
        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        //get the school type of the user
        $sql = "SELECT tsd.school_type, tsd.inst_country FROM tbl_si_students AS t INNER JOIN tbl_si_di AS tsd ON tsd.inst_id = t.inst_ref_id WHERE t.user_ref_id = ".$user->user_id;
        $command =Yii::app()->db->createCommand($sql);
        $school_det = $command->queryAll();

        if ($school_det[0]['school_type']) {
            $school_query = " school_type = '".$school_det[0]['school_type']."'";
        } else {
            $school_query = " school_type IS NULL";
        }

        //Get the preference countries of the user
        $prefCountires = $user->getPreferredCountries();
        $country_ids = array();
        foreach ($prefCountires as $key=>$value) {
            $country_ids[] = $key;
        }
        if (!$user->country_ref_id) {
            $user->country_ref_id = $school_det[0]['inst_country'];
        }

        if (!$user->country_ref_id) {
            return 0;
        }

        $pref1 = $this->CheckCountryType($user->country_ref_id, 1,  $country_ids[0]);
        $pref2 = $this->CheckCountryType($user->country_ref_id, 2,  $country_ids[1]);
        $pref3 = $this->CheckCountryType($user->country_ref_id, 3,  $country_ids[2]);

        $user->present_board_ref_id = $user->present_board_ref_id ? $user->present_board_ref_id : 1;

        $gender = " AND gender = '".$user->gender."'";
        $board = " AND board_ref_id = ".$user->present_board_ref_id;

        $criteria = new CDbCriteria;
        $criteria->select = 'score';
        $criteria->condition = $school_query.$gender.$pref1.$pref2.$pref3.$board;
        $result = CountryValidation::model()->find($criteria);
        return $result->score ? $result->score : 0;
    }

    public function validateCountryB2C() {
        if (!$this->userId) { //if userId is not set return 0
            return 0;
        }

        //Check whether we have user details or not
        $user = TblUserMaster::model()->findByPk($this->userId);
        if (!$user->user_id) {
            return 0;
        }

        $school_query = '';
        //Get the preference countries of the user
        $prefCountires = $user->getPreferredCountries();
        $country_ids = array();
        foreach ($prefCountires as $key=>$value) {
            $country_ids[] = $key;
        }
        if (!$user->country_ref_id) {
            $user->country_ref_id = 100;
        }

        if (!$user->country_ref_id) {
            return 0;
        }

        $pref1 = $this->CheckCountryType($user->country_ref_id, 1,  $country_ids[0]);
        $pref2 = $this->CheckCountryType($user->country_ref_id, 2,  $country_ids[1]);
        $pref3 = $this->CheckCountryType($user->country_ref_id, 3,  $country_ids[2]);

        $user->present_board_ref_id = $user->present_board_ref_id ? $user->present_board_ref_id : 1;

        $board = "  board_ref_id = ".$user->present_board_ref_id;
        $gender = $user->gender ? " AND gender = '".$user->gender."'" : '';


        $criteria = new CDbCriteria;
        $criteria->select = 'score';
        $criteria->condition = $board.$school_query.$gender.$pref1.$pref2.$pref3;
        $result = CountryValidation::model()->find($criteria);
        return $result->score ? $result->score : 0;
    }

    private function CheckCountryType ($sourceCountry, $preference, $destinationCountry = null) {
        if ($destinationCountry == null) {
            return " AND p".$preference." IS NULL";
        }

        //if source country is same as destination then it is domestic else non domestic
        if ($sourceCountry == $destinationCountry) {
            return " AND p".$preference." = '".DOMESTIC."' ";
        } else {
            return " AND p".$preference." = '".NONDOMESTIC."' ";
        }
    }
}