<?php
$user = TblUserMaster::model()->findByPk($user_id);

$sec_status = SignupSteps::model()->findByAttributes(array('user_ref_id'=>$user_id, 'step_no'=>2));
if ($sec_status) {
$not_sure = 0;
$studentPreferredCountries = StudentPreferredCountry::getStudentPreferredCountryDetails($user_id);
if ($studentPreferredCountries[0]->not_sure == 1) {
    $not_sure = 1;
} else {
    $prefCountires = $user->getPreferredCountries();
}

$prefCourses = $user->getPreferredCourses();
$depts = array();
foreach ($prefCourses as $course) {
    $dept_det = LookupDepartment::model()->findByPk($course['main_dept_ref_id']);
    $sub = '';
    if ($course['sub_dept_ref_id']) {
        if ($course['course_ref_id']) {
            $courses = Courses::model()->findByPk($course['course_ref_id']);
            if ($courses) {
                $sub = " (Others - ".$courses->course_name.")";
            } else {
                $sub = " (Others)";
            }
        } else {
            $n = strtolower($course['name']);
            if (strpos($n,'others') !== false) {
                $sub = " (Others)";
            } else {
                $sub = " (".$course['name'].")";
            }
        }

    }
    $depts[] = ($sub == '') ? $dept_det->department_name : $dept_det->department_name.$sub;
}

$checked_dept = '';
$studentPreferredDepartments = StudentPreferredDepartment::getStudentPreferredDepartmentDetails($user_id);
if ($studentPreferredDepartments[0]->not_sure == 1) {
    $checked_dept = 'checked';
}

$studentPreferredLikelyPeriods = StudentPreferredPeriod::studentPreferredPeriods($user_id);

?>
<div class="row multi_line small-gutter">
    <div class="row border-bottom gutter_vertical">
        <h3 class="left profile-nav title completed">Preferences</h3>
        <div class="left small uppercase">
            <span class="link-button button-green no-hover disply_rwd">Complete</span>
        </div>
        <a href="javascript:void(0)" class="color-gray right" onclick="load_next(<?php echo $user_id ?>, 'preferences');"><i class="fa fa-pencil small_gutter_r"></i> <span class="small">Edit</span></a>
    </div>
    <div class="gutter_vertical row multi_line">
        <div class="grid_3 pull small_gutter_r">
            <div class="color-gray"><i class="fa fa-map-marker"></i> <span class="small">Preferred Countries</span></div>
            <div class="small">

                <?php
                if ($not_sure == 0) {
                    $countries = array();
                    foreach($prefCountires as $countyID=>$cName){
                        $location = StudentPreferredLocation::getAllPrefLocations($user_id,$countyID);
                        $countries[] = $cName. ($location['location'] ? ' (<span class="small color-gray">'.$location['location'].'</span>)' : '');
                    }
                    echo implode(' <span class="color-gray">|</span> ', $countries);
                } else {
                    echo "Not Decided";
                } ?>
            </div>
        </div>
        <div class="grid_3 pull small_gutter_r">
            <div class="color-gray"><i class="fa fa-globe"></i> <span class="small">Preferred Departments</span></div>
            <div class="small"> <?php if ($checked_dept == '') { echo implode(' <span class="color-gray">|</span> ', $depts); } else { echo "Not Decided"; } ?></div>
        </div>
        <div class="grid_2 pull">
            <div class="color-gray"><i class="fa fa-clock-o"></i> <span class="small">Prospective Sessions</span></div>
            <div class="small">
                <?php
                    foreach ($studentPreferredLikelyPeriods as $value) {
                        $det = LookupLikelyPeriod::model()->findByPk($value->period_ref_id);
                        echo "<div>".$det->months.' '.$value->year."</div>";
                     }
                ?>
            </div>
        </div>
    </div>
</div>

<?php } else { ?>
<div class="row multi_line small-gutter">
    <div class="row border-bottom gutter_vertical">
        <h3 class="left profile-nav title current">Preferences</h3>
        <div class="right left_rwd">
            <button class="button-blue button-small" type="button" disabled="disabled"><i class="fa fa-plus small_gutter_r"></i> Add Preferences</button>
        </div>
    </div>

</div>
<?php } ?>