<?php

class VendorsController extends Controller {

    
    public $focused_countries = array(12 => 'Australia', 36 => 'Canada', 100 => 'India',  154 => 'New Zealand', 190 => 'Singapore', 222 => 'United Arab Emirates',  223 => 'UK', 224 =>'USA');
    // Add code for RBAC
    public function filters() {

        return array(
            'rights',
            'accessControl',
            'postOnly + delete_gallery_item',
        );
    }

    public function init() {
        parent::init();
        Yii::app()->theme = 'pms';
        $this->layout = "//layouts/pms_layout";
    }

    public function actionIndex(){
        $this->setPageTitle(Yii::app()->name . ' - Manage Vendors');
        $criteria = new CDbCriteria();
        $dataProvider = new CActiveDataProvider( 'Vendor', array( 'criteria' => $criteria, ) );
        
        if(isset(Yii::app()->session['Vendor'])) unset(Yii::app()->session['Vendor']);
        
        $this->render('index',compact('dataProvider'));
    }



   public function actionGetGridList() {
        $searchTerm = Yii::app()->request->getParam('search',null);
        $gridData = Vendor::getVendorList($searchTerm, 20);
        $this->renderPartial('_searchResultView', array('gridData' => $gridData, 'search' => $searchTerm),false,true);
        Yii::app()->end();
    }

    public function actionGetGridListOnSearch() {
        $searchTerm = Yii::app()->request->getParam('search',null);
        $gridData = Vendor::getVendorList($searchTerm, 20);
        $this->renderPartial('_searchResultView', array('gridData' => $gridData, 'search' => $searchTerm),false, true);
    }


   public function actionGetGridListByCityAndTest() {
        $city = Yii::app()->request->getParam('city',null);
        $test = Yii::app()->request->getParam('test',null);
        $vendor_type = Yii::app()->request->getParam('vendor_type');
        $gridData = Vendor::getVendorListByCityAndTest($city, $test, 20, $vendor_type);
        $this->renderPartial('_searchResultView', array('gridData' => $gridData, 'city' => $city, 'test' => $test,),false, true);
    }

    public function actionAdd(){
        $this->render('add',compact('foo'));
    }

    public function actionAdd_institute(){
        $this->setPageTitle(Yii::app()->name . ' - Add Institute');

        $Vendor = new Vendor();
        $VendorContact=new VendorContact();
        $VendorAttachment = new VendorAttachment();
        $VendorContactNumber = new VendorContactNumber();
        $VendorLoginMaster  = new VendorLoginMaster;
        
        if(Yii::app()->request->isAjaxRequest){
            $tabular_models = array($VendorContactNumber);
            $this->performAjaxValidation(array($Vendor, $VendorLoginMaster,$VendorContact),$tabular_models);
        }
        
        if (Yii::app()->request->isPostRequest){
            
            $transaction = Yii::app()->db->beginTransaction();
            try{
                $login_master_data = Yii::app()->request->getParam('VendorLoginMaster');
                $VendorLoginMaster->username = $login_master_data['username'];
                $VendorLoginMaster->pass_word=md5(uniqid());
                $VendorLoginMaster->user_type_ref_id=6;
                $VendorLoginMaster->is_active=0;
                $VendorLoginMaster->added_on = date('Y-m-d H:i:s');
                //$VendorLoginMaster->added_by = Yii::app()->user->id;
                if(!$VendorLoginMaster->save(TRUE)) throw new CDbException('LoginMaster save failed');
                
                $Vendor->attributes = Yii::app()->request->getParam('Vendor');
                $Vendor->vendor_type = 'Institute';
                $Vendor->added_by = Yii::app()->user->id;
                $Vendor->added_on = date('Y-m-d H:i:s');
                $Vendor->upload_file('logo', Yii::app()->params['docRootPath'] . '/uploads/vendor/logo');
                //$Vendor->upload_file('center_image', Yii::app()->params['docRootPath'] . '/uploads/vendor/center_image');
                if(!$Vendor->save(true)) throw new CDbException('Vendor save failed');
                
                $VendorContact->vendor_ref_id = $Vendor->vendor_id;
                $VendorContact->login_ref_id = $VendorLoginMaster->login_id;
                $VendorContact->user_type_ref_id = $VendorLoginMaster->user_type_ref_id;
                $VendorContact->attributes = Yii::app()->request->getParam('VendorContact');
                if(!$VendorContact->save(true)) throw new CDbException('VendorContact save failed');

                $vendor_contact_number_data = Yii::app()->request->getParam('VendorContactNumber');
                
                foreach($vendor_contact_number_data as $contact_data){
                    $contact_data = array_filter($contact_data,'strlen');
                    if(empty($contact_data) || count($contact_data) <= 1) continue;
                    $VendorContactNumber = new VendorContactNumber();
                    $VendorContactNumber->attributes = $contact_data;
                    $VendorContactNumber->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    if(!$VendorContactNumber->save(true)) throw new CDbException('VendorContactNumber save failed');
                }
                
                $VendorAttachment->vendor_ref_id = $Vendor->vendor_id;
                $VendorAttachment->save_attachments('attachment_name',Yii::app()->params['docRootPath'] . '/uploads/vendor/attachments');

                $transaction->commit();
                Yii::app()->user->setFlash('alert-success', "Institute Saved!");
                $this->redirect($this->createUrl('view', array('vendor_id' => $Vendor->vendor_id)));
            }catch(Exception $exc){
                Yii::app()->user->setFlash('alert-error', "Institute Save Failed! ".$exc->getMessage());
                $transaction->rollback();
            }
        }

        $yearRange = range('1900', date('Y'));
        rsort($yearRange);
        $established_year = array_combine($yearRange, $yearRange);
        
        $this->render('add_institute',compact('Vendor','established_year','VendorAttachment','VendorContact','VendorContactNumber','VendorLoginMaster'));
     
        
    }
    
    
    public function actionView(){
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        if(!$vendor_id) $vendor_id = Yii::app()->session['vendor']['vendor_id'];
        if(!Vendor::model()->exists('vendor_id=:vendor_id', array(':vendor_id' => $vendor_id))) throw new CHttpException('Page Not Found',404);
        $Vendor = Vendor::model()->findByPk($vendor_id);
        $this->setPageTitle(Yii::app()->name . ' - Preview Vendor '.$Vendor->name);
        Yii::app()->session['Vendor'] = $Vendor->attributes;

        $VendorLoginMaster = new VendorLoginMaster;
        
        $this->render('view',compact('Vendor', 'VendorLoginMaster'));
    }
    
    public function actionChangePassword(){
        $login_id = Yii::app()->request->getParam('id',0);
        $VendorLoginMaster = VendorLoginMaster::model()->findByPk($login_id);
        if(!$VendorLoginMaster) throw new CHttpException(404);
        
        $model = new VendorLoginMaster('new_expert');
        if(Yii::app()->request->isPostRequest){
            
            if(Yii::app()->request->isAjaxRequest){
                echo CActiveForm::validate($model, array('pass_word'));
                Yii::app()->end();
            }
            $data = Yii::app()->request->getParam('VendorLoginMaster');
            
            $VendorLoginMaster->pass_word = md5($data['pass_word']);
            $VendorLoginMaster->is_active = 1;
            $VendorLoginMaster->save(FALSE);
            echo '<script>window.parent.location.reload();</script>';
            Yii::app()->end();
        }
        
        $this->renderPartial('change_password', compact('model', 'VendorLoginMaster'), false, true);
        
    }
    
    public function actionEdit(){
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        if(!Vendor::model()->exists('vendor_id=:vendor_id', array(':vendor_id' => $vendor_id))) throw new CHttpException('Page Not Found',404);

        $Vendor = Vendor::model()->findByPk($vendor_id);
        $this->setPageTitle(Yii::app()->name . ' - Edit Vendor: '.$Vendor->name);
        
        if(Yii::app()->request->isAjaxRequest){
            $tabular_models = array(new VendorContactNumber);
            $login_master_data = Yii::app()->request->getParam('VendorLoginMaster');
            $VendorLoginMaster = VendorLoginMaster::model()->findByPk($login_master_data['login_id']);
            $this->performAjaxValidation(array(new Vendor, $VendorLoginMaster,new VendorContact),$tabular_models);
        }
        
        if(Yii::app()->request->isPostRequest){
            
            $vendor_data = Yii::app()->request->getParam('Vendor');
            $vendor_data['logo'] = $Vendor->logo?$Vendor->logo:'';   //preserve previous name and overwrite the existing logo
            $Vendor->attributes = $vendor_data;
            $Vendor->vendor_type = 'Institute';
            $Vendor->modified_by = Yii::app()->user->id;
            $Vendor->modified_on = date('Y-m-d H:i:s');
            $Vendor->upload_file('logo',Yii::app()->params['docRootPath'] .'/uploads/vendor/logo');
            $login_master_data = Yii::app()->request->getParam('VendorLoginMaster');
            
            $transaction = Yii::app()->db->beginTransaction();
            
            try {
                $Vendor->save(TRUE);
                
                $VendorContact = VendorContact::model()->find('vendor_ref_id='.$Vendor->vendor_id);
                $VendorContact->attributes = Yii::app()->request->getParam('VendorContact');
                $VendorContact->save(TRUE);
                
                $LoginMaster = VendorLoginMaster::model()->findByPk($VendorContact->login_ref_id);
                if($LoginMaster->username != $login_master_data['username']){
                    $LoginMaster->username = $login_master_data['username'];
                    $LoginMaster->login_id = $login_master_data['login_id'];
                    //$LoginMaster->modified_by = Yii::app()->user->id;
                    $LoginMaster->modified_on = date('Y-m-d H:i:s');
                    if(!$LoginMaster->save(TRUE)) throw new CDbException('loginmaster save failed');
                }
                
                VendorContactNumber::model()->deleteAll('vendor_contact_ref_id=:vendor_contact_id',array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                $vendor_contact_number_data = Yii::app()->request->getParam('VendorContactNumber');

                foreach($vendor_contact_number_data as &$contact_data){
                    $contact_data = array_filter($contact_data,'strlen');
                    if(empty($contact_data) || count($contact_data) <= 1) continue;
                    $contact_data['vendor_contact_ref_id'] = $VendorContact->vendor_contact_id;
                    $VendorContactNumber = new VendorContactNumber();
                    $VendorContactNumber->attributes = $contact_data;
                    $VendorContactNumber->save(TRUE);
                }
                $VendorAttachment = new VendorAttachment();
                $VendorAttachment->vendor_ref_id = $Vendor->vendor_id;
                $VendorAttachment->save_attachments('attachment_name',Yii::app()->params['docRootPath'] . '/uploads/vendor/attachments');
                
                $transaction->commit();
                Yii::app()->user->setFlash('alert-success', "Institute Updated!");
                $this->redirect($this->createUrl('view',array('vendor_id'=>$Vendor->vendor_id)));

            } catch (Exception $exc) {
                Yii::app()->user->setFlash('alert-error', "Institute Update Failed! ".$exc->getMessage());
                $transaction->rollback();
            }
        }

        
        $yearRange = range('1900', date('Y'));
        rsort($yearRange);
        $established_year = array_combine($yearRange, $yearRange);
        
        $this->render('edit',compact('Vendor','established_year'));
    }
    
    public function actionActive(){
        $id = Yii::app()->request->getParam('id',0);
        if(!Vendor::model()->exists('vendor_id=:id',array(':id' => $id))) throw new CHttpException(404,'Page Not Found');
        
        $Vendor = Vendor::model()->findByPk($id);
        $Vendor->is_active = $Vendor->is_active?0:1;
        $Vendor->save(FALSE);
        Yii::app()->end();
        
    }
    
    protected function performAjaxValidation($models,$tabular_models = null){
        if(Yii::app()->request->isAjaxRequest){
            if($tabular_models){
                $a = self::modelValidate($models);
                $b = self::modelValidateTabular($tabular_models);
                //print_r(array_merge($a,$b)); exit;
                echo json_encode(array_merge($a,$b));
            }else{
                echo json_encode(self::modelValidate($models));
            }
            Yii::app()->end();
        }
    }
    
    
    protected static function modelValidate($models){
        return json_decode(CActiveForm::validate($models),TRUE);
    }

    protected static function modelValidateTabular($models){
        $result=array();
        if(!is_array($models)) $models=array($models);

        foreach($models as $model){
            
            $modelName = trim(str_replace('\\','_',get_class($model)),'_');
            $model_data = Yii::app()->request->getParam($modelName,array());
            
            foreach($model_data as $i => $data){
                
                if(is_array(end($data))){
                    reset($data);
                    foreach($data as $k => $d){
                        
                        if(isset($d[$model->tableSchema->primaryKey]) && $d[$model->tableSchema->primaryKey]){
                            $model = $model->findByPk($d[$model->tableSchema->primaryKey]);
                        }
                        
                        $model->attributes = $d;
                        $model->validate();
                        foreach($model->getErrors() as $attribute => $error){
                            $result[CHtml::activeId($model,'['.$i.']['.$k.']'.$attribute)] = $error;
                        }
                    }
                    continue;
                }
                
                if(isset($data[$model->tableSchema->primaryKey]) && $data[$model->tableSchema->primaryKey]){
                    $model = $model->findByPk($data[$model->tableSchema->primaryKey]);
                }
                
                $model->attributes = $data;
                $model->validate();
                foreach($model->getErrors() as $attribute => $error){
                    $result[CHtml::activeId($model,'['.$i.']'.$attribute)] = $error;
                }
            }
        }
        return $result;
    }
    
    

    public function actionLoadstates(){
        $data = TblState::model()->findAll(array(
            'select' => 'id,name',
            'condition' => 'country_ref_id=:country_ref_id',
            'order' => 'name asc',
            'params' => array(':country_ref_id' => Yii::app()->request->getParam('country_ref_id',0)),
        ));
        $data=CHtml::listData($data,'id','name');
        echo "<option value=''>Select State</option>";
        foreach($data as $value=>$city_name){
            echo CHtml::tag('option', array('value'=>$value),CHtml::encode($city_name),true);
        }
        Yii::app()->end();
    }    
    
    public function actionLoadcities(){
        $data = TblCityMaster::model()->findAll(array(
            'select' => 'city_id,city_name',
            'condition' => 'state_ref_id=:state_ref_id',
            'order' => 'city_name asc',
            'params' => array(':state_ref_id' => Yii::app()->request->getParam('state_ref_id',0))
        ));
        $data=CHtml::listData($data,'city_id','city_name');
        echo "<option value=''>Select City</option>";
        foreach($data as $value=>$city_name){
            echo CHtml::tag('option', array('value'=>$value),CHtml::encode($city_name),true);
        }
        Yii::app()->end();
    }

    public function actionLoadlocalities(){
        $data = LookupLocality::model()->findAll(array(
            'select' => 'locality_id,locality_name',
            'condition' => 'city_ref_id=:city_ref_id',
            'order' => 'locality_name asc',
            'params' => array(':city_ref_id' => Yii::app()->request->getParam('city_ref_id',0))
        ));
        $data=CHtml::listData($data,'locality_id','locality_name');
        echo "<option value=''>Select Locality</option>";
        foreach($data as $value=>$city_name){
            echo CHtml::tag('option', array('value'=>$value),CHtml::encode($city_name),true);
        }
        Yii::app()->end();
    }
    
    private function disable_weblogroute(){
        foreach (Yii::app()->log->routes as $route){
            if ($route instanceof CWebLogRoute) {
                $route->enabled = false;
            }
        }        
        return true;
    }
    
    public function actiondownload_attachment(){
        $id = Yii::app()->request->getParam('id',0);
        
        if(!VendorAttachment::model()->exists('vendor_attachment_id = :id and vendor_ref_id = '.Yii::app()->session['Vendor']['vendor_id'],array(':id'=>$id))) throw new CHttpException(404,'Page not found');
        
        $attachment = VendorAttachment::model()->findByPk($id);
        $file = Yii::app()->params['docRootPath'] . '/uploads/vendor/attachments/'.$attachment->attachment_name;
        if(!file_exists($file)) throw new CHttpException(404,'Page not found');
        
        $this->disable_weblogroute();
        
        Yii::app()->getRequest()->sendFile($attachment->filename,  file_get_contents($file),null,true);
        
    }
    
    public function actiondelete_attachment(){
        $id = Yii::app()->request->getParam('attachment',0);
        if(!VendorAttachment::model()->exists('vendor_attachment_id=:id',array(':id'=>$id))) throw new CHttpException(404,'Page not found');
        
        $attachment = VendorAttachment::model()->findByPk($id);
        $file = Yii::app()->params['docRootPath'] . '/uploads/vendor/attachments/'.$attachment->attachment_name;
        
        if($attachment->delete()){
            if(file_exists($file)) @unlink($file);
        }
        $this->disable_weblogroute();
        Yii::app()->end();
        
    }
    
    public function actiondelete_logo(){
        
        if(!Yii::app()->request->isAjaxRequest || !Yii::app()->request->isPostRequest) throw new CHttpException(404,'Page not found');
        
        $id = Yii::app()->request->getParam('logo',0);
        if(!Vendor::model()->exists('vendor_id = :id',array(':id' => $id))) throw new CHttpException(404,'Page not found');
        
        $model = Vendor::model()->findByPk($id);
        if($model){
            $model->logo = '';
            $model->save(FALSE);
            
            $logo = Yii::app()->params['docRootPath'].'/uploads/vendor/logo/'.$model->logo;
            if(file_exists($logo) && is_file($logo)) unlink($logo);
        }

        echo json_encode(array('success' => true));
        Yii::app()->end();
        
    }
    
    public function actionAdd_expert(){
        
        $vendor_type = Yii::app()->request->getParam('type');
        
        if(!$vendor_type || !in_array($vendor_type, array('CounsellorExpert', 'TestExpert'))) throw new CHttpException('404', 'vendor type not found');
        
        $VendorContact = new VendorContact;
        $VendorContactNumber = new VendorContactNumber;
        $VendorLoginMaster  = new VendorLoginMaster('new_expert');
        $VendorExpertiseTest  = new VendorExpertiseTest;
        $VendorExpertiseCountry = new VendorExpertiseCountry;
        $VendorExpertiseDepartment = new VendorExpertiseDepartment;
        $VendorExpertiseUniversity = new VendorExpertiseUniversity;
        $VendorExpertInfo = new VendorExpertInfo;
        $VendorExpertQualification = new VendorExpertQualification;
        $VendorExpertCommunication = new VendorExpertCommunication;
        $VendorExpertAwards = new VendorExpertAwards;
        $VendorExpertCertification = new VendorExpertCertification;
        
        if(Yii::app()->request->isAjaxRequest && Yii::app()->request->isPostRequest){
            $tabular_models = array($VendorContactNumber, $VendorExpertQualification, $VendorExpertAwards, $VendorExpertCertification);
            $singular_models = array($VendorExpertCommunication, $VendorExpertInfo, $VendorLoginMaster, $VendorContact);
            if($vendor_type == 'TestExpert'){
                array_push($singular_models, $VendorExpertiseTest);
            }
            if($vendor_type == 'CounsellorExpert'){
                array_push($singular_models, $VendorExpertiseCountry);
                //array_push($singular_models, $VendorExpertiseDepartment);
                //array_push($singular_models, $VendorExpertiseUniversity);
            }
            $this->performAjaxValidation($singular_models,$tabular_models);
        }
        
        if(Yii::app()->request->isPostRequest){
            $transaction = Yii::app()->db->beginTransaction();
            try{ 
                
                $login_master_data = Yii::app()->request->getParam('VendorLoginMaster');
                $VendorLoginMaster->username = $login_master_data['username'];
                $VendorLoginMaster->pass_word = md5($login_master_data['pass_word']);
                $VendorLoginMaster->user_type_ref_id = 6;
                $VendorLoginMaster->is_active = 1;
                $VendorLoginMaster->added_on = date('Y-m-d H:i:s');
                if(!$VendorLoginMaster->save(TRUE)) throw new CDbException('LoginMaster save failed');
                
                $vendor_contact_data = Yii::app()->request->getParam('VendorContact');
                $vendor_expert_info_data = Yii::app()->request->getParam('VendorExpertInfo');
                
                $Vendor = new Vendor;
                $Vendor->vendor_type = $vendor_type;
                $Vendor->name = $vendor_contact_data['first_name'].' '.$vendor_contact_data['last_name'];
                $Vendor->about = $vendor_expert_info_data->experience_info;
                $Vendor->is_active = 1;
                $Vendor->added_by = Yii::app()->user->id;
                $Vendor->added_on = date('Y-m-d H:i:s');
                if(!$Vendor->save(FALSE)) throw new CDbException('Vendor save failed');
                
                $VendorContact->setAttributes($vendor_contact_data, FALSE);
                $VendorContact->vendor_ref_id = $Vendor->vendor_id;
                $VendorContact->user_type_ref_id = $VendorLoginMaster->user_type_ref_id;;
                $VendorContact->login_ref_id = $VendorLoginMaster->login_id;
                if(!$VendorContact->save(TRUE)) throw new CDbException('VendorContact save failed');
                
                $vendor_contact_number_data = Yii::app()->request->getParam('VendorContactNumber');
                
                foreach($vendor_contact_number_data as $contact_data){
                    $contact_data = array_filter($contact_data,'strlen');
                    if(empty($contact_data) || count($contact_data) <= 1) continue;
                    $VendorContactNumber = new VendorContactNumber();
                    $VendorContactNumber->setAttributes($contact_data, FALSE);
                    $VendorContactNumber->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    if(!$VendorContactNumber->save(true)) throw new CDbException('VendorContactNumber save failed');
                }
                
                if($vendor_type == 'CounsellorExpert'){
                    $vendor_expertise_country_data = Yii::app()->request->getParam('VendorExpertiseCountry');
                    if(empty($vendor_expertise_country_data['country_ref_id'])) throw new CDbException('VendorExpertiseCountry no data found');
                    foreach(explode(',', $vendor_expertise_country_data['country_ref_id']) as $country_id){
                        if(!$country_id) continue;
                        $VendorExpertiseCountry = new VendorExpertiseCountry;
                        $VendorExpertiseCountry->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseCountry->country_ref_id = $country_id;
                        $VendorExpertiseCountry->is_active = 'Y';
                        if(!$VendorExpertiseCountry->save(TRUE)) throw new CDbException('VendorExpertiseCountry save failed');
                    }
                    
                    $vendor_expertise_department_data = Yii::app()->request->getParam('VendorExpertiseDepartment');
                    //if(!$vendor_expertise_department_data) throw new CDbException('VendorExpertiseDepartment no data found');
                    foreach(explode(',', $vendor_expertise_department_data['main_dept_ref_id']) as $department_id){
                        if(!$department_id) continue;
                        $VendorExpertiseDepartment = new VendorExpertiseDepartment;
                        $VendorExpertiseDepartment->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseDepartment->main_dept_ref_id = $department_id;
                        $VendorExpertiseDepartment->is_active = 'Y';
                        if(!$VendorExpertiseDepartment->save(TRUE)) throw new CDbException('VendorExpertiseDepartment save failed');
                    }
                    
                    $vendor_expertise_university_data = Yii::app()->request->getParam('VendorExpertiseUniversity');
                    //if(!$vendor_expertise_university_data) throw new CDbException('VendorExpertiseUniversity no data found');
                    foreach(explode(',', $vendor_expertise_university_data['uni_ref_id']) as $university_id){
                        if(!$university_id) continue;
                        $VendorExpertiseUniversity = new VendorExpertiseUniversity;
                        $VendorExpertiseUniversity->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseUniversity->uni_ref_id = $university_id;
                        $VendorExpertiseUniversity->is_active = 'Y';
                        if(!$VendorExpertiseUniversity->save(TRUE)) throw new CDbException('VendorExpertiseUniversity save failed');
                    }
                }
                
                if($vendor_type == 'TestExpert'){
                    $vendor_expertise_test_data = Yii::app()->request->getParam('VendorExpertiseTest');
                    if(!$vendor_expertise_test_data) throw new CDbException('VendorExpertiseTest no data found');
                    foreach(explode(',', $vendor_expertise_test_data['entrance_ref_id']) as $exam_id){
                        $VendorExpertiseTest = new VendorExpertiseTest;
                        $VendorExpertiseTest->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseTest->entrance_ref_id = $exam_id;
                        $VendorExpertiseTest->is_active = 'Y';
                        if(!$VendorExpertiseTest->save(TRUE)) throw new CDbException('VendorExpertiseTest save failed');
                    }
                }
                
                $VendorExpertInfo->setAttributes($vendor_expert_info_data, FALSE);
                $VendorExpertInfo->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                $VendorExpertInfo->added_on = date('Y-m-d H:i:s');
                $VendorExpertInfo->upload_file('photo_name', Yii::app()->params['docRootPath'] . '/uploads/vendor/experts');
                if(!$VendorExpertInfo->save(TRUE)) throw new CDbException('VendorExpertInfo save failed');
                
                $vendor_expert_qualification_data = Yii::app()->request->getParam('VendorExpertQualification', array());
                if(empty($vendor_expert_qualification_data)) throw new CDbException('VendorExpertQualification no data found');
                foreach($vendor_expert_qualification_data as $qualification){
                    if(!array_filter($qualification, 'strlen')) continue;
                    $VendorExpertQualification = new VendorExpertQualification;
                    $VendorExpertQualification->setAttributes($qualification, FALSE);
                    $VendorExpertQualification->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    if(!$VendorExpertQualification->save(TRUE)) throw new CDbException('VendorExpertQualification save failed');
                }
                
                $vendor_expert_communication_data = Yii::app()->request->getParam('VendorExpertCommunication', array());
                if(!$vendor_expert_communication_data) throw new CDbException('VendorExpertCommunication no data found');
                $VendorExpertCommunication->setAttributes($vendor_expert_communication_data, FALSE);
                $VendorExpertCommunication->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                if($VendorExpertCommunication->communication_type == 'Online'){
                    $expert_communication_data = Yii::app()->request->getParam('ExpertCommunication', array());
                    if(empty($expert_communication_data)) throw new CDbException('ExpertCommunication no data found');
                    $VendorExpertCommunication->skype_id = $expert_communication_data['skype'];
                    $VendorExpertCommunication->google_hangout_id = $expert_communication_data['google'];
                }
                if(!$VendorExpertCommunication->save(TRUE)) throw new CDbException('VendorExpertCommunication save failed');
                
                $vendor_expert_award_data = Yii::app()->request->getParam('VendorExpertAwards', array());
                foreach($vendor_expert_award_data as $award){
                    if(!strlen($award['file_name'])) continue;
                    $VendorExpertAwards = new VendorExpertAwards;
                    $VendorExpertAwards->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    $VendorExpertAwards->file_name = $award['file_name'];
                    if(!$VendorExpertAwards->save(TRUE)) throw new CDbException('VendorExpertAwards save falied');
                }
                
                $vendor_expert_certification_data = Yii::app()->request->getParam('VendorExpertCertification', array());
                foreach($vendor_expert_certification_data as $cirtificate){
                    if(!strlen($cirtificate['file_name'])) continue;
                    $VendorExpertCertification = new VendorExpertCertification;
                    $VendorExpertCertification->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    $VendorExpertCertification->file_name = $cirtificate['file_name'];
                    if(!$VendorExpertCertification->save(TRUE)) throw new CDbException('VendorExpertCertification save failed');
                }

                $transaction->commit();
                Yii::app()->user->setFlash('alert-success', "Vendor Saved!");
                $this->redirect($this->createUrl('/vendor/vendors'));
            }catch(Exception $exc){
                Yii::app()->user->setFlash('alert-error', "Vendor Save Failed! ".$exc->getMessage());
                $transaction->rollback();
            }
        }

        $focused_countries = $this->focused_countries;
        $entrance_exams = array();
        foreach(EntranceExam::model()->findAll(array('select' => 'entrance_id, entrance_short_name', 'condition' => 'is_active = 1')) as $exam){
            $entrance_exams[] = array('id' => $exam->entrance_id, 'name' => $exam->entrance_short_name);
        }
        
        $departments = array();
        foreach(LookupDepartment::model()->findAll(array('select' => 'department_id, department_name', 'condition' => 'parent_dept_id = 0 AND is_active = "Y"')) as $department){
            $departments[] = array('id' => $department->department_id, 'name' => $department->department_name);
        }
        
        $colleges = array();
        foreach(TblUniversityMaster::model()->findAll(array('select' => 'uni_id, uni_name', 'condition' => 'is_user_entered = "0" AND is_active = "Y"')) as $college){
            $colleges[] = array('id' => $college->uni_id, 'name' => $college->uni_name);
        }
        
        $this->render('add_expert',compact(
                'VendorAttachment', 
                'VendorContact', 
                'VendorContactNumber', 
                'VendorLoginMaster', 
                'vendor_type', 
                'VendorExpertiseTest',
                'VendorExpertiseCountry',
                'VendorExpertiseDepartment',
                'VendorExpertiseUniversity',
                'VendorExpertInfo',
                'VendorExpertQualification',
                'VendorExpertCommunication',
                'focused_countries',
                'VendorExpertAwards',
                'VendorExpertCertification',
                'entrance_exams',
                'departments',
                'colleges'
        ));
    }
    
    public function actionedit_expert(){
        $vendor_id = Yii::app()->request->getParam('vendor_id', 0);
        if(!Vendor::model()->exists('vendor_id = :vendor_id', array(':vendor_id' => $vendor_id))) throw new CHttpException(404);
        
        if(Yii::app()->request->isPostRequest){
            
            if(Yii::app()->request->isAjaxRequest){
                $tabular_models = array(new VendorContactNumber, new VendorExpertQualification, new VendorExpertAwards, new VendorExpertCertification);
                $login_master_data = Yii::app()->request->getParam('VendorLoginMaster');
                $VendorLoginMaster = VendorLoginMaster::model()->findByPk($login_master_data['login_id']);
                $singular_models = array(
                    new VendorContact,
                    $VendorLoginMaster,
                    new VendorExpertInfo,
                    new VendorExpertCommunication,
                );
                
                $Vendor = Vendor::model()->findByPk($vendor_id);
                if($Vendor->vendor_type == 'TestExpert'){
                    array_push($singular_models, new VendorExpertiseTest);
                }
                if($Vendor->vendor_type == 'CounsellorExpert'){
                    array_push($singular_models, new VendorExpertiseCountry);
                    //array_push($singular_models, new VendorExpertiseDepartment);
                    //array_push($singular_models, new VendorExpertiseUniversity);
                }
                
                $this->performAjaxValidation($singular_models, $tabular_models);
            }
            
            $transaction = Yii::app()->db->beginTransaction();
            try{
                $login_master_data = Yii::app()->request->getParam('VendorLoginMaster');
                $VendorLoginMaster = VendorLoginMaster::model()->findByPk($login_master_data['login_id']);
                $VendorLoginMaster->username = $login_master_data['username'];
                if($login_master_data['pass_word']) $VendorLoginMaster->pass_word = md5($login_master_data['pass_word']);
                $VendorLoginMaster->user_type_ref_id = 6;
                $VendorLoginMaster->is_active = 1;
                $VendorLoginMaster->modified_on = date('Y-m-d H:i:s');
                if(!$VendorLoginMaster->save(TRUE)) throw new CDbException('LoginMaster save failed');
                
                $vendor_contact_data = Yii::app()->request->getParam('VendorContact');
                $vendor_expert_info_data = Yii::app()->request->getParam('VendorExpertInfo');
                
                $Vendor = Vendor::model()->findByPk($vendor_id);
                $Vendor->name = $vendor_contact_data['first_name'].' '.$vendor_contact_data['last_name'];
                $Vendor->about = $vendor_expert_info_data->experience_info;
                $Vendor->is_active = 1;
                $Vendor->modified_by = Yii::app()->user->id;
                $Vendor->modified_on = date('Y-m-d H:i:s');
                if(!$Vendor->save(FALSE)) throw new CDbException('Vendor save failed');
                
                $VendorContact = VendorContact::model()->find('vendor_ref_id = '.$vendor_id);
                $VendorContact->setAttributes($vendor_contact_data, FALSE);
                $VendorContact->vendor_ref_id = $Vendor->vendor_id;
                $VendorContact->user_type_ref_id = $VendorLoginMaster->user_type_ref_id;;
                $VendorContact->login_ref_id = $VendorLoginMaster->login_id;
                if(!$VendorContact->save(TRUE)) throw new CDbException('VendorContact save failed');
                
                $vendor_contact_number_data = Yii::app()->request->getParam('VendorContactNumber');
                VendorContactNumber::model()->deleteAll('vendor_contact_ref_id=:vendor_contact_id',array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                foreach($vendor_contact_number_data as $contact_data){
                    $contact_data = array_filter($contact_data,'strlen');
                    if(empty($contact_data) || count($contact_data) <= 1) continue;
                    $VendorContactNumber = new VendorContactNumber();
                    $VendorContactNumber->setAttributes($contact_data, FALSE);
                    $VendorContactNumber->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    if(!$VendorContactNumber->save(true)) throw new CDbException('VendorContactNumber save failed');
                }
                
                if($Vendor->vendor_type == 'CounsellorExpert'){
                    VendorExpertiseCountry::model()->deleteAll('vendor_contact_ref_id = :vendor_contact_id', array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                    $vendor_expertise_country_data = Yii::app()->request->getParam('VendorExpertiseCountry');
                    if(empty($vendor_expertise_country_data['country_ref_id'])) throw new CDbException('VendorExpertiseCountry no data found');
                    foreach(explode(',', $vendor_expertise_country_data['country_ref_id']) as $country_id){
                        if(!$country_id) continue;
                        $VendorExpertiseCountry = new VendorExpertiseCountry;
                        $VendorExpertiseCountry->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseCountry->country_ref_id = $country_id;
                        $VendorExpertiseCountry->is_active = 'Y';
                        if(!$VendorExpertiseCountry->save(TRUE)) throw new CDbException('VendorExpertiseCountry save failed');
                    }
                    
                    VendorExpertiseDepartment::model()->deleteAll('vendor_contact_ref_id = :vendor_contact_id', array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                    $vendor_expertise_department_data = Yii::app()->request->getParam('VendorExpertiseDepartment');
                    //if(!$vendor_expertise_department_data) throw new CDbException('VendorExpertiseDepartment no data found');
                    foreach(explode(',', $vendor_expertise_department_data['main_dept_ref_id']) as $department_id){
                        if(!$department_id) continue;
                        $VendorExpertiseDepartment = new VendorExpertiseDepartment;
                        $VendorExpertiseDepartment->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseDepartment->main_dept_ref_id = $department_id;
                        $VendorExpertiseDepartment->is_active = 'Y';
                        if(!$VendorExpertiseDepartment->save(TRUE)) throw new CDbException('VendorExpertiseDepartment save failed');
                    }
                    
                    VendorExpertiseUniversity::model()->deleteAll('vendor_contact_ref_id = :vendor_contact_id', array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                    $vendor_expertise_university_data = Yii::app()->request->getParam('VendorExpertiseUniversity');
                    //if(!$vendor_expertise_university_data) throw new CDbException('VendorExpertiseUniversity no data found');
                    foreach(explode(',', $vendor_expertise_university_data['uni_ref_id']) as $university_id){
                        if(!$university_id) continue;
                        $VendorExpertiseUniversity = new VendorExpertiseUniversity;
                        $VendorExpertiseUniversity->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseUniversity->uni_ref_id = $university_id;
                        $VendorExpertiseUniversity->is_active = 'Y';
                        if(!$VendorExpertiseUniversity->save(TRUE)) throw new CDbException('VendorExpertiseUniversity save failed');
                    }
                }
                
                if($Vendor->vendor_type == 'TestExpert'){
                    VendorExpertiseTest::model()->deleteAll('vendor_contact_ref_id = :vendor_contact_id', array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                    $vendor_expertise_test_data = Yii::app()->request->getParam('VendorExpertiseTest');
                    if(!$vendor_expertise_test_data) throw new CDbException('VendorExpertiseTest no data found');
                    foreach(explode(',', $vendor_expertise_test_data['entrance_ref_id']) as $exam_id){
                        $VendorExpertiseTest = new VendorExpertiseTest;
                        $VendorExpertiseTest->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                        $VendorExpertiseTest->entrance_ref_id = $exam_id;
                        $VendorExpertiseTest->is_active = 'Y';
                        if(!$VendorExpertiseTest->save(TRUE)) throw new CDbException('VendorExpertiseTest save failed');
                    }
                }
                
                $VendorExpertInfo = $VendorContact->vendorExpertInfo;
                unset($vendor_expert_info_data['photo_name']); // preserve old photo name
                $VendorExpertInfo->setAttributes($vendor_expert_info_data, FALSE);
                $VendorExpertInfo->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                $VendorExpertInfo->upload_file('photo_name', Yii::app()->params['docRootPath'] . '/uploads/vendor/experts');
                if(!$VendorExpertInfo->save(TRUE)) throw new CDbException('VendorExpertInfo save failed');
                
                VendorExpertQualification::model()->deleteAll('vendor_contact_ref_id = :vendor_contact_id', array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                $vendor_expert_qualification_data = Yii::app()->request->getParam('VendorExpertQualification', array());
                if(empty($vendor_expert_qualification_data)) throw new CDbException('VendorExpertQualification no data found');
                foreach($vendor_expert_qualification_data as $qualification){
                    if(!array_filter($qualification, 'strlen')) continue;
                    $VendorExpertQualification = new VendorExpertQualification;
                    $VendorExpertQualification->setAttributes($qualification, FALSE);
                    $VendorExpertQualification->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    if(!$VendorExpertQualification->save(TRUE)) throw new CDbException('VendorExpertQualification save failed');
                }
                
                $vendor_expert_communication_data = Yii::app()->request->getParam('VendorExpertCommunication', array());
                if(!$vendor_expert_communication_data) throw new CDbException('VendorExpertCommunication no data found');
                $VendorExpertCommunication = $VendorContact->vendorExpertCommunication;
                $VendorExpertCommunication->setAttributes($vendor_expert_communication_data, FALSE);
                $VendorExpertCommunication->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                if($VendorExpertCommunication->communication_type == 'Online'){
                    $expert_communication_data = Yii::app()->request->getParam('ExpertCommunication', array());
                    if(empty($expert_communication_data)) throw new CDbException('ExpertCommunication no data found');
                    $VendorExpertCommunication->skype_id = $expert_communication_data['skype'];
                    $VendorExpertCommunication->google_hangout_id = $expert_communication_data['google'];
                }else{
                    $VendorExpertCommunication->skype_id = NULL;
                    $VendorExpertCommunication->google_hangout_id = NULL;
                }
                if(!$VendorExpertCommunication->save(TRUE)) throw new CDbException('VendorExpertCommunication save failed');
                
                VendorExpertAwards::model()->deleteAll('vendor_contact_ref_id = :vendor_contact_id', array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                $vendor_expert_award_data = Yii::app()->request->getParam('VendorExpertAwards', array());
                foreach($vendor_expert_award_data as $award){
                    if(!strlen($award['file_name'])) continue;
                    $VendorExpertAwards = new VendorExpertAwards;
                    $VendorExpertAwards->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    $VendorExpertAwards->file_name = $award['file_name'];
                    if(!$VendorExpertAwards->save(TRUE)) throw new CDbException('VendorExpertAwards save falied');
                }
                
                VendorExpertCertification::model()->deleteAll('vendor_contact_ref_id = :vendor_contact_id', array(':vendor_contact_id' => $VendorContact->vendor_contact_id));
                $vendor_expert_certification_data = Yii::app()->request->getParam('VendorExpertCertification', array());
                foreach($vendor_expert_certification_data as $cirtificate){
                    if(!strlen($cirtificate['file_name'])) continue;
                    $VendorExpertCertification = new VendorExpertCertification;
                    $VendorExpertCertification->vendor_contact_ref_id = $VendorContact->vendor_contact_id;
                    $VendorExpertCertification->file_name = $cirtificate['file_name'];
                    if(!$VendorExpertCertification->save(TRUE)) throw new CDbException('VendorExpertCertification save failed');
                }

                $transaction->commit();
                Yii::app()->user->setFlash('alert-success', "Vendor Saved!");
                $this->redirect($this->createUrl('view_expert', array('vendor_id' => $Vendor->vendor_id)));
            }catch(Exception $exc){
                Yii::app()->user->setFlash('alert-error', "Vendor Save Failed! ".$exc->getMessage());
                $transaction->rollback();
            }
            
        }
        
        $criteria = new CDbCriteria();
        $criteria->with = array(
            'vendorRef',
            'loginRef',
            'vendorContactNumbers',
            'vendorExpertAwards',
            'vendorExpertCertifications',
            'vendorExpertCommunication',
            'vendorExpertInfo',
            'vendorExpertQualifications',
            'vendorExpertiseCountries',
            'vendorExpertiseDepartments',
            'vendorExpertiseTests',
            'vendorExpertiseUniversities',
        );
       
        
        $focused_countries = $this->focused_countries;
        $entrance_exams = array();
        foreach(EntranceExam::model()->findAll(array('select' => 'entrance_id, entrance_short_name', 'condition' => 'is_active = 1')) as $exam){
            $entrance_exams[] = array('id' => $exam->entrance_id, 'name' => $exam->entrance_short_name);
        }
        
        $departments = array();
        foreach(LookupDepartment::model()->findAll(array('select' => 'department_id, department_name', 'condition' => 'parent_dept_id = 0 AND is_active = "Y"')) as $department){
            $departments[] = array('id' => $department->department_id, 'name' => $department->department_name);
        }
        
        $colleges = array();
        foreach(TblUniversityMaster::model()->findAll(array('select' => 'uni_id, uni_name', 'condition' => 'is_user_entered = "0" AND is_active = "Y"')) as $college){
            $colleges[] = array('id' => $college->uni_id, 'name' => $college->uni_name);
        }
        
        $criteria->addCondition('t.vendor_ref_id = '.$vendor_id);
        $Expert = VendorContact::model()->find($criteria);
        $vendor_type = $Expert->vendorRef->vendor_type;
        $this->render('edit_expert', compact('Expert', 'focused_countries', 'entrance_exams', 'departments', 'colleges', 'vendor_type'));
        
        
    }
    
    public function actionview_expert(){
        $vendor_id = Yii::app()->request->getParam('vendor_id', 0);
        if(!Vendor::model()->exists('vendor_id = :vendor_id', array(':vendor_id' => $vendor_id))) throw new CHttpException(404);
       
        $criteria = new CDbCriteria();
        $criteria->with = array(
            'vendorRef',
            'loginRef',
            'vendorContactNumbers',
            'vendorExpertAwards',
            'vendorExpertCertifications',
            'vendorExpertCommunication',
            'vendorExpertInfo',
            'vendorExpertQualifications',
            'vendorExpertiseCountries',
            'vendorExpertiseDepartments',
            'vendorExpertiseTests',
            'vendorExpertiseUniversities',
            'vendorExpertInfo.lookupCurrencyRef',
        );
        
        $criteria->addCondition('t.vendor_ref_id = '.$vendor_id);
        $Expert = VendorContact::model()->find($criteria);
        
        $vendor_type = $Expert->vendorRef->vendor_type;
        $this->render('view_expert', compact('Expert', 'vendor_type'));
        
    }
    
    public function actionadd_more_qualification(){
        $index = Yii::app()->request->getParam('index', uniqid());
        $VendorExpertQualification = new VendorExpertQualification;
        $this->renderPartial('_add_more_qualification', compact('VendorExpertQualification', 'index'));
        Yii::app()->end();
    }
    
    public function actionadd_more_awards(){
        $index = Yii::app()->request->getParam('index', uniqid());
        $VendorExpertAwards  = new VendorExpertAwards;
        $this->renderPartial('_add_more_awards', compact('VendorExpertAwards', 'index'));
        Yii::app()->end();
    }
    
    public function actionadd_more_certificates(){
        $index = Yii::app()->request->getParam('index', uniqid());
        $VendorExpertCertification  = new VendorExpertCertification;
        $this->renderPartial('_add_more_certificates', compact('VendorExpertCertification', 'index'));
        Yii::app()->end();
    }
    
    public function actionloadcities_by_country(){
        $country_ref_id = Yii::app()->request->getParam('country_ref_id');
        $data = '<option value="">Select City</option>';
        if(!$country_ref_id){
            echo $data;
            Yii::app()->end();
        }
        
        foreach(TblCityMaster::model()->findAll('country_id = :country_id AND is_active = "Y"', array(':country_id' => $country_ref_id)) as $city){
            $data .= CHtml::tag('option', array('value' => $city->city_id), CHtml::encode($city->city_name));
        }
        
        echo $data;
        Yii::app()->end();
    }
    
}
